/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.certificate;

import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.exception.IntegrationCertificateException;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class CertificateHandler {
    public static final String PEER_CERTIFICATES = "PEER_CERTIFICATES";
    private final IntLogger logger;
    private int timeout = 120;
    private ProxyInfo proxyInfo = ProxyInfo.NO_PROXY_INFO;
    private File javaHomeOverride;

    public CertificateHandler(IntLogger intLogger) {
        this.logger = intLogger;
    }

    public CertificateHandler(IntLogger intLogger, File javaHomeOverride) {
        this(intLogger);
        this.javaHomeOverride = javaHomeOverride;
    }

    public void retrieveAndImportHttpsCertificate(URL url) throws IntegrationException {
        if (url == null || !url.getProtocol().startsWith("https")) {
            return;
        }
        try {
            Certificate certificate = this.retrieveHttpsCertificateFromURL(url);
            if (certificate == null) {
                throw new IntegrationCertificateException(String.format("Could not retrieve the Certificate from %s", url));
            }
            this.importHttpsCertificate(url, certificate);
        }
        catch (IntegrationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IntegrationException(e.getMessage(), (Throwable)e);
        }
    }

    public Certificate retrieveHttpsCertificateFromURL(URL url) throws IntegrationException {
        if (url == null || !url.getProtocol().startsWith("https")) {
            return null;
        }
        this.logger.info(String.format("Retrieving the certificate from %s", url));
        Certificate certificate = null;
        try {
            HttpClient client = this.getHttpClient(url);
            RequestBuilder requestBuilder = RequestBuilder.create((String)"GET");
            requestBuilder.setUri(url.toURI());
            HttpUriRequest request = requestBuilder.build();
            BasicHttpContext context = new BasicHttpContext();
            client.execute(request, (HttpContext)context);
            Certificate[] peerCertificates = (Certificate[])context.getAttribute(PEER_CERTIFICATES);
            certificate = peerCertificates[0];
        }
        catch (Exception e) {
            throw new IntegrationException((Throwable)e);
        }
        return certificate;
    }

    protected HttpClient getHttpClient(URL url) throws IntegrationException {
        try {
            KeyStore keyStore;
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            RequestConfig.Builder defaultRequestConfigBuilder = RequestConfig.custom();
            defaultRequestConfigBuilder.setConnectTimeout(this.timeout);
            defaultRequestConfigBuilder.setSocketTimeout(this.timeout);
            defaultRequestConfigBuilder.setConnectionRequestTimeout(this.timeout);
            if (this.proxyInfo == null) {
                throw new IllegalStateException("The proxy information can not be null.");
            }
            if (this.proxyInfo.shouldUseProxyForUrl(url)) {
                defaultRequestConfigBuilder.setProxy(new HttpHost(this.proxyInfo.getHost(), this.proxyInfo.getPort()));
                try {
                    NTCredentials creds = new NTCredentials(this.proxyInfo.getUsername(), this.proxyInfo.getDecryptedPassword(), this.proxyInfo.getNtlmWorkstation(), this.proxyInfo.getNtlmDomain());
                    credentialsProvider.setCredentials(new AuthScope(this.proxyInfo.getHost(), this.proxyInfo.getPort()), (Credentials)creds);
                }
                catch (EncryptionException | IllegalArgumentException ex) {
                    throw new IntegrationException(ex);
                }
            }
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            clientBuilder.setDefaultRequestConfig(defaultRequestConfigBuilder.build());
            File trustStore = this.getTrustStore();
            try {
                keyStore = this.getKeyStore(trustStore);
            }
            catch (Exception e) {
                throw new IntegrationException((Throwable)e);
            }
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(keyStore, (TrustStrategy)new TrustAllStrategy()).build();
            NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
            SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts);
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory);
            HttpResponseInterceptor certificateInterceptor = (httpResponse, context) -> {
                ManagedHttpClientConnection routedConnection = (ManagedHttpClientConnection)context.getAttribute("http.connection");
                SSLSession sslSession = routedConnection.getSSLSession();
                if (sslSession != null) {
                    Certificate[] certificates = sslSession.getPeerCertificates();
                    context.setAttribute(PEER_CERTIFICATES, (Object)certificates);
                }
            };
            clientBuilder.addInterceptorLast(certificateInterceptor);
            return clientBuilder.build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IntegrationException(e.getMessage(), (Throwable)e);
        }
    }

    public Certificate retrieveHttpsCertificateFromTrustStore(URL url) throws IntegrationException {
        File trustStore = this.getTrustStore();
        String trustStorePath = trustStore.getAbsolutePath();
        this.logger.info(String.format("Removing the certificate from %s", trustStorePath));
        try {
            KeyStore keyStore = this.getKeyStore(trustStore);
            if (keyStore.containsAlias(url.getHost())) {
                return keyStore.getCertificate(url.getHost());
            }
        }
        catch (Exception e) {
            throw new IntegrationException((Throwable)e);
        }
        return null;
    }

    public void importHttpsCertificate(URL url, Certificate certificate) throws IntegrationException {
        File trustStore = this.getTrustStore();
        String trustStorePath = trustStore.getAbsolutePath();
        this.logger.info(String.format("Importing the certificate from %s into keystore %s", url.getHost(), trustStorePath));
        try {
            KeyStore keyStore = this.getKeyStore(trustStore);
            keyStore.setCertificateEntry(url.getHost(), certificate);
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(trustStore));){
                keyStore.store(stream, this.getKeyStorePassword());
            }
        }
        catch (Exception e) {
            throw new IntegrationException((Throwable)e);
        }
    }

    public void removeHttpsCertificate(URL url) throws IntegrationException {
        block14: {
            File trustStore = this.getTrustStore();
            String trustStorePath = trustStore.getAbsolutePath();
            this.logger.info(String.format("Removing the certificate from %s", trustStorePath));
            try {
                KeyStore keyStore = this.getKeyStore(trustStore);
                if (!keyStore.containsAlias(url.getHost())) break block14;
                keyStore.deleteEntry(url.getHost());
                try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(trustStore));){
                    keyStore.store(stream, this.getKeyStorePassword());
                }
            }
            catch (Exception e) {
                throw new IntegrationException((Throwable)e);
            }
        }
    }

    public boolean isCertificateInTrustStore(URL url) throws IntegrationException {
        File trustStore = this.getTrustStore();
        if (!trustStore.isFile()) {
            return false;
        }
        String jssecacertsPath = trustStore.getAbsolutePath();
        this.logger.info(String.format("Checking for alias %s in keystore %s", url.getHost(), jssecacertsPath));
        try {
            KeyStore keyStore = this.getKeyStore(trustStore);
            return keyStore.containsAlias(url.getHost());
        }
        catch (Exception e) {
            throw new IntegrationException((Throwable)e);
        }
    }

    public KeyStore getKeyStore(File trustStore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (trustStore.isFile() && trustStore.length() > 0L) {
            KeyStore.PasswordProtection protection = new KeyStore.PasswordProtection(this.getKeyStorePassword());
            return KeyStore.Builder.newInstance(this.getTrustStoreType(), null, trustStore, protection).getKeyStore();
        }
        KeyStore keyStore = KeyStore.getInstance(this.getTrustStoreType());
        keyStore.load(null, null);
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(trustStore));){
            keyStore.store(stream, this.getKeyStorePassword());
        }
        return keyStore;
    }

    public File getTrustStore() {
        File trustStore;
        if (this.javaHomeOverride != null) {
            trustStore = this.resolveTrustStoreFile(this.javaHomeOverride);
        } else {
            trustStore = new File(System.getProperty("javax.net.ssl.trustStore", ""));
            if (!trustStore.isFile()) {
                File javaHome = new File(System.getProperty("java.home"));
                trustStore = this.resolveTrustStoreFile(javaHome);
            }
        }
        return trustStore;
    }

    private String getTrustStoreType() {
        return System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
    }

    private char[] getKeyStorePassword() {
        return System.getProperty("javax.net.ssl.trustStorePassword", "changeit").toCharArray();
    }

    private File resolveTrustStoreFile(File javaHome) {
        File trustStoreFile = new File(javaHome, "lib");
        trustStoreFile = new File(trustStoreFile, "security");
        if (!(trustStoreFile = new File(trustStoreFile, "jssecacerts")).isFile()) {
            trustStoreFile = new File(javaHome, "lib");
            trustStoreFile = new File(trustStoreFile, "security");
            trustStoreFile = new File(trustStoreFile, "cacerts");
        }
        return trustStoreFile;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public void setProxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
    }
}

