/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.proxy;

import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.rest.credentials.Credentials;
import com.synopsys.integration.util.Stringable;
import com.synopsys.integration.util.proxy.ProxyUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ProxyInfo
extends Stringable
implements Serializable {
    public static final ProxyInfo NO_PROXY_INFO = new NoProxyInfo();
    private static final long serialVersionUID = -7476704373593358472L;
    private final String host;
    private final int port;
    private final Credentials proxyCredentials;
    private final String ignoredProxyHosts;
    private final String ntlmDomain;
    private final String ntlmWorkstation;

    public ProxyInfo(String host, int port, Credentials proxyCredentials, String ignoredProxyHosts, String ntlmDomain, String ntlmWorkstation) {
        this.host = host;
        this.port = port;
        this.proxyCredentials = proxyCredentials;
        this.ignoredProxyHosts = ignoredProxyHosts;
        this.ntlmDomain = ntlmDomain;
        this.ntlmWorkstation = ntlmWorkstation;
    }

    public URLConnection openConnection(URL url) throws IOException {
        Proxy proxy = this.getProxy(url);
        return url.openConnection(proxy);
    }

    public Proxy getProxy(URL url) {
        if (this.shouldUseProxyForUrl(url)) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.host, this.port));
            return proxy;
        }
        return Proxy.NO_PROXY;
    }

    public boolean shouldUseProxyForUrl(URL url) {
        if (NO_PROXY_INFO.equals(this)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.host) || this.port <= 0) {
            return false;
        }
        List ignoredProxyHostPatterns = ProxyUtil.getIgnoredProxyHostPatterns((String)this.ignoredProxyHosts);
        return !ProxyUtil.shouldIgnoreHost((String)url.getHost(), (List)ignoredProxyHostPatterns);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        if (this.getProxyCredentials() == null) {
            return null;
        }
        return this.getProxyCredentials().getUsername();
    }

    public String getEncryptedPassword() {
        if (this.getProxyCredentials() == null) {
            return null;
        }
        return this.getProxyCredentials().getEncryptedPassword();
    }

    public String getDecryptedPassword() throws IllegalArgumentException, EncryptionException {
        if (this.getProxyCredentials() == null) {
            return null;
        }
        return this.getProxyCredentials().getDecryptedPassword();
    }

    public String getMaskedPassword() {
        if (this.getProxyCredentials() == null) {
            return null;
        }
        return this.getProxyCredentials().getMaskedPassword();
    }

    public int getActualPasswordLength() {
        if (this.getProxyCredentials() == null) {
            return 0;
        }
        return this.getProxyCredentials().getActualPasswordLength();
    }

    public String getIgnoredProxyHosts() {
        return this.ignoredProxyHosts;
    }

    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public String getNtlmWorkstation() {
        return this.ntlmWorkstation;
    }

    public boolean hasAuthenticatedProxySettings() {
        return this.proxyCredentials != null && StringUtils.isNotBlank((CharSequence)this.proxyCredentials.getUsername()) && StringUtils.isNotBlank((CharSequence)this.proxyCredentials.getEncryptedPassword());
    }

    private Credentials getProxyCredentials() {
        return this.proxyCredentials;
    }

    private static final class NoProxyInfo
    extends ProxyInfo {
        private static final long serialVersionUID = 7646573390510702513L;

        public NoProxyInfo() {
            super("", 0, null, "", null, null);
        }
    }
}

