/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.request;

import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.body.BodyContent;
import com.synopsys.integration.util.Stringable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;

public class Request
extends Stringable {
    private final String uri;
    private final HttpMethod method;
    private final String mimeType;
    private final Charset bodyEncoding;
    private final Map<String, Set<String>> queryParameters;
    private final Map<String, String> additionalHeaders;
    private final BodyContent bodyContent;

    private Request(Builder builder) {
        this.uri = builder.getUri();
        this.method = builder.getMethod();
        this.mimeType = builder.getMimeType();
        this.bodyEncoding = builder.getBodyEncoding();
        this.queryParameters = builder.getQueryParameters();
        this.additionalHeaders = builder.getAdditionalHeaders();
        this.bodyContent = builder.getBodyContent();
    }

    public Request(String uri, HttpMethod method, String mimeType, Charset bodyEncoding, Map<String, Set<String>> queryParameters, Map<String, String> additionalHeaders, BodyContent bodyContent) {
        this.uri = uri;
        this.method = method;
        this.mimeType = mimeType;
        this.bodyEncoding = bodyEncoding;
        this.queryParameters = queryParameters;
        this.additionalHeaders = additionalHeaders;
        this.bodyContent = bodyContent;
    }

    public HttpEntity createHttpEntity() {
        if (this.bodyContent == null) {
            return null;
        }
        return this.bodyContent.createEntity(this);
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, Set<String>> getPopulatedQueryParameters() {
        HashMap<String, Set<String>> populatedQueryParameters = new HashMap<String, Set<String>>();
        if (this.getQueryParameters() != null && !this.getQueryParameters().isEmpty()) {
            populatedQueryParameters.putAll(this.getQueryParameters());
        }
        return populatedQueryParameters;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Charset getBodyEncoding() {
        return this.bodyEncoding;
    }

    public Map<String, Set<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public static class Builder {
        private String uri;
        private HttpMethod method;
        private String mimeType;
        private Charset bodyEncoding;
        private Map<String, Set<String>> queryParameters;
        private Map<String, String> additionalHeaders;
        private BodyContent bodyContent;

        public Builder(Request request) {
            this.uri = request.uri;
            this.method = request.method;
            this.mimeType = request.mimeType;
            this.bodyEncoding = request.bodyEncoding;
            if (request.queryParameters != null) {
                this.queryParameters = new HashMap<String, Set<String>>(request.queryParameters);
            }
            if (request.additionalHeaders != null) {
                this.additionalHeaders = new HashMap<String, String>(request.additionalHeaders);
            }
            this.bodyContent = request.bodyContent;
        }

        public Builder(String uri) {
            this.uri = uri;
            this.method = HttpMethod.GET;
            this.mimeType = ContentType.APPLICATION_JSON.getMimeType();
            this.bodyEncoding = StandardCharsets.UTF_8;
        }

        public Builder() {
            this((String)null);
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder bodyEncoding(Charset bodyEncoding) {
            this.bodyEncoding = bodyEncoding;
            return this;
        }

        public Builder queryParameters(Map<String, Set<String>> queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public Builder addQueryParameter(String key, String value) {
            if (this.queryParameters == null) {
                this.queryParameters = new HashMap<String, Set<String>>();
            }
            this.queryParameters.computeIfAbsent(key, k -> new HashSet()).add(value);
            return this;
        }

        public Builder additionalHeaders(Map<String, String> additionalHeaders) {
            this.additionalHeaders = additionalHeaders;
            return this;
        }

        public Builder addAdditionalHeader(String key, String value) {
            if (this.additionalHeaders == null) {
                this.additionalHeaders = new HashMap<String, String>();
            }
            this.additionalHeaders.put(key, value);
            return this;
        }

        public Builder bodyContent(BodyContent bodyContent) {
            this.bodyContent = bodyContent;
            return this;
        }

        public Request build() {
            return new Request(this);
        }

        public String getUri() {
            return this.uri;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Charset getBodyEncoding() {
            return this.bodyEncoding;
        }

        public Map<String, Set<String>> getQueryParameters() {
            return this.queryParameters;
        }

        public Map<String, String> getAdditionalHeaders() {
            return this.additionalHeaders;
        }

        public BodyContent getBodyContent() {
            return this.bodyContent;
        }
    }
}

