/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.util.StateSet;
import android.view.MotionEvent;
import android.view.TouchDelegate;
import android.view.View;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import com.blankj.utilcode.util.ShadowUtils;
import com.blankj.utilcode.util.UtilsBridge;

public class ClickUtils {
    private static final int PRESSED_VIEW_SCALE_TAG = -1;
    private static final float PRESSED_VIEW_SCALE_DEFAULT_VALUE = -0.06f;
    private static final int PRESSED_VIEW_ALPHA_TAG = -2;
    private static final int PRESSED_VIEW_ALPHA_SRC_TAG = -3;
    private static final float PRESSED_VIEW_ALPHA_DEFAULT_VALUE = 0.8f;
    private static final int PRESSED_BG_ALPHA_STYLE = 4;
    private static final float PRESSED_BG_ALPHA_DEFAULT_VALUE = 0.9f;
    private static final int PRESSED_BG_DARK_STYLE = 5;
    private static final float PRESSED_BG_DARK_DEFAULT_VALUE = 0.9f;
    private static final long DEBOUNCING_DEFAULT_VALUE = 1000L;
    private static final long TIP_DURATION = 2000L;
    private static long sLastClickMillis;
    private static int sClickCount;

    private ClickUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void applyPressedViewScale(View ... views) {
        ClickUtils.applyPressedViewScale(views, null);
    }

    public static void applyPressedViewScale(View[] views, float[] scaleFactors) {
        if (views == null || views.length == 0) {
            return;
        }
        for (int i = 0; i < views.length; ++i) {
            if (scaleFactors == null || i >= scaleFactors.length) {
                ClickUtils.applyPressedViewScale(views[i], -0.06f);
                continue;
            }
            ClickUtils.applyPressedViewScale(views[i], scaleFactors[i]);
        }
    }

    public static void applyPressedViewScale(View view, float scaleFactor) {
        if (view == null) {
            return;
        }
        view.setTag(-1, (Object)Float.valueOf(scaleFactor));
        view.setClickable(true);
        view.setOnTouchListener((View.OnTouchListener)OnUtilsTouchListener.getInstance());
    }

    public static void applyPressedViewAlpha(View ... views) {
        ClickUtils.applyPressedViewAlpha(views, null);
    }

    public static void applyPressedViewAlpha(View[] views, float[] alphas) {
        if (views == null || views.length == 0) {
            return;
        }
        for (int i = 0; i < views.length; ++i) {
            if (alphas == null || i >= alphas.length) {
                ClickUtils.applyPressedViewAlpha(views[i], 0.8f);
                continue;
            }
            ClickUtils.applyPressedViewAlpha(views[i], alphas[i]);
        }
    }

    public static void applyPressedViewAlpha(View view, float alpha) {
        if (view == null) {
            return;
        }
        view.setTag(-2, (Object)Float.valueOf(alpha));
        view.setTag(-3, (Object)Float.valueOf(view.getAlpha()));
        view.setClickable(true);
        view.setOnTouchListener((View.OnTouchListener)OnUtilsTouchListener.getInstance());
    }

    public static void applyPressedBgAlpha(View view) {
        ClickUtils.applyPressedBgAlpha(view, 0.9f);
    }

    public static void applyPressedBgAlpha(View view, float alpha) {
        ClickUtils.applyPressedBgStyle(view, 4, alpha);
    }

    public static void applyPressedBgDark(View view) {
        ClickUtils.applyPressedBgDark(view, 0.9f);
    }

    public static void applyPressedBgDark(View view, float darkAlpha) {
        ClickUtils.applyPressedBgStyle(view, 5, darkAlpha);
    }

    private static void applyPressedBgStyle(View view, int style, float value) {
        if (view == null) {
            return;
        }
        Drawable background = view.getBackground();
        Object tag = view.getTag(-style);
        if (tag instanceof Drawable) {
            ViewCompat.setBackground((View)view, (Drawable)((Drawable)tag));
        } else {
            background = ClickUtils.createStyleDrawable(background, style, value);
            ViewCompat.setBackground((View)view, (Drawable)background);
            view.setTag(-style, (Object)background);
        }
    }

    private static Drawable createStyleDrawable(Drawable src, int style, float value) {
        if (src == null) {
            src = new ColorDrawable(0);
        }
        if (src.getConstantState() == null) {
            return src;
        }
        Drawable pressed = src.getConstantState().newDrawable().mutate();
        if (style == 4) {
            pressed = ClickUtils.createAlphaDrawable(pressed, value);
        } else if (style == 5) {
            pressed = ClickUtils.createDarkDrawable(pressed, value);
        }
        Drawable disable = src.getConstantState().newDrawable().mutate();
        disable = ClickUtils.createAlphaDrawable(disable, 0.5f);
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(new int[]{16842919}, pressed);
        drawable.addState(new int[]{-16842910}, disable);
        drawable.addState(StateSet.WILD_CARD, src);
        return drawable;
    }

    private static Drawable createAlphaDrawable(Drawable drawable, float alpha) {
        ClickDrawableWrapper drawableWrapper = new ClickDrawableWrapper(drawable);
        drawableWrapper.setAlpha((int)(alpha * 255.0f));
        return drawableWrapper;
    }

    private static Drawable createDarkDrawable(Drawable drawable, float alpha) {
        ClickDrawableWrapper drawableWrapper = new ClickDrawableWrapper(drawable);
        drawableWrapper.setColorFilter((ColorFilter)ClickUtils.getDarkColorFilter(alpha));
        return drawableWrapper;
    }

    private static ColorMatrixColorFilter getDarkColorFilter(float darkAlpha) {
        return new ColorMatrixColorFilter(new ColorMatrix(new float[]{darkAlpha, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, darkAlpha, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, darkAlpha, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f}));
    }

    public static void applySingleDebouncing(View view, View.OnClickListener listener) {
        ClickUtils.applySingleDebouncing(new View[]{view}, listener);
    }

    public static void applySingleDebouncing(View view, @IntRange(from=0L) long duration, View.OnClickListener listener) {
        ClickUtils.applySingleDebouncing(new View[]{view}, duration, listener);
    }

    public static void applySingleDebouncing(View[] views, View.OnClickListener listener) {
        ClickUtils.applySingleDebouncing(views, 1000L, listener);
    }

    public static void applySingleDebouncing(View[] views, @IntRange(from=0L) long duration, View.OnClickListener listener) {
        ClickUtils.applyDebouncing(views, false, duration, listener);
    }

    public static void applyGlobalDebouncing(View view, View.OnClickListener listener) {
        ClickUtils.applyGlobalDebouncing(new View[]{view}, listener);
    }

    public static void applyGlobalDebouncing(View view, @IntRange(from=0L) long duration, View.OnClickListener listener) {
        ClickUtils.applyGlobalDebouncing(new View[]{view}, duration, listener);
    }

    public static void applyGlobalDebouncing(View[] views, View.OnClickListener listener) {
        ClickUtils.applyGlobalDebouncing(views, 1000L, listener);
    }

    public static void applyGlobalDebouncing(View[] views, @IntRange(from=0L) long duration, View.OnClickListener listener) {
        ClickUtils.applyDebouncing(views, true, duration, listener);
    }

    private static void applyDebouncing(View[] views, boolean isGlobal, @IntRange(from=0L) long duration, final View.OnClickListener listener) {
        if (views == null || views.length == 0 || listener == null) {
            return;
        }
        for (View view : views) {
            if (view == null) continue;
            view.setOnClickListener((View.OnClickListener)new OnDebouncingClickListener(isGlobal, duration){

                @Override
                public void onDebouncingClick(View v) {
                    listener.onClick(v);
                }
            });
        }
    }

    public static void expandClickArea(@NonNull View view, int expandSize) {
        ClickUtils.expandClickArea(view, expandSize, expandSize, expandSize, expandSize);
    }

    public static void expandClickArea(final @NonNull View view, final int expandSizeTop, final int expandSizeLeft, final int expandSizeRight, final int expandSizeBottom) {
        final View parentView = (View)view.getParent();
        if (parentView == null) {
            Log.e((String)"ClickUtils", (String)"expandClickArea must have parent view.");
            return;
        }
        parentView.post(new Runnable(){

            @Override
            public void run() {
                Rect rect = new Rect();
                view.getHitRect(rect);
                rect.top -= expandSizeTop;
                rect.bottom += expandSizeBottom;
                rect.left -= expandSizeLeft;
                rect.right += expandSizeRight;
                parentView.setTouchDelegate(new TouchDelegate(rect, view));
            }
        });
    }

    public static void back2HomeFriendly(CharSequence tip) {
        ClickUtils.back2HomeFriendly(tip, 2000L, Back2HomeFriendlyListener.DEFAULT);
    }

    public static void back2HomeFriendly(@NonNull CharSequence tip, long duration, @NonNull Back2HomeFriendlyListener listener) {
        long nowMillis = SystemClock.elapsedRealtime();
        if (Math.abs(nowMillis - sLastClickMillis) < duration) {
            if (++sClickCount == 2) {
                UtilsBridge.startHomeActivity();
                listener.dismiss();
                sLastClickMillis = 0L;
            }
        } else {
            sClickCount = 1;
            listener.show(tip, duration);
            sLastClickMillis = nowMillis;
        }
    }

    static class ClickDrawableWrapper
    extends ShadowUtils.DrawableWrapper {
        private BitmapDrawable mBitmapDrawable = null;
        private Paint mColorPaint = null;

        public ClickDrawableWrapper(Drawable drawable) {
            super(drawable);
            if (drawable instanceof ColorDrawable) {
                this.mColorPaint = new Paint(5);
                this.mColorPaint.setColor(((ColorDrawable)drawable).getColor());
            }
        }

        @Override
        public void setColorFilter(ColorFilter cf) {
            super.setColorFilter(cf);
            if (Build.VERSION.SDK_INT < 21 && this.mColorPaint != null) {
                this.mColorPaint.setColorFilter(cf);
            }
        }

        @Override
        public void setAlpha(int alpha) {
            super.setAlpha(alpha);
            if (Build.VERSION.SDK_INT < 21 && this.mColorPaint != null) {
                this.mColorPaint.setColor(((ColorDrawable)this.getWrappedDrawable()).getColor());
            }
        }

        @Override
        public void draw(Canvas canvas) {
            if (this.mBitmapDrawable == null) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.getBounds().width(), (int)this.getBounds().height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas myCanvas = new Canvas(bitmap);
                if (this.mColorPaint != null) {
                    myCanvas.drawRect(this.getBounds(), this.mColorPaint);
                } else {
                    super.draw(myCanvas);
                }
                this.mBitmapDrawable = new BitmapDrawable(Resources.getSystem(), bitmap);
                this.mBitmapDrawable.setBounds(this.getBounds());
            }
            this.mBitmapDrawable.draw(canvas);
        }
    }

    private static class OnUtilsTouchListener
    implements View.OnTouchListener {
        public static OnUtilsTouchListener getInstance() {
            return LazyHolder.INSTANCE;
        }

        private OnUtilsTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            int action = event.getAction();
            if (action == 0) {
                this.processScale(v, true);
                this.processAlpha(v, true);
            } else if (action == 1 || action == 3) {
                this.processScale(v, false);
                this.processAlpha(v, false);
            }
            return false;
        }

        private void processScale(View view, boolean isDown) {
            Object tag = view.getTag(-1);
            if (!(tag instanceof Float)) {
                return;
            }
            float value = isDown ? 1.0f + ((Float)tag).floatValue() : 1.0f;
            view.animate().scaleX(value).scaleY(value).setDuration(200L).start();
        }

        private void processAlpha(View view, boolean isDown) {
            Object tag = view.getTag(isDown ? -2 : -3);
            if (!(tag instanceof Float)) {
                return;
            }
            view.setAlpha(((Float)tag).floatValue());
        }

        private static class LazyHolder {
            private static final OnUtilsTouchListener INSTANCE = new OnUtilsTouchListener();

            private LazyHolder() {
            }
        }
    }

    public static abstract class OnMultiClickListener
    implements View.OnClickListener {
        private static final long INTERVAL_DEFAULT_VALUE = 666L;
        private final int mTriggerClickCount;
        private final long mClickInterval;
        private long mLastClickTime;
        private int mClickCount;

        public OnMultiClickListener(int triggerClickCount) {
            this(triggerClickCount, 666L);
        }

        public OnMultiClickListener(int triggerClickCount, long clickInterval) {
            this.mTriggerClickCount = triggerClickCount;
            this.mClickInterval = clickInterval;
        }

        public abstract void onTriggerClick(View var1);

        public abstract void onBeforeTriggerClick(View var1, int var2);

        public void onClick(View v) {
            if (this.mTriggerClickCount <= 1) {
                this.onTriggerClick(v);
                return;
            }
            long curTime = System.currentTimeMillis();
            if (curTime - this.mLastClickTime < this.mClickInterval) {
                ++this.mClickCount;
                if (this.mClickCount == this.mTriggerClickCount) {
                    this.onTriggerClick(v);
                } else if (this.mClickCount < this.mTriggerClickCount) {
                    this.onBeforeTriggerClick(v, this.mClickCount);
                } else {
                    this.mClickCount = 1;
                    this.onBeforeTriggerClick(v, this.mClickCount);
                }
            } else {
                this.mClickCount = 1;
                this.onBeforeTriggerClick(v, this.mClickCount);
            }
            this.mLastClickTime = curTime;
        }
    }

    public static abstract class OnDebouncingClickListener
    implements View.OnClickListener {
        private static boolean mEnabled = true;
        private static final Runnable ENABLE_AGAIN = new Runnable(){

            @Override
            public void run() {
                mEnabled = true;
            }
        };
        private long mDuration;
        private boolean mIsGlobal;

        private static boolean isValid(@NonNull View view, long duration) {
            return UtilsBridge.isValid(view, duration);
        }

        public OnDebouncingClickListener() {
            this(true, 1000L);
        }

        public OnDebouncingClickListener(boolean isGlobal) {
            this(isGlobal, 1000L);
        }

        public OnDebouncingClickListener(long duration) {
            this(true, duration);
        }

        public OnDebouncingClickListener(boolean isGlobal, long duration) {
            this.mIsGlobal = isGlobal;
            this.mDuration = duration;
        }

        public abstract void onDebouncingClick(View var1);

        public final void onClick(View v) {
            if (this.mIsGlobal) {
                if (mEnabled) {
                    mEnabled = false;
                    v.postDelayed(ENABLE_AGAIN, this.mDuration);
                    this.onDebouncingClick(v);
                }
            } else if (OnDebouncingClickListener.isValid(v, this.mDuration)) {
                this.onDebouncingClick(v);
            }
        }
    }

    public static interface Back2HomeFriendlyListener {
        public static final Back2HomeFriendlyListener DEFAULT = new Back2HomeFriendlyListener(){

            @Override
            public void show(CharSequence text, long duration) {
                UtilsBridge.toastShowShort(text);
            }

            @Override
            public void dismiss() {
                UtilsBridge.toastCancel();
            }
        };

        public void show(CharSequence var1, long var2);

        public void dismiss();
    }
}

