/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.domain;

import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;

public class LivenessProbe {
    @Input
    private long pollTime;
    @Input
    private long pollInterval;
    @Input
    private String logContains;

    public long getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(long pollTime) {
        this.pollTime = pollTime;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public String getLogContains() {
        return this.logContains;
    }

    public void setLogContains(String logContains) {
        this.logContains = logContains;
    }

    public LivenessProbe(long pollTime, long pollInterval, String logContains) {
        if (pollInterval > pollTime) {
            throw new GradleException("pollInterval must be greater than pollTime: pollInterval=" + pollInterval + ", pollTime=" + pollTime);
        }
        String localLogContains = Objects.requireNonNull(logContains).trim();
        if (localLogContains.isEmpty()) {
            throw new GradleException("logContains must be a valid non-empty String");
        }
        this.pollTime = pollTime;
        this.pollInterval = pollInterval;
        this.logContains = localLogContains;
    }

    public String toString() {
        return "pollTime=" + this.getPollTime() + ", pollInterval=" + this.getPollInterval() + ", logContains='" + this.getLogContains() + "'";
    }
}

