/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.commons.compress.archivers.zip;

import com.bmuschko.gradle.docker.shaded.org.apache.commons.compress.archivers.zip.ZipExtraField;
import com.bmuschko.gradle.docker.shaded.org.apache.commons.compress.archivers.zip.ZipShort;
import com.bmuschko.gradle.docker.shaded.org.apache.commons.compress.archivers.zip.ZipUtil;
import java.util.Arrays;

public class UnrecognizedExtraField
implements ZipExtraField {
    private ZipShort headerId;
    private byte[] localData;
    private byte[] centralData;

    @Override
    public byte[] getCentralDirectoryData() {
        if (this.centralData != null) {
            return ZipUtil.copy(this.centralData);
        }
        return this.getLocalFileDataData();
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        if (this.centralData != null) {
            return new ZipShort(this.centralData.length);
        }
        return this.getLocalFileDataLength();
    }

    @Override
    public ZipShort getHeaderId() {
        return this.headerId;
    }

    @Override
    public byte[] getLocalFileDataData() {
        return ZipUtil.copy(this.localData);
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return ZipShort.lengthOf(this.localData);
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] data, int offset, int length) {
        byte[] tmp = Arrays.copyOfRange(data, offset, offset + length);
        this.setCentralDirectoryData(tmp);
        if (this.localData == null) {
            this.setLocalFileDataData(tmp);
        }
    }

    @Override
    public void parseFromLocalFileData(byte[] data, int offset, int length) {
        this.setLocalFileDataData(Arrays.copyOfRange(data, offset, offset + length));
    }

    public void setCentralDirectoryData(byte[] data) {
        this.centralData = ZipUtil.copy(data);
    }

    public void setHeaderId(ZipShort headerId) {
        this.headerId = headerId;
    }

    public void setLocalFileDataData(byte[] data) {
        this.localData = ZipUtil.copy(data);
    }
}

