/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.nio;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.DnsResolver;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.HttpRoute;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.SchemePortResolver;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.config.ConnectionConfig;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.config.TlsConfig;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.nio.DefaultAsyncClientConnectionOperator;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.nio.AsyncClientConnectionOperator;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.ssl.ConscryptClientTlsStrategy;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Experimental;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Internal;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.function.Resolver;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpHost;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.URIScheme;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.config.RegistryBuilder;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.pool.PoolReusePolicy;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.util.ReflectionUtils;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.util.TimeValue;

public class PoolingAsyncClientConnectionManagerBuilder {
    private TlsStrategy tlsStrategy;
    private SchemePortResolver schemePortResolver;
    private DnsResolver dnsResolver;
    private PoolConcurrencyPolicy poolConcurrencyPolicy;
    private PoolReusePolicy poolReusePolicy;
    private boolean systemProperties;
    private int maxConnTotal;
    private int maxConnPerRoute;
    private Resolver<HttpRoute, ConnectionConfig> connectionConfigResolver;
    private Resolver<HttpHost, TlsConfig> tlsConfigResolver;
    private boolean messageMultiplexing;

    public static PoolingAsyncClientConnectionManagerBuilder create() {
        return new PoolingAsyncClientConnectionManagerBuilder();
    }

    @Internal
    protected PoolingAsyncClientConnectionManagerBuilder() {
    }

    public final PoolingAsyncClientConnectionManagerBuilder setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setDnsResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setSchemePortResolver(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setPoolConcurrencyPolicy(PoolConcurrencyPolicy poolConcurrencyPolicy) {
        this.poolConcurrencyPolicy = poolConcurrencyPolicy;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setConnPoolPolicy(PoolReusePolicy poolReusePolicy) {
        this.poolReusePolicy = poolReusePolicy;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setMaxConnTotal(int maxConnTotal) {
        this.maxConnTotal = maxConnTotal;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        this.maxConnPerRoute = maxConnPerRoute;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setDefaultConnectionConfig(ConnectionConfig config) {
        this.connectionConfigResolver = route -> config;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setConnectionConfigResolver(Resolver<HttpRoute, ConnectionConfig> connectionConfigResolver) {
        this.connectionConfigResolver = connectionConfigResolver;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setDefaultTlsConfig(TlsConfig config) {
        this.tlsConfigResolver = host -> config;
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder setTlsConfigResolver(Resolver<HttpHost, TlsConfig> tlsConfigResolver) {
        this.tlsConfigResolver = tlsConfigResolver;
        return this;
    }

    @Deprecated
    public final PoolingAsyncClientConnectionManagerBuilder setConnectionTimeToLive(TimeValue timeToLive) {
        this.setDefaultConnectionConfig(ConnectionConfig.custom().setTimeToLive(timeToLive).build());
        return this;
    }

    @Deprecated
    public final PoolingAsyncClientConnectionManagerBuilder setValidateAfterInactivity(TimeValue validateAfterInactivity) {
        this.setDefaultConnectionConfig(ConnectionConfig.custom().setValidateAfterInactivity(validateAfterInactivity).build());
        return this;
    }

    public final PoolingAsyncClientConnectionManagerBuilder useSystemProperties() {
        this.systemProperties = true;
        return this;
    }

    @Experimental
    public final PoolingAsyncClientConnectionManagerBuilder setMessageMultiplexing(boolean messageMultiplexing) {
        this.messageMultiplexing = messageMultiplexing;
        return this;
    }

    @Internal
    protected AsyncClientConnectionOperator createConnectionOperator(TlsStrategy tlsStrategy, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        return new DefaultAsyncClientConnectionOperator(RegistryBuilder.create().register(URIScheme.HTTPS.getId(), tlsStrategy).build(), schemePortResolver, dnsResolver);
    }

    public PoolingAsyncClientConnectionManager build() {
        TlsStrategy tlsStrategyCopy = this.tlsStrategy != null ? this.tlsStrategy : (ReflectionUtils.determineJRELevel() <= 8 && ConscryptClientTlsStrategy.isSupported() ? (this.systemProperties ? ConscryptClientTlsStrategy.getSystemDefault() : ConscryptClientTlsStrategy.getDefault()) : (this.systemProperties ? DefaultClientTlsStrategy.createSystemDefault() : DefaultClientTlsStrategy.createDefault()));
        PoolingAsyncClientConnectionManager poolingmgr = new PoolingAsyncClientConnectionManager(this.createConnectionOperator(tlsStrategyCopy, this.schemePortResolver, this.dnsResolver), this.poolConcurrencyPolicy, this.poolReusePolicy, null, this.messageMultiplexing);
        poolingmgr.setConnectionConfigResolver(this.connectionConfigResolver);
        poolingmgr.setTlsConfigResolver(this.tlsConfigResolver);
        if (this.maxConnTotal > 0) {
            poolingmgr.setMaxTotal(this.maxConnTotal);
        }
        if (this.maxConnPerRoute > 0) {
            poolingmgr.setDefaultMaxPerRoute(this.maxConnPerRoute);
        }
        return poolingmgr;
    }
}

