/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.impl.nio;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.function.Callback;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ConnectionReuseStrategy;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.EntityDetails;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.Header;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpRequest;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpResponse;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpVersion;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.Method;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.MisdirectedRequestException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ProtocolException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ProtocolVersion;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.UnsupportedHttpVersionException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.config.Http1Config;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.impl.ServerSupport;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.impl.nio.FlushMode;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.impl.nio.Http1StreamChannel;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.impl.nio.MessageState;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.message.BasicHttpResponse;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.AsyncPushProducer;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.CapacityChannel;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.DataStreamChannel;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.HandlerFactory;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.ResourceHolder;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.ResponseChannel;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.support.BasicResponseProducer;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.support.ImmediateResponseExchangeHandler;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.HttpCoreContext;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.HttpProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class ServerHttp1StreamHandler
implements ResourceHolder {
    private final Http1StreamChannel<HttpResponse> outputChannel;
    private final DataStreamChannel internalDataChannel;
    private final ResponseChannel responseChannel;
    private final HttpProcessor httpProcessor;
    private final Http1Config http1Config;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;
    private final Callback<Exception> exceptionCallback;
    private final HttpCoreContext context;
    private final AtomicReference<MessageState> requestState;
    private final AtomicReference<MessageState> responseState;
    private final AtomicBoolean responseCommitted;
    private final AtomicBoolean done;
    private volatile boolean keepAlive;
    private volatile AsyncServerExchangeHandler exchangeHandler;
    private volatile HttpRequest receivedRequest;

    ServerHttp1StreamHandler(final Http1StreamChannel<HttpResponse> outputChannel, HttpProcessor httpProcessor, Http1Config http1Config, ConnectionReuseStrategy connectionReuseStrategy, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, Callback<Exception> exceptionCallback, HttpCoreContext context) {
        this.outputChannel = outputChannel;
        this.internalDataChannel = new DataStreamChannel(){

            @Override
            public void requestOutput() {
                outputChannel.requestOutput();
            }

            @Override
            public void endStream(List<? extends Header> trailers) throws IOException {
                ServerHttp1StreamHandler.this.responseState.set(MessageState.COMPLETE);
                outputChannel.complete(trailers);
                if (ServerHttp1StreamHandler.this.requestState.get() == MessageState.COMPLETE && !ServerHttp1StreamHandler.this.keepAlive) {
                    outputChannel.close();
                }
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return outputChannel.write(src);
            }

            @Override
            public void endStream() throws IOException {
                this.endStream(null);
            }
        };
        this.responseChannel = new ResponseChannel(){

            @Override
            public void sendInformation(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
                ServerHttp1StreamHandler.this.commitInformation(response);
            }

            @Override
            public void sendResponse(HttpResponse response, EntityDetails responseEntityDetails, HttpContext httpContext) throws HttpException, IOException {
                ServerHttp1StreamHandler.this.commitResponse(response, responseEntityDetails);
            }

            @Override
            public void pushPromise(HttpRequest promise, AsyncPushProducer pushProducer, HttpContext httpContext) throws HttpException, IOException {
                ServerHttp1StreamHandler.this.commitPromise();
            }

            public String toString() {
                return super.toString() + " " + ServerHttp1StreamHandler.this;
            }
        };
        this.httpProcessor = httpProcessor;
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.connectionReuseStrategy = connectionReuseStrategy;
        this.exchangeHandlerFactory = exchangeHandlerFactory;
        this.exceptionCallback = exceptionCallback;
        this.context = context;
        this.requestState = new AtomicReference<MessageState>(MessageState.HEADERS);
        this.responseState = new AtomicReference<MessageState>(MessageState.IDLE);
        this.responseCommitted = new AtomicBoolean();
        this.done = new AtomicBoolean();
        this.keepAlive = true;
    }

    private void commitResponse(HttpResponse response, EntityDetails responseEntityDetails) throws HttpException, IOException {
        if (this.responseCommitted.compareAndSet(false, true)) {
            boolean endStream;
            int status;
            ProtocolVersion transportVersion = response.getVersion();
            if (transportVersion != null) {
                if (!transportVersion.lessEquals(this.http1Config.getVersion())) {
                    throw new UnsupportedHttpVersionException(transportVersion);
                }
                this.context.setProtocolVersion(transportVersion);
            }
            if ((status = response.getCode()) < 200) {
                throw new HttpException("Invalid response: " + status);
            }
            this.context.setResponse(response);
            this.httpProcessor.process(response, responseEntityDetails, (HttpContext)this.context);
            boolean bl = endStream = responseEntityDetails == null || this.receivedRequest != null && Method.HEAD.isSame(this.receivedRequest.getMethod());
            if (!this.connectionReuseStrategy.keepAlive(this.receivedRequest, response, this.context)) {
                this.keepAlive = false;
            }
            if (endStream) {
                this.responseState.set(MessageState.COMPLETE);
                this.outputChannel.submit(response, true, FlushMode.IMMEDIATE);
                if (!this.keepAlive) {
                    this.outputChannel.close();
                }
            } else {
                this.outputChannel.submit(response, false, FlushMode.BUFFER);
                this.exchangeHandler.produce(this.internalDataChannel);
                if (this.responseState.compareAndSet(MessageState.IDLE, MessageState.BODY)) {
                    this.outputChannel.requestOutput();
                }
            }
        } else {
            throw new HttpException("Response already committed");
        }
    }

    private void commitInformation(HttpResponse response) throws IOException, HttpException {
        if (this.responseCommitted.get()) {
            throw new HttpException("Response already committed");
        }
        int status = response.getCode();
        if (status < 100 || status >= 200) {
            throw new HttpException("Invalid intermediate response: " + status);
        }
        this.outputChannel.submit(response, true, FlushMode.IMMEDIATE);
    }

    private void commitPromise() throws HttpException {
        throw new HttpException("HTTP/1.1 does not support server push");
    }

    void activateChannel() throws IOException, HttpException {
        this.outputChannel.activate();
    }

    boolean isResponseFinal() {
        return this.responseState.get() == MessageState.COMPLETE;
    }

    boolean keepAlive() {
        return this.keepAlive;
    }

    boolean isCompleted() {
        return this.requestState.get() == MessageState.COMPLETE && this.responseState.get() == MessageState.COMPLETE;
    }

    void terminateExchange(HttpException ex) throws HttpException, IOException {
        if (this.done.get() || this.requestState.get() != MessageState.HEADERS) {
            throw new ProtocolException("Unexpected message head");
        }
        this.receivedRequest = null;
        this.requestState.set(MessageState.COMPLETE);
        BasicHttpResponse response = new BasicHttpResponse(ServerSupport.toStatusCode(ex));
        response.addHeader("Connection", "close");
        BasicResponseProducer responseProducer = new BasicResponseProducer((HttpResponse)response, ServerSupport.toErrorMessage(ex));
        this.exchangeHandler = new ImmediateResponseExchangeHandler(responseProducer);
        this.exchangeHandler.handleRequest(null, null, this.responseChannel, this.context);
    }

    void consumeHeader(HttpRequest request, EntityDetails requestEntityDetails) throws HttpException, IOException {
        if (this.done.get() || this.requestState.get() != MessageState.HEADERS) {
            throw new ProtocolException("Unexpected message head");
        }
        this.receivedRequest = request;
        this.requestState.set(requestEntityDetails == null ? MessageState.COMPLETE : MessageState.BODY);
        try {
            AsyncServerExchangeHandler handler;
            ProtocolVersion transportVersion = request.getVersion();
            if (transportVersion != null && transportVersion.greaterEquals(HttpVersion.HTTP_2)) {
                throw new UnsupportedHttpVersionException(transportVersion);
            }
            this.context.setProtocolVersion(transportVersion != null ? transportVersion : this.http1Config.getVersion());
            this.context.setRequest(request);
            this.httpProcessor.process(request, requestEntityDetails, (HttpContext)this.context);
            try {
                handler = this.exchangeHandlerFactory.create(request, this.context);
            }
            catch (MisdirectedRequestException ex) {
                handler = new ImmediateResponseExchangeHandler(421, ex.getMessage());
            }
            catch (HttpException ex) {
                handler = new ImmediateResponseExchangeHandler(500, ex.getMessage());
            }
            if (handler == null) {
                handler = new ImmediateResponseExchangeHandler(404, "Cannot handle request");
            }
            this.exchangeHandler = handler;
            this.exchangeHandler.handleRequest(request, requestEntityDetails, this.responseChannel, this.context);
        }
        catch (HttpException ex) {
            if (!this.responseCommitted.get()) {
                BasicHttpResponse response = new BasicHttpResponse(ServerSupport.toStatusCode(ex));
                response.addHeader("Connection", "close");
                BasicResponseProducer responseProducer = new BasicResponseProducer((HttpResponse)response, ServerSupport.toErrorMessage(ex));
                this.exchangeHandler = new ImmediateResponseExchangeHandler(responseProducer);
                this.exchangeHandler.handleRequest(request, requestEntityDetails, this.responseChannel, this.context);
            }
            throw ex;
        }
    }

    boolean isOutputReady() {
        switch (this.responseState.get()) {
            case BODY: {
                return this.exchangeHandler.available() > 0;
            }
        }
        return false;
    }

    void produceOutput() throws IOException {
        switch (this.responseState.get()) {
            case BODY: {
                this.exchangeHandler.produce(this.internalDataChannel);
            }
        }
    }

    void consumeData(ByteBuffer src) throws HttpException, IOException {
        if (this.done.get() || this.requestState.get() != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        if (this.responseState.get() == MessageState.ACK) {
            this.outputChannel.requestOutput();
        }
        this.exchangeHandler.consume(src);
    }

    void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.exchangeHandler.updateCapacity(capacityChannel);
    }

    void dataEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (this.done.get() || this.requestState.get() != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        this.requestState.set(MessageState.COMPLETE);
        if (this.responseState.get() == MessageState.COMPLETE && !this.keepAlive) {
            this.outputChannel.close();
        }
        this.exchangeHandler.streamEnd(trailers);
    }

    void failed(Exception cause) {
        if (!this.done.get() && this.exchangeHandler != null) {
            this.exchangeHandler.failed(cause);
        } else if (this.exceptionCallback != null) {
            this.exceptionCallback.execute(cause);
        }
    }

    @Override
    public void releaseResources() {
        if (this.done.compareAndSet(false, true)) {
            this.requestState.set(MessageState.COMPLETE);
            this.responseState.set(MessageState.COMPLETE);
            if (this.exchangeHandler != null) {
                this.exchangeHandler.releaseResources();
            }
        }
    }

    void appendState(StringBuilder buf) {
        buf.append("requestState=").append((Object)this.requestState.get()).append(", responseState=").append((Object)this.responseState.get()).append(", responseCommitted=").append(this.responseCommitted).append(", keepAlive=").append(this.keepAlive).append(", done=").append(this.done);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        this.appendState(buf);
        buf.append("]");
        return buf.toString();
    }
}

