/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.io;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Internal;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketOption;

@Internal
public class SocketSupport {
    public static final String TCP_KEEPIDLE = "TCP_KEEPIDLE";
    public static final String TCP_KEEPINTERVAL = "TCP_KEEPINTERVAL";
    public static final String TCP_KEEPCOUNT = "TCP_KEEPCOUNT";

    public static <T> SocketOption<T> getExtendedSocketOptionOrNull(String fieldName) {
        try {
            Class<?> extendedSocketOptionsClass = Class.forName("jdk.net.ExtendedSocketOptions");
            Field field = extendedSocketOptionsClass.getField(fieldName);
            return (SocketOption)field.get(null);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static <T> void setOption(T object, String fieldName, T value) throws IOException {
        try {
            Class<?> serverSocketClass = object.getClass();
            Method setOptionMethod = serverSocketClass.getMethod("setOption", SocketOption.class, Object.class);
            SocketOption<T> socketOption = SocketSupport.getExtendedSocketOptionOrNull(fieldName);
            if (socketOption == null) {
                throw new UnsupportedOperationException("Extended socket option not supported: " + fieldName);
            }
            setOptionMethod.invoke(object, socketOption, value);
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new IOException("Failure setting extended socket option", ex);
        }
    }
}

