/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.generators;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.CipherKeyGenerator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.DESParameters;

public class DESKeyGenerator
extends CipherKeyGenerator {
    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        super.init(keyGenerationParameters);
        if (this.strength == 0 || this.strength == 7) {
            this.strength = 8;
        } else if (this.strength != 8) {
            throw new IllegalArgumentException("DES key must be 64 bits long.");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("DESKeyGen", 56, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public byte[] generateKey() {
        byte[] byArray = new byte[8];
        do {
            this.random.nextBytes(byArray);
            DESParameters.setOddParity(byArray);
        } while (DESParameters.isWeakKey(byArray, 0));
        return byArray;
    }
}

