/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum EventType {
    CONFIG("config"),
    CONTAINER("container"),
    DAEMON("daemon"),
    IMAGE("image"),
    NETWORK("network"),
    NODE("node"),
    PLUGIN("plugin"),
    SECRET("secret"),
    SERVICE("service"),
    VOLUME("volume");

    private static final Map<String, EventType> EVENT_TYPES;
    private String value;

    private EventType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static EventType forValue(String s) {
        return EVENT_TYPES.get(s);
    }

    static {
        EVENT_TYPES = new HashMap<String, EventType>();
        for (EventType t : EventType.values()) {
            EVENT_TYPES.put(t.name().toLowerCase(), t);
        }
    }
}

