/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.BeanDescription;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.Module;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.dockerjava.api.model.DockerObject;
import com.github.dockerjava.core.DockerObjectDeserializer;

enum DefaultObjectMapperHolder {
    INSTANCE;

    private final ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);

    private DefaultObjectMapperHolder() {
        final ObjectMapper originalObjectMapper = this.objectMapper.copy();
        this.objectMapper.registerModule(new SimpleModule("docker-java"){

            @Override
            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addBeanDeserializerModifier(new BeanDeserializerModifier(){

                    @Override
                    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDescription, JsonDeserializer<?> originalDeserializer) {
                        if (!beanDescription.getType().isTypeOrSubTypeOf(DockerObject.class)) {
                            return originalDeserializer;
                        }
                        return new DockerObjectDeserializer(originalDeserializer, beanDescription, originalObjectMapper);
                    }
                });
            }
        });
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

