/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.operator.bc;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.Wrapper;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.KeyParameter;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.operator.GenericKey;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.operator.OperatorException;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.operator.SymmetricKeyWrapper;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.operator.bc.OperatorUtils;
import java.security.SecureRandom;

public class BcSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, Wrapper wrapper, KeyParameter keyParameter) {
        super(algorithmIdentifier);
        this.wrapper = wrapper;
        this.wrappingKey = keyParameter;
    }

    public BcSymmetricKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        byte[] byArray = OperatorUtils.getKeyBytes(genericKey);
        if (this.random == null) {
            this.wrapper.init(true, this.wrappingKey);
        } else {
            this.wrapper.init(true, new ParametersWithRandom(this.wrappingKey, this.random));
        }
        return this.wrapper.wrap(byArray, 0, byArray.length);
    }
}

