/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks;

import com.bmuschko.gradle.docker.tasks.AbstractDockerRemoteApiTask;
import com.github.dockerjava.api.model.Info;
import java.util.Arrays;

public class DockerInfo
extends AbstractDockerRemoteApiTask {
    @Override
    public void runRemoteCommand() {
        this.getLogger().quiet("Retrieving Docker info.");
        Info info = (Info)this.getDockerClient().infoCmd().exec();
        if (this.getNextHandler() != null) {
            this.getNextHandler().execute((Object)info);
        } else {
            this.getLogger().quiet("Debug                : " + info.getDebug());
            this.getLogger().quiet("Containers           : " + info.getContainers());
            this.getLogger().quiet("Driver               : " + info.getDriver());
            this.getLogger().quiet("Driver Statuses      : " + info.getDriverStatuses());
            this.getLogger().quiet("Images               : " + info.getImages());
            this.getLogger().quiet("IPv4 Forwarding      : " + info.getIPv4Forwarding());
            this.getLogger().quiet("Index Server Address : " + info.getIndexServerAddress());
            this.getLogger().quiet("Init Path            : " + info.getInitPath());
            this.getLogger().quiet("Init SHA1            : " + info.getInitSha1());
            this.getLogger().quiet("Kernel Version       : " + info.getKernelVersion());
            this.getLogger().quiet("Sockets              : " + Arrays.toString(info.getSockets()));
            this.getLogger().quiet("Memory Limit         : " + info.getMemoryLimit());
            this.getLogger().quiet("nEvent Listener      : " + info.getNEventsListener());
            this.getLogger().quiet("NFd                  : " + info.getNFd());
            this.getLogger().quiet("NGoroutines          : " + info.getNGoroutines());
            this.getLogger().quiet("Swap Limit           : " + info.getSwapLimit());
            this.getLogger().quiet("Execution Driver     : " + info.getExecutionDriver());
        }
    }
}

