/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.network;

import com.bmuschko.gradle.docker.tasks.AbstractDockerRemoteApiTask;
import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.model.Network;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public class DockerCreateNetwork
extends AbstractDockerRemoteApiTask {
    private final Property<String> networkName;
    private final Ipam ipam;
    private final Property<String> networkId;

    @Input
    public final Property<String> getNetworkName() {
        return this.networkName;
    }

    @Nested
    public final Ipam getIpam() {
        return this.ipam;
    }

    @Internal
    public final Property<String> getNetworkId() {
        return this.networkId;
    }

    @Inject
    public DockerCreateNetwork(ObjectFactory objects) {
        this.networkName = objects.property(String.class);
        this.networkId = objects.property(String.class);
        this.ipam = (Ipam)objects.newInstance(Ipam.class, new Object[0]);
    }

    @Override
    public void runRemoteCommand() {
        this.getLogger().quiet("Creating network '" + (String)this.getNetworkName().get() + "'.");
        CreateNetworkCmd networkCmd = this.getDockerClient().createNetworkCmd().withName((String)this.networkName.get());
        if (this.ipam.getDriver().isPresent() || !((List)this.ipam.getConfigs().get()).isEmpty()) {
            Network.Ipam networkIpam = new Network.Ipam();
            if (this.ipam.getDriver().isPresent()) {
                networkIpam.withDriver((String)this.ipam.getDriver().get());
            }
            if (!((List)this.ipam.getConfigs().get()).isEmpty()) {
                networkIpam.withConfig(this.ipam.toDockerJavaConfigs());
            }
            networkCmd.withIpam(networkIpam);
        }
        CreateNetworkResponse network = (CreateNetworkResponse)networkCmd.exec();
        if (this.getNextHandler() != null) {
            this.getNextHandler().execute((Object)network);
        }
        String createdNetworkId = network.getId();
        this.networkId.set((Object)createdNetworkId);
        this.getLogger().quiet("Created network with ID '" + createdNetworkId + "'.");
    }

    public static class Ipam {
        private final Property<String> driver;
        private final ListProperty<Config> configs;

        @Input
        @Optional
        public final Property<String> getDriver() {
            return this.driver;
        }

        @Nested
        public final ListProperty<Config> getConfigs() {
            return this.configs;
        }

        @Inject
        public Ipam(ObjectFactory objectFactory) {
            this.driver = objectFactory.property(String.class);
            this.configs = objectFactory.listProperty(Config.class);
        }

        List<Network.Ipam.Config> toDockerJavaConfigs() {
            ArrayList<Network.Ipam.Config> configList = new ArrayList<Network.Ipam.Config>();
            for (Config c : (List)this.configs.get()) {
                Network.Ipam.Config ipamConfig = new Network.Ipam.Config();
                if (c.getSubnet() != null) {
                    ipamConfig.withSubnet(c.getSubnet());
                }
                if (c.getIpRange() != null) {
                    ipamConfig.withIpRange(c.getIpRange());
                }
                if (c.getGateway() != null) {
                    ipamConfig.withGateway(c.getGateway());
                }
                if (c.getNetworkID() != null) {
                    ipamConfig.withGateway(c.getNetworkID());
                }
                configList.add(ipamConfig);
            }
            return configList;
        }

        public static class Config {
            private String subnet;
            private String ipRange;
            private String gateway;
            private String networkID;

            @Input
            @Optional
            public String getSubnet() {
                return this.subnet;
            }

            public void setSubnet(String subnet) {
                this.subnet = subnet;
            }

            @Input
            @Optional
            public String getIpRange() {
                return this.ipRange;
            }

            public void setIpRange(String ipRange) {
                this.ipRange = ipRange;
            }

            @Input
            @Optional
            public String getGateway() {
                return this.gateway;
            }

            public void setGateway(String gateway) {
                this.gateway = gateway;
            }

            @Input
            @Optional
            public String getNetworkID() {
                return this.networkID;
            }

            public void setNetworkID(String networkID) {
                this.networkID = networkID;
            }
        }
    }
}

