/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.bmuschko.gradle.docker.shaded.javax.annotation.CheckForNull;
import com.github.dockerjava.api.model.DockerObject;
import java.io.Serializable;
import java.util.Base64;
import java.util.Map;

public class SecretSpec
extends DockerObject
implements Serializable {
    public static final long serialVersionUID = 1L;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Data")
    private String data;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;

    public String getName() {
        return this.name;
    }

    public SecretSpec withName(String name) {
        this.name = name;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public SecretSpec withData(String data) {
        this.data = Base64.getEncoder().encodeToString(data.getBytes());
        return this;
    }

    public SecretSpec withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    @CheckForNull
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretSpec)) {
            return false;
        }
        SecretSpec other = (SecretSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        return !(this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecretSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        return result;
    }

    public String toString() {
        return "SecretSpec(name=" + this.getName() + ", data=" + this.getData() + ", labels=" + this.getLabels() + ")";
    }
}

