/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.harreader;

import com.browserup.harreader.HarReaderException;
import com.browserup.harreader.HarReaderMode;
import com.browserup.harreader.jackson.DefaultMapperFactory;
import com.browserup.harreader.jackson.MapperFactory;
import com.browserup.harreader.model.Har;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;

public class HarReader {
    private final MapperFactory mapperFactory;

    public HarReader(MapperFactory mapperFactory) {
        if (mapperFactory == null) {
            throw new IllegalArgumentException("mapperFactory must not be null!");
        }
        this.mapperFactory = mapperFactory;
    }

    public HarReader() {
        this(new DefaultMapperFactory());
    }

    public Har readFromFile(File har) throws HarReaderException {
        return this.readFromFile(har, HarReaderMode.STRICT);
    }

    public Har readFromFile(File har, HarReaderMode mode) throws HarReaderException {
        ObjectMapper mapper = this.mapperFactory.instance(mode);
        try {
            return (Har)mapper.readValue(har, Har.class);
        }
        catch (IOException e) {
            throw new HarReaderException(e);
        }
    }

    public Har readFromString(String har) throws HarReaderException {
        return this.readFromString(har, HarReaderMode.STRICT);
    }

    public Har readFromString(String har, HarReaderMode mode) throws HarReaderException {
        ObjectMapper mapper = this.mapperFactory.instance(mode);
        try {
            return (Har)mapper.readValue(har, Har.class);
        }
        catch (IOException e) {
            throw new HarReaderException(e);
        }
    }
}

