/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.harreader.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HarTiming {
    private volatile long blockedNanos = -1L;
    private volatile long dnsNanos = -1L;
    private volatile long connectNanos = -1L;
    private volatile long sslNanos = -1L;
    private volatile long sendNanos = 0L;
    private volatile long waitNanos = 0L;
    private volatile long receiveNanos = 0L;
    private volatile String comment = "";

    public long getBlocked(TimeUnit timeUnit) {
        if (this.blockedNanos == -1L) {
            return -1L;
        }
        return timeUnit.convert(this.blockedNanos, TimeUnit.NANOSECONDS);
    }

    public void setBlocked(long blocked, TimeUnit timeUnit) {
        this.blockedNanos = blocked == -1L ? -1L : TimeUnit.NANOSECONDS.convert(blocked, timeUnit);
    }

    public long getDns(TimeUnit timeUnit) {
        if (this.dnsNanos == -1L) {
            return -1L;
        }
        return timeUnit.convert(this.dnsNanos, TimeUnit.NANOSECONDS);
    }

    public void setDns(long dns, TimeUnit timeUnit) {
        this.dnsNanos = dns == -1L ? -1L : TimeUnit.NANOSECONDS.convert(dns, timeUnit);
    }

    public long getConnect(TimeUnit timeUnit) {
        if (this.connectNanos == -1L) {
            return -1L;
        }
        return timeUnit.convert(this.connectNanos, TimeUnit.NANOSECONDS);
    }

    public void setConnect(long connect, TimeUnit timeUnit) {
        this.connectNanos = connect == -1L ? -1L : TimeUnit.NANOSECONDS.convert(connect, timeUnit);
    }

    public long getSend(TimeUnit timeUnit) {
        return timeUnit.convert(this.sendNanos, TimeUnit.NANOSECONDS);
    }

    public void setSend(long send, TimeUnit timeUnit) {
        this.sendNanos = TimeUnit.NANOSECONDS.convert(send, timeUnit);
    }

    public long getWait(TimeUnit timeUnit) {
        return timeUnit.convert(this.waitNanos, TimeUnit.NANOSECONDS);
    }

    public void setWait(long wait, TimeUnit timeUnit) {
        this.waitNanos = TimeUnit.NANOSECONDS.convert(wait, timeUnit);
    }

    public long getReceive(TimeUnit timeUnit) {
        return timeUnit.convert(this.receiveNanos, TimeUnit.NANOSECONDS);
    }

    public void setReceive(long receive, TimeUnit timeUnit) {
        this.receiveNanos = TimeUnit.NANOSECONDS.convert(receive, timeUnit);
    }

    public long getSsl(TimeUnit timeUnit) {
        if (this.sslNanos == -1L) {
            return -1L;
        }
        return timeUnit.convert(this.sslNanos, TimeUnit.NANOSECONDS);
    }

    public void setSsl(long ssl, TimeUnit timeUnit) {
        this.sslNanos = ssl == -1L ? -1L : TimeUnit.NANOSECONDS.convert(ssl, timeUnit);
    }

    public int getBlocked() {
        return Math.toIntExact(this.getBlocked(TimeUnit.MILLISECONDS));
    }

    public void setBlocked(Integer blocked) {
        if (blocked == null) {
            blocked = -1;
        }
        this.setBlocked(blocked.intValue(), TimeUnit.MILLISECONDS);
    }

    public int getDns() {
        return Math.toIntExact(this.getDns(TimeUnit.MILLISECONDS));
    }

    public void setDns(Integer dns) {
        if (dns == null) {
            dns = -1;
        }
        this.setDns(dns.intValue(), TimeUnit.MILLISECONDS);
    }

    public int getConnect() {
        return Math.toIntExact(this.getConnect(TimeUnit.MILLISECONDS));
    }

    public void setConnect(Integer connect) {
        if (connect == null) {
            connect = -1;
        }
        this.setConnect(connect.intValue(), TimeUnit.MILLISECONDS);
    }

    public int getSend() {
        return Math.toIntExact(this.getSend(TimeUnit.MILLISECONDS));
    }

    public void setSend(Integer send) {
        if (send == null) {
            send = 0;
        }
        this.setSend(send.intValue(), TimeUnit.MILLISECONDS);
    }

    public int getWait() {
        return Math.toIntExact(this.getWait(TimeUnit.MILLISECONDS));
    }

    public void setWait(Integer wait) {
        if (wait == null) {
            wait = 0;
        }
        this.setWait(wait.intValue(), TimeUnit.MILLISECONDS);
    }

    public int getReceive() {
        return Math.toIntExact(this.getReceive(TimeUnit.MILLISECONDS));
    }

    public void setReceive(Integer receive) {
        if (receive == null) {
            receive = 0;
        }
        this.setReceive(receive.intValue(), TimeUnit.MILLISECONDS);
    }

    public int getSsl() {
        return Math.toIntExact(this.getSsl(TimeUnit.MILLISECONDS));
    }

    public void setSsl(Integer ssl) {
        if (ssl == null) {
            ssl = -1;
        }
        this.setSsl(ssl.intValue(), TimeUnit.MILLISECONDS);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HarTiming harTiming = (HarTiming)o;
        return Objects.equals(this.blockedNanos, harTiming.blockedNanos) && Objects.equals(this.dnsNanos, harTiming.dnsNanos) && Objects.equals(this.connectNanos, harTiming.connectNanos) && Objects.equals(this.sendNanos, harTiming.sendNanos) && Objects.equals(this.waitNanos, harTiming.waitNanos) && Objects.equals(this.receiveNanos, harTiming.receiveNanos) && Objects.equals(this.sslNanos, harTiming.sslNanos) && Objects.equals(this.comment, harTiming.comment);
    }

    public int hashCode() {
        return Objects.hash(this.blockedNanos, this.dnsNanos, this.connectNanos, this.sendNanos, this.waitNanos, this.receiveNanos, this.sslNanos, this.comment);
    }
}

