/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public enum Clock {
    REAL_TIME{

        @Override
        long time() {
            return System.currentTimeMillis();
        }
    }
    ,
    NANO_TIME{

        @Override
        long time() {
            return System.nanoTime() / 1000000L;
        }
    }
    ,
    CPU_TIME{

        @Override
        long time() {
            if (mxBean.isThreadCpuTimeSupported()) {
                return mxBean.getCurrentThreadCpuTime() / 1000000L;
            }
            throw new RuntimeException("ThreadCpuTime is not supported. Impossible to use Clock.CPU_TIME");
        }
    }
    ,
    USER_TIME{

        @Override
        long time() {
            if (mxBean.isThreadCpuTimeSupported()) {
                return mxBean.getCurrentThreadUserTime() / 1000000L;
            }
            throw new RuntimeException("ThreadCpuTime is not supported. Impossible to use Clock.USER_TIME");
        }
    };

    private static final int FACTOR = 1000000;
    private static ThreadMXBean mxBean;

    abstract long time();

    static {
        mxBean = ManagementFactory.getThreadMXBean();
        if (mxBean.isThreadCpuTimeSupported()) {
            mxBean.setThreadCpuTimeEnabled(true);
        }
    }
}

