/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.ReaderContext;
import com.cedarsoftware.util.io.factory.AbstractTemporalFactory;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class OffsetTimeFactory
extends AbstractTemporalFactory<OffsetTime> {
    public OffsetTimeFactory(DateTimeFormatter dateFormatter, ZoneId zoneId) {
        super(dateFormatter, zoneId);
    }

    public OffsetTimeFactory() {
        this(DateTimeFormatter.ISO_OFFSET_TIME, ZoneId.systemDefault());
    }

    @Override
    protected OffsetTime fromNumber(Number l) {
        return OffsetTime.from(Instant.ofEpochMilli(l.longValue()));
    }

    @Override
    protected OffsetTime fromString(String s) {
        try {
            return OffsetTime.parse(s, this.dateTimeFormatter);
        }
        catch (Exception e) {
            return this.convertToZonedDateTime(s).toOffsetDateTime().toOffsetTime();
        }
    }

    @Override
    protected OffsetTime fromJsonObject(JsonObject job, ReaderContext context) {
        LocalTime time = this.parseLocalTime(job.get("time"), context);
        ZoneOffset zoneOffset = this.parseOffset(job.get("offset"), context);
        if (time == null || zoneOffset == null) {
            throw new JsonIoException("Invalid json for OffsetDateTime");
        }
        return OffsetTime.of(time, zoneOffset);
    }

    private LocalTime parseLocalTime(Object o, ReaderContext context) {
        if (o instanceof String) {
            return LocalTime.parse((String)o, this.dateTimeFormatter);
        }
        if (o instanceof JsonObject) {
            return context.reentrantConvertParsedMapsToJava((JsonObject)o, LocalTime.class);
        }
        return null;
    }

    private ZoneOffset parseOffset(Object o, ReaderContext context) {
        if (o instanceof String) {
            return ZoneOffset.of((String)o);
        }
        if (o instanceof JsonObject) {
            return context.reentrantConvertParsedMapsToJava((JsonObject)o, ZoneOffset.class);
        }
        return null;
    }
}

