/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.reflect;

import com.cedarsoftware.util.io.MetaUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Objects;

public class Accessor {
    private final Field field;
    private final String displayName;
    private MethodHandle accessor;
    private final boolean isPublic;

    public Accessor(Field field) throws Throwable {
        this.field = field;
        this.displayName = field.getName();
        this.isPublic = Modifier.isPublic(field.getModifiers());
        try {
            this.accessor = MethodHandles.lookup().unreflectGetter(field);
        }
        catch (Exception e) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
                MetaUtils.trySetAccessible(field);
            }
            this.accessor = null;
        }
    }

    public Accessor(Field field, Method method) throws Throwable {
        this.field = field;
        this.displayName = method.getName();
        this.isPublic = Modifier.isPublic(method.getModifiers());
        if (!Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            MetaUtils.trySetAccessible(method);
        }
        this.accessor = MethodHandles.lookup().unreflect(method);
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            Accessor other = (Accessor)o;
            return this.field.equals(other.field) && this.displayName.equals(other.displayName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.field);
    }

    public Object retrieve(Object o) throws Throwable {
        if (this.accessor == null) {
            return this.field.get(o);
        }
        return this.accessor.invoke(o);
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isPublic() {
        return this.isPublic;
    }
}

