/*
 * Copyright (c) 2011 Miles Sabin 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package shapeless

trait FnHListerAuxInstances {
  implicit def fnHLister0[Res] = new FnHListerAux[() => Res, (HNil) => Res] {
    def apply(fn : () => Res) = (l : HNil) => fn()
  }

  implicit def fnHLister1[A, Res] = new FnHListerAux[(A) => Res, (A :: HNil) => Res] {
    def apply(fn : (A) => Res) = (l : A :: HNil) => l match { case a :: HNil => fn(a) }
  }

  implicit def fnHLister2[A, B, Res] = new FnHListerAux[(A, B) => Res, (A :: B :: HNil) => Res] {
    def apply(fn : (A, B) => Res) = (l : A :: B :: HNil) => l match { case a :: b :: HNil => fn(a, b) }
  }

  implicit def fnHLister3[A, B, C, Res] = new FnHListerAux[(A, B, C) => Res, (A :: B :: C :: HNil) => Res] {
    def apply(fn : (A, B, C) => Res) = (l : A :: B :: C :: HNil) => l match { case a :: b :: c :: HNil => fn(a, b, c) }
  }

  implicit def fnHLister4[A, B, C, D, Res] = new FnHListerAux[(A, B, C, D) => Res, (A :: B :: C :: D :: HNil) => Res] {
    def apply(fn : (A, B, C, D) => Res) = (l : A :: B :: C :: D :: HNil) => l match { case a :: b :: c :: d :: HNil => fn(a, b, c, d) }
  }

  implicit def fnHLister5[A, B, C, D, E, Res] = new FnHListerAux[(A, B, C, D, E) => Res, (A :: B :: C :: D :: E :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E) => Res) = (l : A :: B :: C :: D :: E :: HNil) => l match { case a :: b :: c :: d :: e :: HNil => fn(a, b, c, d, e) }
  }

  implicit def fnHLister6[A, B, C, D, E, F, Res] = new FnHListerAux[(A, B, C, D, E, F) => Res, (A :: B :: C :: D :: E :: F :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F) => Res) = (l : A :: B :: C :: D :: E :: F :: HNil) => l match { case a :: b :: c :: d :: e :: f :: HNil => fn(a, b, c, d, e, f) }
  }

  implicit def fnHLister7[A, B, C, D, E, F, G, Res] = new FnHListerAux[(A, B, C, D, E, F, G) => Res, (A :: B :: C :: D :: E :: F :: G :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: HNil => fn(a, b, c, d, e, f, g) }
  }

  implicit def fnHLister8[A, B, C, D, E, F, G, H, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: HNil => fn(a, b, c, d, e, f, g, h) }
  }

  implicit def fnHLister9[A, B, C, D, E, F, G, H, I, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: HNil => fn(a, b, c, d, e, f, g, h, i) }
  }

  implicit def fnHLister10[A, B, C, D, E, F, G, H, I, J, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: HNil => fn(a, b, c, d, e, f, g, h, i, j) }
  }

  implicit def fnHLister11[A, B, C, D, E, F, G, H, I, J, K, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k) }
  }

  implicit def fnHLister12[A, B, C, D, E, F, G, H, I, J, K, L, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K, L) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K, L) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k, l) }
  }

  implicit def fnHLister13[A, B, C, D, E, F, G, H, I, J, K, L, M, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K, L, M) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K, L, M) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k, l, m) }
  }

  implicit def fnHLister14[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K, L, M, N) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K, L, M, N) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k, l, m, n) }
  }

  implicit def fnHLister15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) }
  }

  implicit def fnHLister16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) }
  }

  implicit def fnHLister17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) }
  }

  implicit def fnHLister18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: r :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) }
  }

  implicit def fnHLister19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: r :: s :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) }
  }

  implicit def fnHLister20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: r :: s :: t :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) }
  }

  implicit def fnHLister21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: U :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: U :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: r :: s :: t :: u :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u) }
  }

  implicit def fnHLister22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, Res] = new FnHListerAux[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V) => Res, (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: U :: V :: HNil) => Res] {
    def apply(fn : (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V) => Res) = (l : A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: U :: V :: HNil) => l match { case a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: r :: s :: t :: u :: v :: HNil => fn(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v) }
  }
}
