/*
 * Copyright (c) 2011 Miles Sabin 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package shapeless

trait FnUnHListerAuxInstances {
  implicit def fnUnHLister0[Res] = new FnUnHListerAux[(HNil) => Res, () => Res] {
    def apply(hf : (HNil) => Res) = () => hf(HNil)
  }

  implicit def fnUnHLister1[A, Res] = new FnUnHListerAux[(A :: HNil) => Res, (A) => Res] {
    def apply(hf : (A :: HNil) => Res) = (a : A) => hf(a :: HNil)
  }

  implicit def fnUnHLister2[A, B, Res] = new FnUnHListerAux[(A :: B :: HNil) => Res, (A, B) => Res] {
    def apply(hf : (A :: B :: HNil) => Res) = (a : A, b : B) => hf(a :: b :: HNil)
  }

  implicit def fnUnHLister3[A, B, C, Res] = new FnUnHListerAux[(A :: B :: C :: HNil) => Res, (A, B, C) => Res] {
    def apply(hf : (A :: B :: C :: HNil) => Res) = (a : A, b : B, c : C) => hf(a :: b :: c :: HNil)
  }

  implicit def fnUnHLister4[A, B, C, D, Res] = new FnUnHListerAux[(A :: B :: C :: D :: HNil) => Res, (A, B, C, D) => Res] {
    def apply(hf : (A :: B :: C :: D :: HNil) => Res) = (a : A, b : B, c : C, d : D) => hf(a :: b :: c :: d :: HNil)
  }

  implicit def fnUnHLister5[A, B, C, D, E, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: HNil) => Res, (A, B, C, D, E) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E) => hf(a :: b :: c :: d :: e :: HNil)
  }

  implicit def fnUnHLister6[A, B, C, D, E, F, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: HNil) => Res, (A, B, C, D, E, F) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F) => hf(a :: b :: c :: d :: e :: f :: HNil)
  }

  implicit def fnUnHLister7[A, B, C, D, E, F, G, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: HNil) => Res, (A, B, C, D, E, F, G) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G) => hf(a :: b :: c :: d :: e :: f :: g :: HNil)
  }

  implicit def fnUnHLister8[A, B, C, D, E, F, G, H, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: HNil) => Res, (A, B, C, D, E, F, G, H) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H) => hf(a :: b :: c :: d :: e :: f :: g :: h :: HNil)
  }

  implicit def fnUnHLister9[A, B, C, D, E, F, G, H, I, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: HNil) => Res, (A, B, C, D, E, F, G, H, I) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: HNil)
  }

  implicit def fnUnHLister10[A, B, C, D, E, F, G, H, I, J, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: HNil)
  }

  implicit def fnUnHLister11[A, B, C, D, E, F, G, H, I, J, K, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: HNil)
  }

  implicit def fnUnHLister12[A, B, C, D, E, F, G, H, I, J, K, L, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K, L) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K, l : L) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: HNil)
  }

  implicit def fnUnHLister13[A, B, C, D, E, F, G, H, I, J, K, L, M, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K, L, M) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K, l : L, m : M) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: HNil)
  }

  implicit def fnUnHLister14[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K, L, M, N) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K, l : L, m : M, n : N) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: HNil)
  }

  implicit def fnUnHLister15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K, l : L, m : M, n : N, o : O) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: HNil)
  }

  implicit def fnUnHLister16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K, l : L, m : M, n : N, o : O, p : P) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: HNil)
  }

  implicit def fnUnHLister17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K, l : L, m : M, n : N, o : O, p : P, q : Q) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: HNil)
  }

  implicit def fnUnHLister18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K, l : L, m : M, n : N, o : O, p : P, q : Q, r : R) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: r :: HNil)
  }

  implicit def fnUnHLister19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K, l : L, m : M, n : N, o : O, p : P, q : Q, r : R, s : S) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: r :: s :: HNil)
  }

  implicit def fnUnHLister20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K, l : L, m : M, n : N, o : O, p : P, q : Q, r : R, s : S, t : T) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: r :: s :: t :: HNil)
  }

  implicit def fnUnHLister21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: U :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: U :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K, l : L, m : M, n : N, o : O, p : P, q : Q, r : R, s : S, t : T, u : U) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: r :: s :: t :: u :: HNil)
  }

  implicit def fnUnHLister22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, Res] = new FnUnHListerAux[(A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: U :: V :: HNil) => Res, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V) => Res] {
    def apply(hf : (A :: B :: C :: D :: E :: F :: G :: H :: I :: J :: K :: L :: M :: N :: O :: P :: Q :: R :: S :: T :: U :: V :: HNil) => Res) = (a : A, b : B, c : C, d : D, e : E, f : F, g : G, h : H, i : I, j : J, k : K, l : L, m : M, n : N, o : O, p : P, q : Q, r : R, s : S, t : T, u : U, v : V) => hf(a :: b :: c :: d :: e :: f :: g :: h :: i :: j :: k :: l :: m :: n :: o :: p :: q :: r :: s :: t :: u :: v :: HNil)
  }
}
