/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public class Agent {
    private static final String SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY = "datadog.slf4j.simpleLogger.showDateTime";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY = "datadog.slf4j.simpleLogger.dateTimeFormat";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT = "'[dd.trace 'yyyy-MM-dd HH:mm:ss:SSS Z']'";
    private static final String SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY = "datadog.slf4j.simpleLogger.defaultLogLevel";
    private static final Logger log;
    private static ClassLoader PARENT_CLASSLOADER;
    private static ClassLoader BOOTSTRAP_PROXY;
    private static ClassLoader AGENT_CLASSLOADER;
    private static ClassLoader JMXFETCH_CLASSLOADER;
    private static ClassLoader PROFILING_CLASSLOADER;

    public static void start(Instrumentation inst, URL bootstrapURL) {
        Agent.createParentClassloader(bootstrapURL);
        Agent.startProfilingAgent(bootstrapURL, true);
        Agent.startDatadogAgent(inst, bootstrapURL);
        boolean appUsingCustomLogManager = Agent.isAppUsingCustomLogManager();
        if (appUsingCustomLogManager) {
            log.debug("Custom logger detected. Delaying JMXFetch initialization.");
            Agent.registerLogManagerCallback(new StartJmxCallback(bootstrapURL));
        } else {
            Agent.startJmx(bootstrapURL);
        }
        if (Agent.isJavaBefore9WithJFR() && appUsingCustomLogManager) {
            log.debug("Custom logger detected. Delaying Datadog Tracer initialization.");
            Agent.registerLogManagerCallback(new InstallDatadogTracerCallback(bootstrapURL));
        } else {
            Agent.installDatadogTracer();
        }
        if (Agent.isJavaBefore9() && appUsingCustomLogManager) {
            log.debug("Custom logger detected. Delaying Profiling Agent startup.");
            Agent.registerLogManagerCallback(new StartProfilingAgentCallback(inst, bootstrapURL));
        } else {
            Agent.startProfilingAgent(bootstrapURL, false);
        }
    }

    private static void registerLogManagerCallback(ClassLoadCallBack callback) {
        try {
            Class<?> agentInstallerClass = AGENT_CLASSLOADER.loadClass("datadog.trace.agent.tooling.AgentInstaller");
            Method registerCallbackMethod = agentInstallerClass.getMethod("registerClassLoadCallback", String.class, Runnable.class);
            registerCallbackMethod.invoke(null, "java.util.logging.LogManager", callback);
        }
        catch (Exception ex) {
            log.error("Error registering callback for " + callback.getName(), ex);
        }
    }

    private static synchronized void createParentClassloader(URL bootstrapURL) {
        if (PARENT_CLASSLOADER == null) {
            try {
                Class<?> bootstrapProxyClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.DatadogClassLoader$BootstrapClassLoaderProxy");
                Constructor<?> constructor = bootstrapProxyClass.getDeclaredConstructor(URL.class);
                BOOTSTRAP_PROXY = (ClassLoader)constructor.newInstance(bootstrapURL);
                ClassLoader grandParent = Agent.isJavaBefore9() ? null : Agent.getPlatformClassLoader();
                PARENT_CLASSLOADER = Agent.createDatadogClassLoader("shared", bootstrapURL, grandParent);
            }
            catch (Throwable ex) {
                log.error("Throwable thrown creating parent classloader", ex);
            }
        }
    }

    private static synchronized void startDatadogAgent(Instrumentation inst, URL bootstrapURL) {
        if (AGENT_CLASSLOADER == null) {
            try {
                ClassLoader agentClassLoader = Agent.createDelegateClassLoader("inst", bootstrapURL, PARENT_CLASSLOADER);
                Class<?> agentInstallerClass = agentClassLoader.loadClass("datadog.trace.agent.tooling.AgentInstaller");
                Method agentInstallerMethod = agentInstallerClass.getMethod("installBytebuddyAgent", Instrumentation.class);
                agentInstallerMethod.invoke(null, inst);
                AGENT_CLASSLOADER = agentClassLoader;
            }
            catch (Throwable ex) {
                log.error("Throwable thrown while installing the Datadog Agent", ex);
            }
        }
    }

    private static synchronized void installDatadogTracer() {
        if (AGENT_CLASSLOADER == null) {
            throw new IllegalStateException("Datadog agent should have been started already");
        }
        try {
            Class<?> tracerInstallerClass = AGENT_CLASSLOADER.loadClass("datadog.trace.agent.tooling.TracerInstaller");
            Method tracerInstallerMethod = tracerInstallerClass.getMethod("installGlobalTracer", new Class[0]);
            tracerInstallerMethod.invoke(null, new Object[0]);
            Method logVersionInfoMethod = tracerInstallerClass.getMethod("logVersionInfo", new Class[0]);
            logVersionInfoMethod.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while installing the Datadog Tracer", ex);
        }
    }

    private static synchronized void startJmx(URL bootstrapURL) {
        Agent.startJmxFetch(bootstrapURL);
        Agent.initializeJmxThreadCpuTimeProvider();
        Agent.registerDeadlockDetectionEvent(bootstrapURL);
    }

    private static synchronized void registerDeadlockDetectionEvent(URL bootstrapUrl) {
        log.info("Initializing JMX thread deadlock detector");
        try {
            ClassLoader classLoader = Agent.getProfilingClassloader(bootstrapUrl);
            Class<?> deadlockFactoryClass = classLoader.loadClass("com.datadog.profiling.controller.openjdk.events.DeadlockEventFactory");
            Method registerMethod = deadlockFactoryClass.getMethod("registerEvents", new Class[0]);
            registerMethod.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while initializing JMX thread deadlock detector", ex);
        }
    }

    private static synchronized void initializeJmxThreadCpuTimeProvider() {
        log.info("Initializing JMX thread CPU time provider");
        if (AGENT_CLASSLOADER == null) {
            throw new IllegalStateException("Datadog agent should have been started already");
        }
        try {
            Class<?> tracerInstallerClass = AGENT_CLASSLOADER.loadClass("datadog.trace.agent.core.util.ThreadCpuTimeAccess");
            Method enableJmxMethod = tracerInstallerClass.getMethod("enableJmx", new Class[0]);
            enableJmxMethod.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while initializing JMX thread CPU time provider", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startJmxFetch(URL bootstrapURL) {
        if (JMXFETCH_CLASSLOADER == null) {
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader jmxFetchClassLoader = Agent.createDelegateClassLoader("metrics", bootstrapURL, PARENT_CLASSLOADER);
                Thread.currentThread().setContextClassLoader(jmxFetchClassLoader);
                Class<?> jmxFetchAgentClass = jmxFetchClassLoader.loadClass("datadog.trace.agent.jmxfetch.JMXFetch");
                Method jmxFetchInstallerMethod = jmxFetchAgentClass.getMethod("run", new Class[0]);
                jmxFetchInstallerMethod.invoke(null, new Object[0]);
                JMXFETCH_CLASSLOADER = jmxFetchClassLoader;
            }
            catch (Throwable ex) {
                log.error("Throwable thrown while starting JmxFetch", ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startProfilingAgent(URL bootstrapURL, boolean isStartingFirst) {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = Agent.getProfilingClassloader(bootstrapURL);
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> profilingAgentClass = classLoader.loadClass("com.datadog.profiling.agent.ProfilingAgent");
            Method profilingInstallerMethod = profilingAgentClass.getMethod("run", Boolean.TYPE);
            profilingInstallerMethod.invoke(null, isStartingFirst);
        }
        catch (ClassFormatError e) {
            log.error("Profiling requires OpenJDK 8 or above - skipping");
            log.debug("Cannot start profiling agent ", e);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while starting profiling agent", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
    }

    private static synchronized ClassLoader getProfilingClassloader(URL bootstrapURL) throws Exception {
        if (PROFILING_CLASSLOADER == null) {
            PROFILING_CLASSLOADER = Agent.createDelegateClassLoader("profiling", bootstrapURL, PARENT_CLASSLOADER);
        }
        return PROFILING_CLASSLOADER;
    }

    private static void configureLogger() {
        Agent.setSystemPropertyDefault(SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY, "true");
        Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY, SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT);
        if (Agent.isDebugMode()) {
            Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, "DEBUG");
        }
    }

    private static void setSystemPropertyDefault(String property, String value) {
        if (System.getProperty(property) == null) {
            System.setProperty(property, value);
        }
    }

    private static ClassLoader createDatadogClassLoader(String innerJarFilename, URL bootstrapURL, ClassLoader parent) throws Exception {
        Class<?> loaderClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.DatadogClassLoader");
        Constructor<?> constructor = loaderClass.getDeclaredConstructor(URL.class, String.class, ClassLoader.class, ClassLoader.class);
        return (ClassLoader)constructor.newInstance(bootstrapURL, innerJarFilename, BOOTSTRAP_PROXY, parent);
    }

    private static ClassLoader createDelegateClassLoader(String innerJarFilename, URL bootstrapURL, ClassLoader parent) throws Exception {
        Class<?> loaderClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.DatadogClassLoader$DelegateClassLoader");
        Constructor<?> constructor = loaderClass.getDeclaredConstructor(URL.class, String.class, ClassLoader.class, ClassLoader.class, ClassLoader.class);
        ClassLoader classLoader = (ClassLoader)constructor.newInstance(bootstrapURL, innerJarFilename, BOOTSTRAP_PROXY, parent, PARENT_CLASSLOADER);
        return classLoader;
    }

    private static ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
        return (ClassLoader)method.invoke(null, new Object[0]);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "dd.trace.debug";
        String tracerDebugLevelProp = System.getProperty("dd.trace.debug");
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = System.getenv("dd.trace.debug".replace('.', '_').toUpperCase());
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    private static boolean isAppUsingCustomLogManager() {
        String tracerCustomLogManSysprop = "dd.app.customlogmanager";
        String customLogManagerProp = System.getProperty("dd.app.customlogmanager");
        String customLogManagerEnv = System.getenv("dd.app.customlogmanager".replace('.', '_').toUpperCase());
        if (customLogManagerProp != null || customLogManagerEnv != null) {
            log.debug("Prop - customlogmanager: " + customLogManagerProp);
            log.debug("Env - customlogmanager: " + customLogManagerEnv);
            return Boolean.parseBoolean(customLogManagerProp) || Boolean.parseBoolean(customLogManagerEnv);
        }
        String jbossHome = System.getenv("JBOSS_HOME");
        if (jbossHome != null) {
            log.debug("Env - jboss: " + jbossHome);
            return true;
        }
        String logManagerProp = System.getProperty("java.util.logging.manager");
        if (logManagerProp != null) {
            boolean onSysClasspath = ClassLoader.getSystemResource(logManagerProp.replaceAll("\\.", "/") + ".class") != null;
            log.debug("Prop - logging.manager: " + logManagerProp);
            log.debug("logging.manager on system classpath: " + onSysClasspath);
            return !onSysClasspath;
        }
        return false;
    }

    private static boolean isJavaBefore9() {
        return System.getProperty("java.version").startsWith("1.");
    }

    private static boolean isJavaBefore9WithJFR() {
        if (!Agent.isJavaBefore9()) {
            return false;
        }
        String jfrClassResourceName = "jdk.jfr.Recording".replace('.', '/') + ".class";
        return Thread.currentThread().getContextClassLoader().getResource(jfrClassResourceName) != null;
    }

    static {
        Agent.configureLogger();
        log = LoggerFactory.getLogger(Agent.class);
        PARENT_CLASSLOADER = null;
        BOOTSTRAP_PROXY = null;
        AGENT_CLASSLOADER = null;
        JMXFETCH_CLASSLOADER = null;
        PROFILING_CLASSLOADER = null;
    }

    protected static class StartProfilingAgentCallback
    extends ClassLoadCallBack {
        StartProfilingAgentCallback(Instrumentation inst, URL bootstrapURL) {
            super(bootstrapURL);
        }

        @Override
        public String getName() {
            return "datadog-profiler";
        }

        @Override
        public void execute() {
            Agent.startProfilingAgent(this.bootstrapURL, false);
        }
    }

    protected static class InstallDatadogTracerCallback
    extends ClassLoadCallBack {
        InstallDatadogTracerCallback(URL bootstrapURL) {
            super(bootstrapURL);
        }

        @Override
        public String getName() {
            return "datadog-tracer";
        }

        @Override
        public void execute() {
            Agent.installDatadogTracer();
        }
    }

    protected static class StartJmxCallback
    extends ClassLoadCallBack {
        StartJmxCallback(URL bootstrapURL) {
            super(bootstrapURL);
        }

        @Override
        public String getName() {
            return "jmxfetch";
        }

        @Override
        public void execute() {
            Agent.startJmx(this.bootstrapURL);
        }
    }

    protected static abstract class ClassLoadCallBack
    implements Runnable {
        final URL bootstrapURL;

        ClassLoadCallBack(URL bootstrapURL) {
            this.bootstrapURL = bootstrapURL;
        }

        @Override
        public void run() {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClassLoadCallBack.this.execute();
                    }
                    catch (Exception e) {
                        log.error("Failed to run class loader callback {}", (Object)ClassLoadCallBack.this.getName(), (Object)e);
                    }
                }
            });
            thread.setName("dd-agent-startup-" + this.getName());
            thread.setDaemon(true);
            thread.start();
        }

        public abstract String getName();

        public abstract void execute();
    }
}

