/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import java.nio.charset.StandardCharsets;

public final class UTF8BytesString
implements CharSequence {
    private final String string;
    private byte[] utf8Bytes = null;

    public static UTF8BytesString create(String string) {
        if (string == null) {
            return null;
        }
        return new UTF8BytesString(new String(string));
    }

    public static UTF8BytesString create(CharSequence chars) {
        if (chars == null) {
            return null;
        }
        if (chars instanceof UTF8BytesString) {
            return (UTF8BytesString)chars;
        }
        if (chars instanceof String) {
            return UTF8BytesString.create((String)chars);
        }
        return new UTF8BytesString(String.valueOf(chars));
    }

    private UTF8BytesString(String string) {
        this.string = string;
    }

    public byte[] getUtf8Bytes() {
        byte[] bytes = this.utf8Bytes;
        if (bytes == null) {
            this.utf8Bytes = bytes = this.string.getBytes(StandardCharsets.UTF_8);
        }
        return bytes;
    }

    @Override
    public String toString() {
        return this.string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        String that = null;
        if (o instanceof UTF8BytesString) {
            that = ((UTF8BytesString)o).string;
        }
        return this.string.equals(that);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public int length() {
        return this.string.length();
    }

    @Override
    public char charAt(int index) {
        return this.string.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.string.subSequence(start, end);
    }
}

