/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class BaseDecorator {
    private static final ClassValue<ClassName> CLASS_NAMES = new ClassValue<ClassName>(){

        @Override
        protected ClassName computeValue(Class<?> type) {
            return new ClassName(BaseDecorator.getClassName(type));
        }
    };
    protected final boolean endToEndDurationsEnabled;
    protected final boolean traceAnalyticsEnabled;
    protected final float traceAnalyticsSampleRate;

    protected BaseDecorator() {
        Config config = Config.get();
        String[] instrumentationNames = this.instrumentationNames();
        this.traceAnalyticsEnabled = instrumentationNames.length > 0 && config.isTraceAnalyticsIntegrationEnabled(this.traceAnalyticsDefault(), instrumentationNames);
        this.traceAnalyticsSampleRate = config.getInstrumentationAnalyticsSampleRate(instrumentationNames);
        this.endToEndDurationsEnabled = instrumentationNames.length > 0 && config.isEndToEndDurationEnabled(this.endToEndDurationsDefault(), instrumentationNames);
    }

    protected abstract String[] instrumentationNames();

    protected abstract String spanType();

    protected abstract String component();

    protected boolean traceAnalyticsDefault() {
        return false;
    }

    protected boolean endToEndDurationsDefault() {
        return false;
    }

    public AgentSpan afterStart(AgentSpan span) {
        assert (span != null);
        if (this.spanType() != null) {
            span.setTag("span.type", this.spanType());
        }
        span.setTag("component", this.component());
        if (this.traceAnalyticsEnabled) {
            span.setTag("_dd1.sr.eausr", this.traceAnalyticsSampleRate);
        }
        if (this.endToEndDurationsEnabled && null == span.getBaggageItem("t0")) {
            span.setBaggageItem("t0", Long.toString(TimeUnit.NANOSECONDS.toMillis(span.getStartTime())));
        }
        return span;
    }

    public AgentScope beforeFinish(AgentScope scope) {
        assert (scope != null);
        this.beforeFinish(scope.span());
        return scope;
    }

    public AgentSpan beforeFinish(AgentSpan span) {
        assert (span != null);
        return span;
    }

    public AgentScope onError(AgentScope scope, Throwable throwable) {
        assert (scope != null);
        this.onError(scope.span(), throwable);
        return scope;
    }

    public AgentSpan onError(AgentSpan span, Throwable throwable) {
        assert (span != null);
        if (throwable != null) {
            span.setError(true);
            span.addThrowable(throwable instanceof ExecutionException ? throwable.getCause() : throwable);
        }
        return span;
    }

    public AgentSpan onPeerConnection(AgentSpan span, InetSocketAddress remoteConnection) {
        assert (span != null);
        if (remoteConnection != null) {
            this.onPeerConnection(span, remoteConnection.getAddress());
            span.setTag("peer.hostname", remoteConnection.getHostName());
            span.setTag("peer.port", remoteConnection.getPort());
        }
        return span;
    }

    public AgentSpan onPeerConnection(AgentSpan span, InetAddress remoteAddress) {
        assert (span != null);
        if (remoteAddress != null) {
            span.setTag("peer.hostname", remoteAddress.getHostName());
            if (remoteAddress instanceof Inet4Address) {
                span.setTag("peer.ipv4", remoteAddress.getHostAddress());
            } else if (remoteAddress instanceof Inet6Address) {
                span.setTag("peer.ipv6", remoteAddress.getHostAddress());
            }
        }
        return span;
    }

    public String spanNameForMethod(Method method) {
        return this.spanNameForMethod(method.getDeclaringClass(), method);
    }

    public String spanNameForMethod(Class<?> clazz, Method method) {
        return this.spanNameForMethod(clazz, null == method ? null : method.getName());
    }

    public String spanNameForMethod(Class<?> clazz, String methodName) {
        ClassName cn = CLASS_NAMES.get(clazz);
        return null == methodName ? cn.getName() : cn.getMethodName(methodName);
    }

    public String spanNameForClass(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        return simpleName.isEmpty() ? CLASS_NAMES.get(clazz).getName() : simpleName;
    }

    private static String getClassName(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        if (simpleName.isEmpty()) {
            String name = clazz.getName();
            int start = name.lastIndexOf(46);
            return name.substring(start + 1);
        }
        return simpleName;
    }

    private static class ClassName {
        private final String className;
        private final ConcurrentHashMap<String, String> methodNames = new ConcurrentHashMap(1);

        private ClassName(String className) {
            this.className = className;
        }

        public String getName() {
            return this.className;
        }

        public String getMethodName(String method) {
            String prev;
            String methodName = this.methodNames.get(method);
            if (null == methodName && null != (prev = this.methodNames.putIfAbsent(method, methodName = this.className + "." + method))) {
                methodName = prev;
            }
            return methodName;
        }
    }
}

