/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

public class CallDepthThreadLocalMap {
    private static final ClassValue<ThreadLocalDepth> TLS = new ClassValue<ThreadLocalDepth>(){

        @Override
        protected ThreadLocalDepth computeValue(Class<?> type) {
            return new ThreadLocalDepth();
        }
    };

    public static int incrementCallDepth(Class<?> k) {
        return ((Depth)CallDepthThreadLocalMap.TLS.get(k).get()).increment();
    }

    public static int decrementCallDepth(Class<?> k) {
        return ((Depth)CallDepthThreadLocalMap.TLS.get(k).get()).decrement();
    }

    public static void reset(Class<?> k) {
        ((Depth)TLS.get(k).get()).depth = 0;
    }

    private static final class ThreadLocalDepth
    extends ThreadLocal<Depth> {
        private ThreadLocalDepth() {
        }

        @Override
        protected Depth initialValue() {
            return new Depth();
        }
    }

    private static final class Depth {
        private int depth = 0;

        private Depth() {
        }

        private int increment() {
            return this.depth++;
        }

        private int decrement() {
            return --this.depth;
        }
    }
}

