/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.exceptions;

import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.exceptions.ExceptionHistogram;
import datadog.trace.bootstrap.instrumentation.exceptions.ExceptionSampleEvent;
import datadog.trace.bootstrap.instrumentation.exceptions.ExceptionSampler;

public final class ExceptionProfiling {
    private static final ExceptionProfiling INSTANCE = new ExceptionProfiling(Config.get());
    private final ExceptionHistogram histogram;
    private final ExceptionSampler sampler;

    public static ExceptionProfiling getInstance() {
        return INSTANCE;
    }

    private ExceptionProfiling(Config config) {
        this(new ExceptionSampler(config), new ExceptionHistogram(config));
    }

    ExceptionProfiling(ExceptionSampler sampler, ExceptionHistogram histogram) {
        this.sampler = sampler;
        this.histogram = histogram;
    }

    public ExceptionSampleEvent process(Throwable t) {
        boolean firstHit = this.histogram.record(t);
        boolean sampled = this.sampler.sample();
        if (firstHit || sampled) {
            return new ExceptionSampleEvent(t, sampled, firstHit);
        }
        return null;
    }
}

