/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.exceptions;

import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.exceptions.ExceptionSampleEvent;
import datadog.trace.bootstrap.instrumentation.exceptions.StreamingSampler;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import jdk.jfr.EventType;

final class ExceptionSampler {
    private static final Duration SAMPLING_WINDOW = Duration.of(500L, ChronoUnit.MILLIS);
    private final StreamingSampler sampler;
    private final EventType exceptionSampleType;

    ExceptionSampler(Config config) {
        this(SAMPLING_WINDOW, ExceptionSampler.getSamplesPerWindow(config), ExceptionSampler.samplingWindowsPerRecording(config));
    }

    ExceptionSampler(Duration windowDuration, int samplesPerWindow, int lookback) {
        this.sampler = new StreamingSampler(windowDuration, samplesPerWindow, lookback);
        this.exceptionSampleType = EventType.getEventType(ExceptionSampleEvent.class);
    }

    private static int samplingWindowsPerRecording(Config config) {
        return (int)Math.min(Duration.of(config.getProfilingUploadPeriod(), ChronoUnit.SECONDS).toMillis() / SAMPLING_WINDOW.toMillis(), Integer.MAX_VALUE);
    }

    private static int getSamplesPerWindow(Config config) {
        return config.getProfilingExceptionSampleLimit() / ExceptionSampler.samplingWindowsPerRecording(config);
    }

    boolean sample() {
        return this.exceptionSampleType.isEnabled() && this.sampler.sample();
    }
}

