/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.sampling;

import datadog.trace.util.AgentTaskScheduler;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

public final class AdaptiveSampler {
    private static final int CARRIED_OVER_BUDGET_LOOK_BACK = 16;
    private final double emaAlpha;
    private final int samplesPerWindow;
    private final AtomicReference<Counts> countsRef;
    private volatile double probability = 1.0;
    private volatile long samplesBudget;
    private double totalCountRunningAverage = 0.0;
    private double avgSamples;
    private final double budgetAlpha;

    public AdaptiveSampler(Duration windowDuration, int samplesPerWindow, int lookback, AgentTaskScheduler taskScheduler) {
        this.samplesPerWindow = samplesPerWindow;
        this.samplesBudget = samplesPerWindow + 16 * samplesPerWindow;
        this.emaAlpha = AdaptiveSampler.computeIntervalAlpha(lookback);
        this.budgetAlpha = AdaptiveSampler.computeIntervalAlpha(16);
        this.countsRef = new AtomicReference<Counts>(new Counts());
        taskScheduler.weakScheduleAtFixedRate(RollWindowTask.INSTANCE, this, windowDuration.toNanos(), windowDuration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public AdaptiveSampler(Duration windowDuration, int samplesPerWindow, int lookback) {
        this(windowDuration, samplesPerWindow, lookback, AgentTaskScheduler.INSTANCE);
    }

    public final boolean sample() {
        Counts counts = this.countsRef.get();
        counts.addTest();
        if (ThreadLocalRandom.current().nextDouble() < this.probability) {
            return counts.addSample(this.samplesBudget);
        }
        return false;
    }

    private void rollWindow() {
        Counts counts = this.countsRef.getAndSet(new Counts());
        long totalCount = counts.testCounter.sum();
        long sampledCount = counts.sampleCounter.get();
        this.samplesBudget = this.calculateBudgetEma(sampledCount);
        this.totalCountRunningAverage = this.totalCountRunningAverage == 0.0 ? (double)totalCount : (this.totalCountRunningAverage += this.emaAlpha * ((double)totalCount - this.totalCountRunningAverage));
        this.probability = this.totalCountRunningAverage <= 0.0 ? 1.0 : Math.min((double)this.samplesBudget / this.totalCountRunningAverage, 1.0);
    }

    private long calculateBudgetEma(long sampledCount) {
        this.avgSamples = Double.isNaN(this.avgSamples) ? (double)sampledCount : this.avgSamples + this.budgetAlpha * ((double)sampledCount - this.avgSamples);
        return Math.round(Math.max((double)this.samplesPerWindow - this.avgSamples, 0.0) * 16.0);
    }

    private static double computeIntervalAlpha(int lookback) {
        return 1.0 - Math.pow(lookback, -1.0 / (double)lookback);
    }

    private static class RollWindowTask
    implements AgentTaskScheduler.Task<AdaptiveSampler> {
        static final RollWindowTask INSTANCE = new RollWindowTask();

        private RollWindowTask() {
        }

        @Override
        public void run(AdaptiveSampler target) {
            target.rollWindow();
        }
    }

    private static final class Counts {
        private final LongAdder testCounter = new LongAdder();
        private final AtomicLong sampleCounter = new AtomicLong(0L);

        private Counts() {
        }

        void addTest() {
            this.testCounter.increment();
        }

        boolean addSample(long limit) {
            return this.sampleCounter.getAndUpdate(s -> s + (long)(s < limit ? 1 : 0)) < limit;
        }
    }
}

