/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import datadog.trace.bootstrap.instrumentation.decorator.BaseDecorator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class TestDecorator
extends BaseDecorator {
    private static final Logger log = LoggerFactory.getLogger(TestDecorator.class);
    public static final String TEST_TYPE = "test";
    public static final String TEST_PASS = "pass";
    public static final String TEST_FAIL = "fail";
    public static final String TEST_SKIP = "skip";
    private final boolean isCI;
    private final Map<String, String> ciTags;

    public TestDecorator() {
        this(CIProviderInfo.selectCI());
    }

    TestDecorator(CIProviderInfo ciInfo) {
        this.isCI = ciInfo.isCI();
        this.ciTags = ciInfo.getCiTags();
    }

    public boolean isCI() {
        return this.isCI;
    }

    public Map<String, String> getCiTags() {
        return this.ciTags;
    }

    protected abstract String testFramework();

    protected String testType() {
        return TEST_TYPE;
    }

    protected String spanKind() {
        return TEST_TYPE;
    }

    protected String runtimeName() {
        return System.getProperty("java.runtime.name");
    }

    protected String runtimeVendor() {
        return System.getProperty("java.vendor");
    }

    protected String runtimeVersion() {
        return System.getProperty("java.version");
    }

    protected String osArch() {
        return System.getProperty("os.arch");
    }

    protected String osPlatform() {
        return System.getProperty("os.name");
    }

    protected String osVersion() {
        return System.getProperty("os.version");
    }

    @Override
    protected CharSequence spanType() {
        return TEST_TYPE;
    }

    @Override
    public AgentSpan afterStart(AgentSpan span) {
        span.setTag("span.kind", this.spanKind());
        span.setTag("test.framework", this.testFramework());
        span.setTag("test.type", this.testType());
        span.setSamplingPriority(1);
        span.setTag("runtime.name", this.runtimeName());
        span.setTag("runtime.vendor", this.runtimeVendor());
        span.setTag("runtime.version", this.runtimeVersion());
        span.setTag("os.architecture", this.osArch());
        span.setTag("os.platform", this.osPlatform());
        span.setTag("os.version", this.osVersion());
        for (Map.Entry<String, String> ciTag : this.ciTags.entrySet()) {
            span.setTag(ciTag.getKey(), ciTag.getValue());
        }
        return super.afterStart(span);
    }

    public List<String> testNames(Class<?> testClass, Class<? extends Annotation> testAnnotation) {
        Method[] methods;
        ArrayList<String> testNames = new ArrayList<String>();
        for (Method method : methods = testClass.getMethods()) {
            if (method.getAnnotation(testAnnotation) == null) continue;
            testNames.add(method.getName());
        }
        return testNames;
    }

    public boolean isTestSpan(AgentSpan activeSpan) {
        if (activeSpan == null) {
            return false;
        }
        return this.spanKind().equals(activeSpan.getSpanType()) && this.testType().equals(activeSpan.getTag("test.type"));
    }
}

