/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.glue.cdt;

import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.ToolFactory;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EclipseCdtFormatterStepImpl {
    private final CodeFormatter codeFormatter;

    public EclipseCdtFormatterStepImpl(Properties settings) throws Exception {
        Stream stream = settings.entrySet().stream();
        Map<String, String> settingsMap = stream.collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
        this.codeFormatter = ToolFactory.createDefaultCodeFormatter(settingsMap);
    }

    public String format(String raw) throws Exception {
        TextEdit edit = this.codeFormatter.format(0, raw, 0, raw.length(), 0, "\n");
        if (edit == null) {
            throw new IllegalArgumentException("Invalid C/C++ syntax for formatting.");
        }
        Document doc = new Document(raw);
        edit.apply((IDocument)doc);
        return doc.get();
    }
}

