/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public final class Jsr223Step {
    private Jsr223Step() {
    }

    public static FormatterStep create(String name, String dependency, CharSequence engine, CharSequence script, Provisioner provisioner) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(engine, "engine");
        Objects.requireNonNull(script, "script");
        return FormatterStep.createLazy(name, () -> new State(dependency == null ? null : JarState.from(dependency, provisioner), engine, script), State::toFormatter);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;
        private final String engine;
        private final String script;

        State(JarState jarState, CharSequence engine, CharSequence script) {
            this.jarState = jarState;
            this.engine = engine.toString();
            this.script = script.toString();
        }

        FormatterFunc toFormatter() {
            ScriptEngineManager scriptEngineManager = this.jarState == null ? new ScriptEngineManager(ClassLoader.getSystemClassLoader()) : new ScriptEngineManager(this.jarState.getClassLoader());
            ScriptEngine scriptEngine = scriptEngineManager.getEngineByName(this.engine);
            if (scriptEngine == null) {
                throw new IllegalArgumentException("Unknown script engine '" + this.engine + "'. Available engines: " + scriptEngineManager.getEngineFactories().stream().flatMap(f -> f.getNames().stream()).collect(Collectors.joining(", ")));
            }
            return raw -> {
                scriptEngine.put("source", raw);
                return (String)scriptEngine.eval(this.script);
            };
        }
    }
}

