/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.json.gson;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.json.gson.GsonConfig;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class GsonStep {
    private static final String MAVEN_COORDINATES = "com.google.code.gson:gson";
    private static final String INCOMPATIBLE_ERROR_MESSAGE = "There was a problem interacting with Gson; maybe you set an incompatible version?";

    @Deprecated
    public static FormatterStep create(int indentSpaces, boolean sortByKeys, boolean escapeHtml, String version, Provisioner provisioner) {
        return GsonStep.create(new GsonConfig(sortByKeys, escapeHtml, indentSpaces, version), provisioner);
    }

    public static FormatterStep create(GsonConfig gsonConfig, Provisioner provisioner) {
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.createLazy("gson", () -> new State(gsonConfig, provisioner), State::toFormatter);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = -3240568265160440420L;
        private final JarState jarState;
        private final GsonConfig gsonConfig;

        private State(GsonConfig gsonConfig, Provisioner provisioner) throws IOException {
            this.gsonConfig = gsonConfig;
            this.jarState = JarState.from("com.google.code.gson:gson:" + gsonConfig.getVersion(), provisioner);
        }

        FormatterFunc toFormatter() {
            try {
                Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.gson.GsonFormatterFunc");
                Constructor<?> constructor = formatterFunc.getConstructor(GsonConfig.class);
                return (FormatterFunc)constructor.newInstance(this.gsonConfig);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException cause) {
                throw new IllegalStateException(GsonStep.INCOMPATIBLE_ERROR_MESSAGE, cause);
            }
        }
    }
}

