/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;

final class EncodingErrorMsg {
    static final char UNREPRESENTABLE = '\ufffd';
    private static final int CONTEXT = 3;
    private final ByteBuffer byteBuf;
    private final CharBuffer charBuf;
    private final int unrepresentable;
    private final StringBuilder message;

    @Nullable
    static String msg(String chars, byte[] bytes, Charset charset) {
        int unrepresentable = chars.indexOf(65533);
        if (unrepresentable == -1) {
            return null;
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(bytes);
        CharBuffer charBuf = CharBuffer.allocate(chars.length());
        CoderResult result = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(byteBuf, charBuf, true);
        if (!result.isError()) {
            return null;
        }
        return new EncodingErrorMsg((String)chars, (ByteBuffer)byteBuf, (Charset)charset, (int)unrepresentable).message.toString();
    }

    private EncodingErrorMsg(String chars, ByteBuffer byteBuf, Charset charset, int unrepresentable) {
        this.byteBuf = byteBuf;
        this.unrepresentable = unrepresentable;
        this.charBuf = CharBuffer.allocate(Math.min(unrepresentable + 6, chars.length()));
        this.message = new StringBuilder("Encoding error! ");
        if (charset.equals(StandardCharsets.UTF_8)) {
            this.message.append("Spotless uses UTF-8 by default.");
        } else {
            this.message.append("You configured Spotless to use ").append(charset.name()).append(".");
        }
        int line = 1;
        int col = 1;
        for (int i = 0; i < unrepresentable; ++i) {
            char c = chars.charAt(i);
            if (c == '\n') {
                ++line;
                col = 1;
                continue;
            }
            if (c == '\r') continue;
            ++col;
        }
        this.message.append("  At line ").append(line).append(" col ").append(col).append(":");
        LinkedHashSet<Charset> encodings = new LinkedHashSet<Charset>();
        encodings.add(charset);
        encodings.add(StandardCharsets.UTF_8);
        EncodingErrorMsg.addIfAvailable(encodings, "windows-1252");
        encodings.add(StandardCharsets.ISO_8859_1);
        EncodingErrorMsg.addIfAvailable(encodings, "Shift_JIS");
        EncodingErrorMsg.addIfAvailable(encodings, "Big5");
        EncodingErrorMsg.addIfAvailable(encodings, "Big5-HKSCS");
        EncodingErrorMsg.addIfAvailable(encodings, "GBK");
        EncodingErrorMsg.addIfAvailable(encodings, "GB2312");
        EncodingErrorMsg.addIfAvailable(encodings, "GB18030");
        Iterator iterator = encodings.iterator();
        this.appendExample((Charset)iterator.next(), true);
        while (iterator.hasNext()) {
            this.appendExample((Charset)iterator.next(), false);
        }
    }

    private static void addIfAvailable(Collection<Charset> charsets, String name) {
        try {
            charsets.add(Charset.forName(name));
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
    }

    private void appendExample(Charset charset, boolean must) {
        this.byteBuf.clear();
        this.charBuf.clear();
        CharsetDecoder decoder = charset.newDecoder();
        if (!must) {
            CoderResult r = decoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(this.byteBuf, this.charBuf, true);
            if (r.isError()) {
                return;
            }
        } else {
            decoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(this.byteBuf, this.charBuf, true);
        }
        this.charBuf.flip();
        int start = Math.max(this.unrepresentable - 3, 0);
        int end = Math.min(this.charBuf.limit(), this.unrepresentable + 3 + 1);
        this.message.append('\n');
        this.message.append(this.charBuf.subSequence(start, end).toString().replace('\n', '\u2424').replace('\r', '\u240d').replace('\t', '\u21e5'));
        this.message.append(" <- ");
        this.message.append(charset.name());
    }
}

