/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public final class ExpandWildcardImportsStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String INCOMPATIBLE_ERROR_MESSAGE = "There was a problem interacting with Java-Parser; maybe you set an incompatible version?";
    private static final String MAVEN_COORDINATES = "com.github.javaparser:javaparser-symbol-solver-core";
    public static final String DEFAULT_VERSION = "3.27.1";
    private final Collection<File> typeSolverClasspath;
    private final JarState.Promised jarState;

    private ExpandWildcardImportsStep(Collection<File> typeSolverClasspath, JarState.Promised jarState) {
        this.typeSolverClasspath = typeSolverClasspath;
        this.jarState = jarState;
    }

    public static FormatterStep create(Set<File> typeSolverClasspath, Provisioner provisioner) {
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.create("expandwildcardimports", new ExpandWildcardImportsStep(typeSolverClasspath, JarState.promise(() -> JarState.from("com.github.javaparser:javaparser-symbol-solver-core:3.27.1", provisioner))), ExpandWildcardImportsStep::equalityState, State::toFormatter);
    }

    private State equalityState() {
        return new State(this.typeSolverClasspath, this.jarState.get());
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Collection<File> typeSolverClasspath;
        private final JarState jarState;

        public State(Collection<File> typeSolverClasspath, JarState jarState) {
            this.typeSolverClasspath = typeSolverClasspath;
            this.jarState = jarState;
        }

        FormatterFunc toFormatter() {
            try {
                return (FormatterFunc)this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.javaparser.ExpandWildcardsFormatterFunc").getConstructor(Collection.class).newInstance(this.typeSolverClasspath);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException cause) {
                throw new IllegalStateException(ExpandWildcardImportsStep.INCOMPATIBLE_ERROR_MESSAGE, cause);
            }
        }
    }
}

