/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.spotless.GitPrePushHookInstaller;
import com.diffplug.spotless.GitPrePushHookInstallerGradle;
import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="not worth caching")
public abstract class SpotlessInstallPrePushHookTask
extends DefaultTask {
    @Internal
    abstract Property<File> getRootDir();

    @Internal
    abstract Property<Boolean> getIsRootExecution();

    @TaskAction
    public void performAction() throws Exception {
        if (!((Boolean)this.getIsRootExecution().get()).booleanValue()) {
            this.getLogger().debug("Skipping Spotless pre-push hook installation because it is not being executed from the root project.");
            return;
        }
        GitPrePushHookInstaller.GitPreHookLogger logger = new GitPrePushHookInstaller.GitPreHookLogger(){

            public void info(String format, Object ... arguments) {
                SpotlessInstallPrePushHookTask.this.getLogger().lifecycle(format.formatted(arguments));
            }

            public void warn(String format, Object ... arguments) {
                SpotlessInstallPrePushHookTask.this.getLogger().warn(format.formatted(arguments));
            }

            public void error(String format, Object ... arguments) {
                SpotlessInstallPrePushHookTask.this.getLogger().error(format.formatted(arguments));
            }
        };
        GitPrePushHookInstallerGradle installer = new GitPrePushHookInstallerGradle(logger, (File)this.getRootDir().get());
        installer.install();
    }
}

