/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.icu.text.MeasureFormat;
import androidx.annotation.RequiresApi;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.JSRangeErrorException;
import java.text.AttributedCharacterIterator;

public interface IPlatformNumberFormatter {
    public IPlatformNumberFormatter configure(ILocaleObject<?> var1, String var2, Style var3, CurrencySign var4, Notation var5, CompactDisplay var6) throws JSRangeErrorException;

    public String getDefaultNumberingSystem(ILocaleObject<?> var1) throws JSRangeErrorException;

    public IPlatformNumberFormatter setCurrency(String var1, CurrencyDisplay var2) throws JSRangeErrorException;

    public IPlatformNumberFormatter setGrouping(boolean var1);

    public IPlatformNumberFormatter setMinIntergerDigits(int var1);

    public IPlatformNumberFormatter setSignificantDigits(RoundingType var1, int var2, int var3) throws JSRangeErrorException;

    public IPlatformNumberFormatter setFractionDigits(RoundingType var1, int var2, int var3);

    public IPlatformNumberFormatter setSignDisplay(SignDisplay var1);

    public IPlatformNumberFormatter setUnits(String var1, UnitDisplay var2) throws JSRangeErrorException;

    public String format(double var1) throws JSRangeErrorException;

    public String fieldToString(AttributedCharacterIterator.Attribute var1, double var2);

    public AttributedCharacterIterator formatToParts(double var1) throws JSRangeErrorException;

    public String[] getAvailableLocales();

    public static enum RoundingType {
        SIGNIFICANT_DIGITS,
        FRACTION_DIGITS,
        COMPACT_ROUNDING;

    }

    public static enum CurrencySign {
        STANDARD,
        ACCOUNTING;


        public String toString() {
            switch (this) {
                case ACCOUNTING: {
                    return "accounting";
                }
                case STANDARD: {
                    return "standard";
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum CurrencyDisplay {
        SYMBOL,
        NARROWSYMBOL,
        CODE,
        NAME;


        public String toString() {
            switch (this) {
                case SYMBOL: {
                    return "symbol";
                }
                case NARROWSYMBOL: {
                    return "narrowSymbol";
                }
                case CODE: {
                    return "code";
                }
                case NAME: {
                    return "name";
                }
            }
            throw new IllegalArgumentException();
        }

        public int getNameStyle() {
            switch (this) {
                case NAME: {
                    return 1;
                }
            }
            return 0;
        }
    }

    public static enum UnitDisplay {
        SHORT,
        NARROW,
        LONG;


        public String toString() {
            switch (this) {
                case SHORT: {
                    return "short";
                }
                case NARROW: {
                    return "narrow";
                }
                case LONG: {
                    return "long";
                }
            }
            throw new IllegalArgumentException();
        }

        @RequiresApi(api=24)
        public MeasureFormat.FormatWidth getFormatWidth() {
            switch (this) {
                case LONG: {
                    return MeasureFormat.FormatWidth.WIDE;
                }
                case NARROW: {
                    return MeasureFormat.FormatWidth.NARROW;
                }
            }
            return MeasureFormat.FormatWidth.SHORT;
        }
    }

    public static enum SignDisplay {
        AUTO,
        ALWAYS,
        NEVER,
        EXCEPTZERO;


        public String toString() {
            switch (this) {
                case AUTO: {
                    return "auto";
                }
                case ALWAYS: {
                    return "always";
                }
                case NEVER: {
                    return "never";
                }
                case EXCEPTZERO: {
                    return "exceptZero";
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum CompactDisplay {
        SHORT,
        LONG;


        public String toString() {
            switch (this) {
                case SHORT: {
                    return "short";
                }
                case LONG: {
                    return "long";
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum Notation {
        STANDARD,
        SCIENTIFIC,
        ENGINEERING,
        COMPACT;


        public String toString() {
            switch (this) {
                case STANDARD: {
                    return "standard";
                }
                case SCIENTIFIC: {
                    return "scientific";
                }
                case ENGINEERING: {
                    return "engineering";
                }
                case COMPACT: {
                    return "compact";
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum Style {
        DECIMAL,
        PERCENT,
        CURRENCY,
        UNIT;


        public String toString() {
            switch (this) {
                case DECIMAL: {
                    return "decimal";
                }
                case PERCENT: {
                    return "percent";
                }
                case CURRENCY: {
                    return "currency";
                }
                case UNIT: {
                    return "unit";
                }
            }
            throw new IllegalArgumentException();
        }

        public int getInitialNumberFormatStyle(Notation notation, CurrencySign currencySign) throws JSRangeErrorException {
            return switch (this) {
                case CURRENCY -> {
                    if (currencySign == CurrencySign.ACCOUNTING) {
                        yield 7;
                    }
                    if (currencySign == CurrencySign.STANDARD) {
                        yield 1;
                    }
                    throw new JSRangeErrorException("Unrecognized formatting style requested.");
                }
                case PERCENT -> 2;
                default -> notation == Notation.SCIENTIFIC || notation == Notation.ENGINEERING ? 3 : 0;
            };
        }
    }
}

