/*
 * Decompiled with CFR 0.152.
 */
package com.geirsson.shaded.coursier;

import com.geirsson.shaded.coursier.AuthenticatedURLConnection;
import com.geirsson.shaded.coursier.Cache;
import com.geirsson.shaded.coursier.CachePath;
import com.geirsson.shaded.coursier.CachePolicy;
import com.geirsson.shaded.coursier.CachePolicy$FetchMissing$;
import com.geirsson.shaded.coursier.CachePolicy$ForceDownload$;
import com.geirsson.shaded.coursier.CachePolicy$LocalOnly$;
import com.geirsson.shaded.coursier.CachePolicy$LocalUpdate$;
import com.geirsson.shaded.coursier.CachePolicy$LocalUpdateChanging$;
import com.geirsson.shaded.coursier.CachePolicy$Update$;
import com.geirsson.shaded.coursier.CachePolicy$UpdateChanging$;
import com.geirsson.shaded.coursier.FileError;
import com.geirsson.shaded.coursier.FileError$NotFound$;
import com.geirsson.shaded.coursier.core.Artifact;
import com.geirsson.shaded.coursier.core.Authentication;
import com.geirsson.shaded.coursier.ivy.IvyRepository;
import com.geirsson.shaded.coursier.ivy.IvyRepository$;
import com.geirsson.shaded.coursier.ivy.Pattern;
import com.geirsson.shaded.coursier.ivy.Pattern$;
import com.geirsson.shaded.coursier.ivy.Pattern$Chunk$;
import com.geirsson.shaded.coursier.util.EitherT;
import com.geirsson.shaded.coursier.util.Schedulable;
import com.geirsson.shaded.coursier.util.Schedulable$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLException;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Cache$ {
    public static Cache$ MODULE$;
    private int retryCount;
    private String ivy2HomeUri;
    private IvyRepository ivy2Local;
    private IvyRepository ivy2Cache;
    private File default;
    private ExecutorService defaultPool;
    private Option<Duration> defaultTtl;
    private final Seq<Option<String>> defaultChecksums;
    private final int partialContentResponseCode;
    private final int invalidPartialContentResponseCode;
    private final ConcurrentHashMap<String, Option<URLStreamHandler>> handlerClsCache;
    private final Regex coursier$Cache$$BasicRealm;
    private final java.util.regex.Pattern coursier$Cache$$checksumPattern;
    private final int defaultConcurrentDownloadCount;
    private final ConcurrentHashMap<String, Object> urlLocks;
    private int bufferSize;
    private volatile byte bitmap$0;

    static {
        new Cache$();
    }

    public void closeConn(URLConnection conn) {
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> conn.getInputStream()).toOption().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Cache$.$anonfun$closeConn$2(x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> httpURLConnection.getErrorStream()).toOption().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Cache$.$anonfun$closeConn$5(x$3))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.close();
                return BoxedUnit.UNIT;
            });
            httpURLConnection.disconnect();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Seq<Option<String>> defaultChecksums() {
        return this.defaultChecksums;
    }

    public File localFile(String url, File cache, Option<String> user, boolean localArtifactsShouldBeCached) {
        return CachePath.localFile(url, cache, (String)user.orNull(Predef$.MODULE$.$conforms()), localArtifactsShouldBeCached);
    }

    private void readFullyTo(InputStream in, OutputStream out, Option<Cache.Logger> logger, String url, long alreadyDownloaded) {
        byte[] b = (byte[])Array$.MODULE$.fill(this.bufferSize(), (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, in, out, logger, url, b);
    }

    private <T> T withStructureLock(File cache, Function0<T> f) {
        return (T)CachePath.withStructureLock(cache, new Callable<T>(f){
            private final Function0 f$1;

            public T call() {
                return (T)this.f$1.apply();
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    private <T> Either<FileError, T> withLockOr(File cache, File file, Function0<Either<FileError, T>> f, Function0<Option<Either<FileError, T>>> ifLocked) {
        Either either;
        File lockFile = CachePath.lockFile(file);
        ObjectRef out = ObjectRef.create(null);
        this.withStructureLock(cache, (Function0<T>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            lockFile.getParentFile().mkdirs();
            out$2.elem = new FileOutputStream(lockFile);
        });
        try {
            either = this.loop$1(f, ifLocked, lockFile, out);
        }
        finally {
            if ((FileOutputStream)out.elem != null) {
                ((FileOutputStream)out.elem).close();
            }
        }
        return either;
    }

    public <T> Either<FileError, T> withLockFor(File cache, File file, Function0<Either<FileError, T>> f) {
        return this.withLockOr(cache, file, f, (Function0 & Serializable & scala.Serializable)() -> new Some((Object)scala.package$.MODULE$.Left().apply((Object)new FileError.Locked(file))));
    }

    private int defaultRetryCount() {
        return 3;
    }

    private int retryCount$lzycompute() {
        Cache$ cache$ = this;
        synchronized (cache$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.retryCount = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("coursier.sslexception-retry").flatMap((Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toInt()).toOption()).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.defaultRetryCount()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.retryCount;
    }

    private int retryCount() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.retryCount$lzycompute() : this.retryCount;
    }

    private <T> Either<FileError, T> downloading(String url, File file, Option<Cache.Logger> logger, int retry, Function0<Either<FileError, T>> f) {
        return this.helper$2(retry, url, f);
    }

    private int partialContentResponseCode() {
        return this.partialContentResponseCode;
    }

    private int invalidPartialContentResponseCode() {
        return this.invalidPartialContentResponseCode;
    }

    private ConcurrentHashMap<String, Option<URLStreamHandler>> handlerClsCache() {
        return this.handlerClsCache;
    }

    private Option<URLStreamHandler> handlerFor(String url) {
        Option option;
        String protocol = (String)new StringOps(Predef$.MODULE$.augmentString(url)).takeWhile((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Cache$.$anonfun$handlerFor$1(BoxesRunTime.unboxToChar((Object)x$8))));
        Option option2 = Option$.MODULE$.apply(this.handlerClsCache().get(protocol));
        if (None$.MODULE$.equals(option2)) {
            String clsName = new StringBuilder(31).append("com.geirsson.shaded.coursier.cache.protocol.").append(new StringOps(Predef$.MODULE$.augmentString(protocol)).capitalize()).append("Handler").toString();
            Option clsOpt0 = Cache$.clsOpt$1(Thread.currentThread().getContextClassLoader(), clsName).orElse((Function0 & Serializable & scala.Serializable)() -> Cache$.clsOpt$1(MODULE$.getClass().getClassLoader(), clsName));
            Option handlerFactoryOpt = clsOpt0.flatMap((Function1 & Serializable & scala.Serializable)cls -> {
                Some some;
                try {
                    some = new Some((Object)((URLStreamHandlerFactory)cls.newInstance()));
                }
                catch (InstantiationException e) {
                    Cache$.printError$1(e, clsName);
                    some = None$.MODULE$;
                }
                catch (IllegalAccessException e) {
                    Cache$.printError$1(e, clsName);
                    some = None$.MODULE$;
                }
                catch (ClassCastException e) {
                    Cache$.printError$1(e, clsName);
                    some = None$.MODULE$;
                }
                return some;
            });
            Option handlerOpt = handlerFactoryOpt.flatMap((Function1 & Serializable & scala.Serializable)factory -> {
                Some some;
                try {
                    some = new Some((Object)factory.createURLStreamHandler(protocol));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    Console$.MODULE$.err().println(new StringBuilder(31).append("Cannot get handler for ").append(protocol).append(" from ").append(clsName).append(": ").append(e).append(Option$.MODULE$.apply((Object)e.getMessage()).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$10 -> new StringBuilder(3).append(" (").append((String)x$10).append(")").toString())).toString());
                    None$ none$ = None$.MODULE$;
                    some = none$;
                }
                return some;
            });
            Option prevOpt = Option$.MODULE$.apply(this.handlerClsCache().putIfAbsent(protocol, (Option<URLStreamHandler>)handlerOpt));
            option = (Option)prevOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> handlerOpt);
        } else if (option2 instanceof Some) {
            Option handlerOpt;
            Some some = (Some)option2;
            option = handlerOpt = (Option)some.value();
        } else {
            throw new MatchError((Object)option2);
        }
        return option;
    }

    public Regex coursier$Cache$$BasicRealm() {
        return this.coursier$Cache$$BasicRealm;
    }

    private String basicAuthenticationEncode(String user, String password) {
        return Base64.getEncoder().encodeToString(new StringBuilder(1).append(user).append(":").append(password).toString().getBytes(StandardCharsets.UTF_8));
    }

    public URL url(String s) {
        return new URL(null, s, (URLStreamHandler)this.handlerFor(s).orNull(Predef$.MODULE$.$conforms()));
    }

    public URLConnection urlConnection(String url0, Option<Authentication> authentication) {
        URLConnection uRLConnection;
        ObjectRef conn = ObjectRef.create(null);
        try {
            conn.elem = this.url(url0).openConnection();
            ((URLConnection)conn.elem).setRequestProperty("User-Agent", "");
            authentication.foreach((Function1 & Serializable & scala.Serializable)auth -> {
                Cache$.$anonfun$urlConnection$1(conn, auth);
                return BoxedUnit.UNIT;
            });
            uRLConnection = (URLConnection)conn.elem;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                if ((URLConnection)conn.elem != null) {
                    this.closeConn((URLConnection)conn.elem);
                }
                throw e;
            }
            throw throwable;
        }
        return uRLConnection;
    }

    private Either<FileError, Option<Object>> contentLength(String url, Option<Authentication> authentication, Option<Cache.Logger> logger) {
        Left left;
        URLConnection conn = null;
        try {
            Left left2;
            URLConnection uRLConnection = conn = this.urlConnection(url, authentication);
            if (uRLConnection instanceof HttpURLConnection) {
                Right right;
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                logger.foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                    x$11.gettingLength(url);
                    return BoxedUnit.UNIT;
                });
                boolean success = false;
                try {
                    httpURLConnection.setRequestMethod("HEAD");
                    Option len = new Some((Object)BoxesRunTime.boxToLong((long)httpURLConnection.getContentLengthLong())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$12 -> x$12 >= 0L);
                    success = true;
                    logger.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                        x$13.gettingLengthResult(url, (Option<Object>)len);
                        return BoxedUnit.UNIT;
                    });
                    right = scala.package$.MODULE$.Right().apply((Object)len);
                }
                finally {
                    if (!success) {
                        logger.foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                            x$14.gettingLengthResult(url, (Option<Object>)None$.MODULE$);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                left2 = right;
            } else {
                left2 = scala.package$.MODULE$.Left().apply((Object)new FileError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString()));
            }
            left = left2;
        }
        finally {
            if (conn != null) {
                this.closeConn(conn);
            }
        }
        return left;
    }

    private <F> F download(Artifact artifact, File cache, Set<String> checksums, CachePolicy cachePolicy, ExecutorService pool, Option<Cache.Logger> logger, Option<Duration> ttl, boolean localArtifactsShouldBeCached, Schedulable<F> S) {
        EitherT eitherT;
        Option referenceFileOpt = artifact.extra().get((Object)"metadata").map((Function1 & Serializable & scala.Serializable)a -> MODULE$.localFile(a.url(), cache, (Option<String>)a.authentication().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.user()), localArtifactsShouldBeCached));
        String string = artifact.url();
        Seq urls = (Seq)((SeqLike)checksums.toSeq().flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(artifact.checksumUrls().get(key)), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        CachePolicy cachePolicy2 = cachePolicy;
        CachePolicy cachePolicy3 = CachePolicy$UpdateChanging$.MODULE$.equals(cachePolicy2) && !artifact.changing() ? CachePolicy$FetchMissing$.MODULE$ : (CachePolicy$LocalUpdateChanging$.MODULE$.equals(cachePolicy2) && !artifact.changing() ? CachePolicy$LocalOnly$.MODULE$ : cachePolicy2);
        CachePolicy$FetchMissing$ cachePolicy0 = cachePolicy3;
        Option option = artifact.extra().get((Object)"required");
        if (None$.MODULE$.equals(option)) {
            eitherT = new EitherT(S.point(scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)));
        } else if (option instanceof Some) {
            EitherT eitherT2;
            Some some = (Some)option;
            Artifact required = (Artifact)some.value();
            CachePolicy$FetchMissing$ cachePolicy$FetchMissing$ = cachePolicy0;
            boolean bl = CachePolicy$LocalOnly$.MODULE$.equals(cachePolicy$FetchMissing$) ? true : (CachePolicy$LocalUpdateChanging$.MODULE$.equals(cachePolicy$FetchMissing$) ? true : CachePolicy$LocalUpdate$.MODULE$.equals(cachePolicy$FetchMissing$));
            if (bl) {
                File file = this.localFile(required.url(), cache, (Option<String>)artifact.authentication().map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.user()), localArtifactsShouldBeCached);
                eitherT2 = Cache$.localInfo$1(file, required.url(), pool, S, referenceFileOpt).flatMap((Function1 & Serializable & scala.Serializable)x0$6 -> Cache$.$anonfun$download$62(S, file, BoxesRunTime.unboxToBoolean((Object)x0$6)), S);
            } else {
                eitherT2 = new EitherT(S.point(scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)));
            }
            eitherT = eitherT2;
        } else {
            throw new MatchError((Object)option);
        }
        EitherT requiredArtifactCheck = eitherT;
        Seq tasks = (Seq)urls.map((Function1 & Serializable & scala.Serializable)url -> {
            File file = MODULE$.localFile((String)url, cache, (Option<String>)artifact.authentication().map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.user()), localArtifactsShouldBeCached);
            return S.map(requiredArtifactCheck.flatMap((Function1 & Serializable & scala.Serializable)x$36 -> Cache$.res$4(artifact, cache, cachePolicy, pool, logger, ttl, localArtifactsShouldBeCached, S, referenceFileOpt, cachePolicy0, file, url), S).run(), (Function1 & Serializable & scala.Serializable)x$37 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)file, url)), x$37));
        }, Seq$.MODULE$.canBuildFrom());
        return S.gather(tasks);
    }

    private <T> int downloading$default$4() {
        return this.retryCount();
    }

    public Option<BigInteger> parseChecksum(String content) {
        Vector lines = new StringOps(Predef$.MODULE$.augmentString(content)).lines().toVector();
        return this.parseChecksumLine((Seq<String>)lines).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.parseChecksumAlternative((Seq<String>)lines));
    }

    public Option<BigInteger> parseRawChecksum(byte[] content) {
        Some some;
        if (content.length == 16 || content.length == 20) {
            some = new Some((Object)new BigInteger(content));
        } else {
            String s = new String(content, StandardCharsets.UTF_8);
            Vector lines = new StringOps(Predef$.MODULE$.augmentString(s)).lines().toVector();
            some = this.parseChecksumLine((Seq<String>)lines).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.parseChecksumAlternative((Seq<String>)lines));
        }
        return some;
    }

    public java.util.regex.Pattern coursier$Cache$$checksumPattern() {
        return this.coursier$Cache$$checksumPattern;
    }

    private Option<BigInteger> findChecksum(Seq<String> elems) {
        return elems.collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = Cache$.MODULE$.coursier$Cache$$checksumPattern().matcher(A1).matches() ? new BigInteger(A1, 16) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x2) {
                String string = x2;
                boolean bl = Cache$.MODULE$.coursier$Cache$$checksumPattern().matcher(string).matches();
                return bl;
            }
        });
    }

    private Option<BigInteger> parseChecksumLine(Seq<String> lines) {
        return this.findChecksum((Seq<String>)((Seq)lines.map((Function1 & Serializable & scala.Serializable)x$38 -> x$38.toLowerCase().replaceAll("\\s", ""), Seq$.MODULE$.canBuildFrom())));
    }

    private Option<BigInteger> parseChecksumAlternative(Seq<String> lines) {
        return this.findChecksum((Seq<String>)((Seq)lines.flatMap((Function1 & Serializable & scala.Serializable)x$39 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$39.toLowerCase().split("\\s+"))), Seq$.MODULE$.canBuildFrom()))).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.findChecksum((Seq<String>)((Seq)lines.map((Function1 & Serializable & scala.Serializable)x$40 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$40.toLowerCase().split("\\s+"))).filter((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)x$41.matches("[0-9a-f]+"))))).mkString(), Seq$.MODULE$.canBuildFrom()))));
    }

    public <F> EitherT<F, FileError, BoxedUnit> validateChecksum(Artifact artifact, String sumType, File cache, ExecutorService pool, boolean localArtifactsShouldBeCached, Schedulable<F> S) {
        Object f;
        File localFile0 = this.localFile(artifact.url(), cache, (Option<String>)artifact.authentication().map((Function1 & Serializable & scala.Serializable)x$42 -> x$42.user()), localArtifactsShouldBeCached);
        Option option = artifact.checksumUrls().get((Object)sumType);
        if (option instanceof Some) {
            Some some = (Some)option;
            String sumUrl = (String)some.value();
            File sumFile = this.localFile(sumUrl, cache, (Option<String>)artifact.authentication().map((Function1 & Serializable & scala.Serializable)x$43 -> x$43.user()), localArtifactsShouldBeCached);
            f = S.schedule(pool, (Function0 & Serializable & scala.Serializable)() -> {
                Left left;
                Option<BigInteger> sumOpt = MODULE$.parseRawChecksum(Files.readAllBytes(sumFile.toPath()));
                Option<BigInteger> option = sumOpt;
                if (None$.MODULE$.equals(option)) {
                    left = scala.package$.MODULE$.Left().apply((Object)new FileError.ChecksumFormatError(sumType, sumFile.getPath()));
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    BigInteger sum = (BigInteger)some.value();
                    MessageDigest md = MessageDigest.getInstance(sumType);
                    try (FileInputStream is = new FileInputStream(localFile0);){
                        MODULE$.withContent(is, (Function2<byte[], Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$44, x$45) -> {
                            md.update(x$44, 0, BoxesRunTime.unboxToInt((Object)x$45));
                            return BoxedUnit.UNIT;
                        });
                    }
                    byte[] digest = md.digest();
                    BigInteger calculatedSum = new BigInteger(1, digest);
                    left = BoxesRunTime.equalsNumNum((Number)sum, (Number)calculatedSum) ? scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : scala.package$.MODULE$.Left().apply((Object)new FileError.WrongChecksum(sumType, calculatedSum.toString(16), sum.toString(16), localFile0.getPath(), sumFile.getPath()));
                } else {
                    throw new MatchError(option);
                }
                return left;
            });
        } else if (None$.MODULE$.equals(option)) {
            f = S.point(scala.package$.MODULE$.Left().apply((Object)new FileError.ChecksumNotFound(sumType, localFile0.getPath())));
        } else {
            throw new MatchError((Object)option);
        }
        return new EitherT(f);
    }

    public <F> boolean validateChecksum$default$5() {
        return false;
    }

    public <F> EitherT<F, FileError, File> file(Artifact artifact, File cache, CachePolicy cachePolicy, Seq<Option<String>> checksums, Option<Cache.Logger> logger, ExecutorService pool, Option<Duration> ttl, int retry, boolean localArtifactsShouldBeCached, Schedulable<F> S) {
        Seq checksums0 = checksums.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new None$[]{None$.MODULE$})) : checksums;
        EitherT res = new EitherT(S.map(this.download(artifact, cache, (Set<String>)((TraversableOnce)checksums0.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<String>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    String c = (String)some.value();
                    object = c;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<String> x3) {
                Option<String> option = x3;
                boolean bl = option instanceof Some;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), cachePolicy, pool, logger, ttl, localArtifactsShouldBeCached, S), (Function1 & Serializable & scala.Serializable)results -> {
            Either res;
            Tuple2 tuple2;
            Option checksum;
            block3: {
                Tuple2 tuple22;
                block2: {
                    checksum = checksums0.find((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)Cache$.$anonfun$file$2(artifact, results, x0$8)));
                    tuple22 = (Tuple2)results.head();
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    res = (Either)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            File f = (File)tuple2._1();
            Tuple2 tuple23 = new Tuple2((Object)f, (Object)res);
            Tuple2 tuple24 = tuple23;
            File f2 = (File)tuple24._1();
            Either res2 = (Either)tuple24._2();
            return res2.right().flatMap((Function1 & Serializable & scala.Serializable)x$47 -> {
                Left left;
                Option option = checksum;
                if (None$.MODULE$.equals(option)) {
                    left = scala.package$.MODULE$.Left().apply((Object)new FileError.ChecksumNotFound((String)((Option)checksums0.last()).get(), ""));
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    Option c = (Option)some.value();
                    left = scala.package$.MODULE$.Right().apply((Object)new Tuple2((Object)f2, (Object)c));
                } else {
                    throw new MatchError((Object)option);
                }
                return left;
            });
        }));
        return res.flatMap((Function1 & Serializable & scala.Serializable)x0$10 -> {
            void var6_11;
            Tuple2 tuple2 = x0$10;
            if (tuple2 != null) {
                File f = (File)tuple2._1();
                Option option = (Option)tuple2._2();
                if (None$.MODULE$.equals(option)) {
                    EitherT eitherT = new EitherT(S.point(scala.package$.MODULE$.Right().apply((Object)f)));
                    return var6_11;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            File f = (File)tuple2._1();
            Option option = (Option)tuple2._2();
            if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
            Some some = (Some)option;
            String c = (String)some.value();
            EitherT eitherT = MODULE$.validateChecksum(artifact, c, cache, pool, localArtifactsShouldBeCached, S).map((Function1 & Serializable & scala.Serializable)x$48 -> f, S);
            return var6_11;
        }, S).leftFlatMap((Function1 & Serializable & scala.Serializable)x0$11 -> {
            EitherT eitherT;
            FileError fileError = x0$11;
            if (fileError instanceof FileError.WrongChecksum) {
                FileError.WrongChecksum wrongChecksum = (FileError.WrongChecksum)fileError;
                eitherT = retry <= 0 ? new EitherT(S.point(scala.package$.MODULE$.Left().apply((Object)wrongChecksum))) : new EitherT(S.schedule(pool, (Function0 & Serializable & scala.Serializable)() -> {
                    File badFile = MODULE$.localFile(artifact.url(), cache, (Option<String>)artifact.authentication().map((Function1 & Serializable & scala.Serializable)x$49 -> x$49.user()), localArtifactsShouldBeCached);
                    badFile.delete();
                    logger.foreach((Function1 & Serializable & scala.Serializable)x$50 -> {
                        x$50.removedCorruptFile(artifact.url(), badFile, (Option<FileError>)new Some((Object)wrongChecksum));
                        return BoxedUnit.UNIT;
                    });
                    return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                })).flatMap((Function1 & Serializable & scala.Serializable)x$51 -> MODULE$.file(artifact, cache, cachePolicy, (Seq<Option<String>>)checksums, logger, pool, ttl, retry - 1, MODULE$.file$default$9(), S), S);
            } else {
                eitherT = new EitherT(S.point(scala.package$.MODULE$.Left().apply((Object)fileError)));
            }
            return eitherT;
        }, S);
    }

    public <F> File file$default$2() {
        return this.default();
    }

    public <F> CachePolicy file$default$3() {
        return CachePolicy$UpdateChanging$.MODULE$;
    }

    public <F> Seq<Option<String>> file$default$4() {
        return this.defaultChecksums();
    }

    public <F> Option<Cache.Logger> file$default$5() {
        return None$.MODULE$;
    }

    public <F> ExecutorService file$default$6() {
        return this.defaultPool();
    }

    public <F> Option<Duration> file$default$7() {
        return this.defaultTtl();
    }

    public <F> int file$default$8() {
        return 1;
    }

    public <F> boolean file$default$9() {
        return false;
    }

    public <F> Function1<Artifact, EitherT<F, String, String>> fetch(File cache, CachePolicy cachePolicy, Seq<Option<String>> checksums, Option<Cache.Logger> logger, ExecutorService pool, Option<Duration> ttl, Schedulable<F> S) {
        return (Function1 & Serializable & scala.Serializable)artifact -> MODULE$.file((Artifact)artifact, cache, cachePolicy, checksums, logger, pool, ttl, MODULE$.file$default$8(), MODULE$.file$default$9(), S).leftMap((Function1 & Serializable & scala.Serializable)x$52 -> x$52.describe(), S).flatMap((Function1 & Serializable & scala.Serializable)f -> {
            Object object;
            if (f.exists()) {
                if (f.isDirectory()) {
                    if (artifact.url().startsWith("file:")) {
                        String elements = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.listFiles())).map((Function1 & Serializable & scala.Serializable)c -> {
                            String name = c.getName();
                            String name0 = c.isDirectory() ? new StringBuilder(1).append(name).append("/").toString() : name;
                            return new StringBuilder(24).append("<li><a href=\"").append(name0).append("\">").append(name0).append("</a></li>").toString();
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
                        String page = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(249).append("<!DOCTYPE html>\n                   |<html>\n                   |<head></head>\n                   |<body>\n                   |<ul>\n                   |").append(elements).append("\n                   |</ul>\n                   |</body>\n                   |</html>\n                 ").toString())).stripMargin();
                        object = scala.package$.MODULE$.Right().apply((Object)page);
                    } else {
                        File f0 = new File((File)f, ".directory");
                        object = f0.exists() ? (f0.isDirectory() ? scala.package$.MODULE$.Left().apply((Object)new StringBuilder(22).append("Woops: ").append(f.getCanonicalPath()).append(" is a directory").toString()) : Cache$.read$2(f0)) : Cache$.notFound$1(f0);
                    }
                } else {
                    object = Cache$.read$2(f);
                }
            } else {
                object = Cache$.notFound$1(f);
            }
            Left res = object;
            return new EitherT(S.point(res));
        }, S);
    }

    public <F> File fetch$default$1() {
        return this.default();
    }

    public <F> CachePolicy fetch$default$2() {
        return CachePolicy$UpdateChanging$.MODULE$;
    }

    public <F> Seq<Option<String>> fetch$default$3() {
        return this.defaultChecksums();
    }

    public <F> Option<Cache.Logger> fetch$default$4() {
        return None$.MODULE$;
    }

    public <F> ExecutorService fetch$default$5() {
        return this.defaultPool();
    }

    public <F> Option<Duration> fetch$default$6() {
        return this.defaultTtl();
    }

    private String ivy2HomeUri$lzycompute() {
        Cache$ cache$ = this;
        synchronized (cache$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String path = (String)scala.sys.package$.MODULE$.props().get("com.geirsson.shaded.coursier.ivy.home").orElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.props().get("ivy.home")).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append((String)scala.sys.package$.MODULE$.props().apply((Object)"user.home")).append("/.ivy2/").toString());
                String str = new File(path).toURI().toString();
                this.ivy2HomeUri = str.endsWith("/") ? str : new StringBuilder(1).append(str).append("/").toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.ivy2HomeUri;
    }

    private String ivy2HomeUri() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.ivy2HomeUri$lzycompute() : this.ivy2HomeUri;
    }

    private IvyRepository ivy2Local$lzycompute() {
        Cache$ cache$ = this;
        synchronized (cache$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                String string = new StringBuilder(6).append(this.ivy2HomeUri()).append("local/").toString();
                Pattern x$54 = Pattern$.MODULE$.default().$plus$colon(Pattern$Chunk$.MODULE$.fromString(string));
                boolean x$55 = true;
                Option<Pattern> x$56 = IvyRepository$.MODULE$.fromPattern$default$2();
                Option<Object> x$57 = IvyRepository$.MODULE$.fromPattern$default$3();
                boolean x$58 = IvyRepository$.MODULE$.fromPattern$default$4();
                boolean x$59 = IvyRepository$.MODULE$.fromPattern$default$5();
                boolean x$60 = IvyRepository$.MODULE$.fromPattern$default$6();
                Option<Authentication> x$61 = IvyRepository$.MODULE$.fromPattern$default$8();
                this.ivy2Local = IvyRepository$.MODULE$.fromPattern(x$54, x$56, x$57, x$58, x$59, x$60, x$55, x$61);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.ivy2Local;
    }

    public IvyRepository ivy2Local() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.ivy2Local$lzycompute() : this.ivy2Local;
    }

    private IvyRepository ivy2Cache$lzycompute() {
        Cache$ cache$ = this;
        synchronized (cache$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                String x$62 = new StringBuilder(122).append(this.ivy2HomeUri()).append("cache/").append("(scala_[scalaVersion]/)(sbt_[sbtVersion]/)[organisation]/[module]/[type]s/[artifact]-[revision](-[classifier]).[ext]").toString();
                Some x$63 = new Some((Object)new StringBuilder(110).append(this.ivy2HomeUri()).append("cache/").append("(scala_[scalaVersion]/)(sbt_[sbtVersion]/)[organisation]/[module]/[type]-[revision](-[classifier]).[ext]").toString());
                boolean x$64 = false;
                boolean x$65 = false;
                boolean x$66 = true;
                Option<Object> x$67 = IvyRepository$.MODULE$.parse$default$3();
                Map<String, String> x$68 = IvyRepository$.MODULE$.parse$default$4();
                boolean x$69 = IvyRepository$.MODULE$.parse$default$7();
                Option<Authentication> x$70 = IvyRepository$.MODULE$.parse$default$9();
                this.ivy2Cache = (IvyRepository)IvyRepository$.MODULE$.parse(x$62, (Option<String>)x$63, x$67, x$68, x$64, x$65, x$69, x$66, x$70).right().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new Exception("Cannot happen");
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.ivy2Cache;
    }

    public IvyRepository ivy2Cache() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.ivy2Cache$lzycompute() : this.ivy2Cache;
    }

    private File default$lzycompute() {
        Cache$ cache$ = this;
        synchronized (cache$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.default = CachePath.defaultCacheDirectory();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.default;
    }

    public File default() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.default$lzycompute() : this.default;
    }

    public int defaultConcurrentDownloadCount() {
        return this.defaultConcurrentDownloadCount;
    }

    private ExecutorService defaultPool$lzycompute() {
        Cache$ cache$ = this;
        synchronized (cache$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.defaultPool = Schedulable$.MODULE$.fixedThreadPool(this.defaultConcurrentDownloadCount());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.defaultPool;
    }

    public ExecutorService defaultPool() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.defaultPool$lzycompute() : this.defaultPool;
    }

    private Option<Duration> defaultTtl$lzycompute() {
        Cache$ cache$ = this;
        synchronized (cache$) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                Option fromEnv = scala.sys.package$.MODULE$.env().get((Object)"COURSIER_TTL").flatMap((Function1 & Serializable & scala.Serializable)s -> Cache$.fromString$1(s));
                this.defaultTtl = fromEnv.orElse((Function0 & Serializable & scala.Serializable)() -> Cache$.fromProps$1()).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)Cache$.default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.defaultTtl;
    }

    public Option<Duration> defaultTtl() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.defaultTtl$lzycompute() : this.defaultTtl;
    }

    private ConcurrentHashMap<String, Object> urlLocks() {
        return this.urlLocks;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public void bufferSize_$eq(int x$1) {
        this.bufferSize = x$1;
    }

    public void withContent(InputStream is, Function2<byte[], Object, BoxedUnit> f) {
        byte[] data = (byte[])Array$.MODULE$.ofDim(16384, ClassTag$.MODULE$.Byte());
        int nRead = is.read(data, 0, data.length);
        while (nRead != -1) {
            f.apply((Object)data, (Object)BoxesRunTime.boxToInteger((int)nRead));
            nRead = is.read(data, 0, data.length);
        }
    }

    public static final /* synthetic */ boolean $anonfun$closeConn$2(InputStream x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeConn$5(InputStream x$3) {
        return x$3 != null;
    }

    private final void helper$1(long count, InputStream in$1, OutputStream out$1, Option logger$1, String url$1, byte[] b$1) {
        int read;
        while ((read = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read);
            out$1.flush();
            logger$1.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.downloadProgress(url$1, count + (long)read);
                return BoxedUnit.UNIT;
            });
            count += (long)read;
        }
    }

    private final Either loop$1(Function0 f$2, Function0 ifLocked$1, File lockFile$1, ObjectRef out$2) {
        Either res;
        Option option;
        block12: {
            do {
                Option resOpt;
                Option option2;
                block11: {
                    FileLock lock = null;
                    try {
                        try {
                            lock = ((FileOutputStream)out$2.elem).getChannel().tryLock();
                            if (lock == null) {
                                option2 = (Option)ifLocked$1.apply();
                                break block11;
                            }
                            try {
                                option2 = new Some(f$2.apply());
                            }
                            finally {
                                lock.release();
                                lock = null;
                                ((FileOutputStream)out$2.elem).close();
                                out$2.elem = null;
                                lockFile$1.delete();
                            }
                        }
                        catch (OverlappingFileLockException overlappingFileLockException) {
                            option2 = (Option)ifLocked$1.apply();
                        }
                    }
                    finally {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                }
                option = resOpt = option2;
                if (option instanceof Some) break block12;
            } while (None$.MODULE$.equals(option));
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Either either = res = (Either)some.value();
        return either;
    }

    private final Either liftedTree1$1(String url$2, Function0 f$3) {
        Either either;
        try {
            try {
                either = (Either)f$3.apply();
            }
            catch (Throwable throwable) {
                FileNotFoundException fileNotFoundException;
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof FileNotFoundException) || (fileNotFoundException = (FileNotFoundException)throwable2).getMessage() == null) {
                    throw throwable;
                }
                Left left = scala.package$.MODULE$.Left().apply((Object)new FileError.NotFound(fileNotFoundException.getMessage(), FileError$NotFound$.MODULE$.apply$default$2()));
                either = left;
            }
        }
        finally {
            this.urlLocks().remove(url$2);
        }
        return either;
    }

    private final Either helper$2(int retry, String url$2, Function0 f$3) {
        Either res;
        None$ none$;
        block7: {
            while (true) {
                None$ resOpt;
                None$ none$2;
                try {
                    Object o = new Object();
                    Object prev = this.urlLocks().putIfAbsent(url$2, o);
                    Either res2 = prev == null ? this.liftedTree1$1(url$2, f$3) : scala.package$.MODULE$.Left().apply((Object)new FileError.ConcurrentDownload(url$2));
                    none$2 = new Some((Object)res2);
                }
                catch (Throwable throwable) {
                    None$ none$3;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SSLException && retry >= 1) {
                        none$3 = None$.MODULE$;
                    } else {
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            none$3 = new Some((Object)scala.package$.MODULE$.Left().apply((Object)new FileError.DownloadError(new StringBuilder(26).append("Caught ").append(e).append(Option$.MODULE$.apply((Object)e.getMessage()).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$7 -> new StringBuilder(3).append(" (").append((String)x$7).append(")").toString())).append(" while downloading ").append(url$2).toString())));
                        } else {
                            throw throwable;
                        }
                    }
                    none$2 = none$3;
                }
                none$ = resOpt = none$2;
                if (none$ instanceof Some) break block7;
                if (!None$.MODULE$.equals(none$)) break;
                --retry;
            }
            throw new MatchError((Object)none$);
        }
        Some some = (Some)none$;
        Either either = res = (Either)some.value();
        return either;
    }

    public static final /* synthetic */ boolean $anonfun$handlerFor$1(char x$8) {
        return x$8 != ':';
    }

    private static final Option clsOpt$1(ClassLoader loader, String clsName$1) {
        Some some;
        try {
            some = new Some(loader.loadClass(clsName$1));
        }
        catch (ClassNotFoundException classNotFoundException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private static final void printError$1(Exception e, String clsName$1) {
        Console$.MODULE$.err().println(new StringBuilder(21).append("Cannot instantiate ").append(clsName$1).append(": ").append(e).append(Option$.MODULE$.apply((Object)e.getMessage()).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$9 -> new StringBuilder(3).append(" (").append((String)x$9).append(")").toString())).toString());
    }

    public static final /* synthetic */ void $anonfun$urlConnection$1(ObjectRef conn$2, Authentication auth) {
        URLConnection uRLConnection = (URLConnection)conn$2.elem;
        if (uRLConnection instanceof AuthenticatedURLConnection) {
            AuthenticatedURLConnection authenticatedURLConnection = (AuthenticatedURLConnection)((Object)uRLConnection);
            authenticatedURLConnection.authenticate(auth);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestProperty("Authorization", new StringBuilder(6).append("Basic ").append(MODULE$.basicAuthenticationEncode(auth.user(), auth.password())).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final boolean referenceFileExists$1(Option referenceFileOpt$1) {
        return referenceFileOpt$1.exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.exists()));
    }

    private static final EitherT fileLastModified$1(File file, ExecutorService pool$1, Schedulable S$1) {
        return new EitherT(S$1.schedule(pool$1, (Function0 & Serializable & scala.Serializable)() -> {
            long lastModified;
            return scala.package$.MODULE$.Right().apply((lastModified = file.lastModified()) > 0L ? new Some((Object)BoxesRunTime.boxToLong((long)lastModified)) : None$.MODULE$);
        }));
    }

    private static final EitherT urlLastModified$1(String url, Option currentLastModifiedOpt, Option logger, Artifact artifact$1, ExecutorService pool$1, Schedulable S$1) {
        return new EitherT(S$1.schedule(pool$1, (Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            URLConnection conn = null;
            try {
                Left left2;
                URLConnection uRLConnection = conn = MODULE$.urlConnection(url, artifact$1.authentication());
                if (uRLConnection instanceof HttpURLConnection) {
                    Right right;
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    logger.foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
                        x$17.checkingUpdates(url, (Option<Object>)currentLastModifiedOpt);
                        return BoxedUnit.UNIT;
                    });
                    boolean success = false;
                    try {
                        httpURLConnection.setRequestMethod("HEAD");
                        long remoteLastModified = httpURLConnection.getLastModified();
                        None$ res = remoteLastModified > 0L ? new Some((Object)BoxesRunTime.boxToLong((long)remoteLastModified)) : None$.MODULE$;
                        success = true;
                        logger.foreach(arg_0 -> Cache$.$anonfun$download$7$adapted(url, currentLastModifiedOpt, (Option)res, arg_0));
                        right = scala.package$.MODULE$.Right().apply((Object)res);
                    }
                    finally {
                        if (!success) {
                            logger.foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
                                x$19.checkingUpdatesResult(url, (Option<Object>)currentLastModifiedOpt, (Option<Object>)None$.MODULE$);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }
                    left2 = right;
                } else {
                    left2 = scala.package$.MODULE$.Left().apply((Object)new FileError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString()));
                }
                left = left2;
            }
            finally {
                if (conn != null) {
                    MODULE$.closeConn(conn);
                }
            }
            return left;
        }));
    }

    private static final Object fileExists$1(File file, ExecutorService pool$1, Schedulable S$1) {
        return S$1.schedule(pool$1, (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> file.exists());
    }

    private static final File ttlFile$1(File file) {
        return new File(file.getParent(), new StringBuilder(9).append(".").append(file.getName()).append(".checked").toString());
    }

    private static final Object lastCheck$1(File file, ExecutorService pool$1, Schedulable S$1) {
        File ttlFile0 = Cache$.ttlFile$1(file);
        return S$1.schedule(pool$1, (Function0 & Serializable & scala.Serializable)() -> ttlFile0.exists() ? new Some((Object)BoxesRunTime.boxToLong((long)ttlFile0.lastModified())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$20 -> x$20 > 0L) : None$.MODULE$);
    }

    private static final void doTouchCheckFile$1(File file) {
        long ts = System.currentTimeMillis();
        File f = Cache$.ttlFile$1(file);
        if (f.exists()) {
            f.setLastModified(ts);
        } else {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            fos.close();
        }
    }

    private static final Object checkNeeded$1(ExecutorService pool$1, Option ttl$1, Schedulable S$1, File file$4) {
        return ttl$1.fold((Function0 & Serializable & scala.Serializable)() -> S$1.point(BoxesRunTime.boxToBoolean((boolean)true)), (Function1 & Serializable & scala.Serializable)ttl -> ttl.isFinite() ? S$1.bind(Cache$.lastCheck$1(file$4, pool$1, S$1), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object f;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                f = S$1.point(BoxesRunTime.boxToBoolean((boolean)true));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                long ts = BoxesRunTime.unboxToLong((Object)some.value());
                f = S$1.map(S$1.schedule(pool$1, (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.currentTimeMillis()), (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$21 -> x$21 > ts + ttl.toMillis());
            } else {
                throw new MatchError((Object)option);
            }
            return f;
        }) : S$1.point(BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public static final /* synthetic */ boolean $anonfun$download$18(Option fileLastModOpt$1, Option urlLastModOpt) {
        Option fromDatesOpt = fileLastModOpt$1.flatMap((Function1 & Serializable & scala.Serializable)fileLastMod -> urlLastModOpt.map((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)urlLastMod -> fileLastMod < urlLastMod));
        return BoxesRunTime.unboxToBoolean((Object)fromDatesOpt.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    private static final EitherT check$1(Artifact artifact$1, ExecutorService pool$1, Option logger$2, Schedulable S$1, File file$4, String url$5) {
        return Cache$.fileLastModified$1(file$4, pool$1, S$1).flatMap((Function1 & Serializable & scala.Serializable)fileLastModOpt -> Cache$.urlLastModified$1(url$5, fileLastModOpt, logger$2, artifact$1, pool$1, S$1).map((Function1 & Serializable & scala.Serializable)urlLastModOpt -> BoxesRunTime.boxToBoolean((boolean)Cache$.$anonfun$download$18(fileLastModOpt, urlLastModOpt)), S$1), S$1);
    }

    public static final /* synthetic */ Object $anonfun$download$23(Artifact artifact$1, ExecutorService pool$1, Option logger$2, Schedulable S$1, File file$4, String url$5, boolean x0$3) {
        Object f;
        boolean bl = x0$3;
        if (!bl) {
            f = S$1.point(scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        } else if (bl) {
            f = S$1.bind(Cache$.check$1(artifact$1, pool$1, logger$2, S$1, file$4, url$5).run(), (Function1 & Serializable & scala.Serializable)x0$4 -> {
                Right right;
                boolean bl;
                Either either = x0$4;
                Object f = either instanceof Right && !(bl = BoxesRunTime.unboxToBoolean((Object)(right = (Right)either).value())) ? S$1.schedule(pool$1, (Function0 & Serializable & scala.Serializable)() -> {
                    Cache$.doTouchCheckFile$1(file$4);
                    return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                }) : S$1.point(either);
                return f;
            });
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return f;
    }

    public static final /* synthetic */ Object $anonfun$download$22(Artifact artifact$1, ExecutorService pool$1, Option logger$2, Option ttl$1, Schedulable S$1, File file$4, String url$5, boolean x0$2) {
        Object object;
        boolean bl = x0$2;
        if (!bl) {
            object = S$1.point(scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        } else if (bl) {
            object = S$1.bind(Cache$.checkNeeded$1(pool$1, ttl$1, S$1, file$4), (Function1 & Serializable & scala.Serializable)x0$3 -> Cache$.$anonfun$download$23(artifact$1, pool$1, logger$2, S$1, file$4, url$5, BoxesRunTime.unboxToBoolean((Object)x0$3)));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return object;
    }

    private static final EitherT shouldDownload$1(File file, String url, Artifact artifact$1, ExecutorService pool$1, Option logger$2, Option ttl$1, Schedulable S$1) {
        return new EitherT(S$1.bind(Cache$.fileExists$1(file, pool$1, S$1), (Function1 & Serializable & scala.Serializable)x0$2 -> Cache$.$anonfun$download$22(artifact$1, pool$1, logger$2, ttl$1, S$1, file, url, BoxesRunTime.unboxToBoolean((Object)x0$2))));
    }

    private static final Option responseCode$1(URLConnection conn) {
        None$ none$;
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)httpURLConnection.getResponseCode()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private static final Option realm$1(URLConnection conn) {
        None$ none$;
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            none$ = Option$.MODULE$.apply((Object)httpURLConnection.getHeaderField("WWW-Authenticate")).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    Option option = Cache$.MODULE$.coursier$Cache$$BasicRealm().unapplySeq(A1);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String realm2 = (String)((LinearSeqOptimized)option.get()).apply(0);
                        object = realm2;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(String x1) {
                    String string = x1;
                    Option option = Cache$.MODULE$.coursier$Cache$$BasicRealm().unapplySeq((CharSequence)string);
                    boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0;
                    return bl;
                }
            });
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ String $anonfun$download$28() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$download$29(long len0) {
        return len0 >= 0L;
    }

    public static final /* synthetic */ void $anonfun$download$30(Option logger$2, String url$6, long alreadyDownloaded$1, boolean partialDownload$1, long len0) {
        long len = len0 + (partialDownload$1 ? alreadyDownloaded$1 : 0L);
        logger$2.foreach((Function1 & Serializable & scala.Serializable)x$22 -> {
            x$22.downloadLength(url$6, len, alreadyDownloaded$1, false);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ FileOutputStream $anonfun$download$32(File tmp$1, boolean partialDownload$1) {
        tmp$1.getParentFile().mkdirs();
        return new FileOutputStream(tmp$1, partialDownload$1);
    }

    public static final /* synthetic */ Path $anonfun$download$33(File file$5, File tmp$1) {
        file$5.getParentFile().mkdirs();
        return Files.move(tmp$1.toPath(), file$5.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    public static final /* synthetic */ boolean $anonfun$download$34(long lastModified) {
        return lastModified > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$download$35(File file$5, long lastModified) {
        return file$5.setLastModified(lastModified);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Either $anonfun$download$27(Artifact artifact$1, File cache$1, Option logger$2, File file$5, String url$6, File tmp$1) {
        block16: {
            alreadyDownloaded = tmp$1.length();
            conn = null;
            try {
                block19: {
                    block18: {
                        var11_8 = conn = Cache$.MODULE$.urlConnection(url$6, artifact$1.authentication());
                        if (!(var11_8 instanceof HttpURLConnection)) break block18;
                        var12_9 = (HttpURLConnection)var11_8;
                        if (alreadyDownloaded <= 0L) break block18;
                        var12_9.setRequestProperty("Range", new StringBuilder(7).append("bytes=").append(alreadyDownloaded).append("-").toString());
                        if (var12_9.getResponseCode() != Cache$.MODULE$.partialContentResponseCode() && var12_9.getResponseCode() != Cache$.MODULE$.invalidPartialContentResponseCode()) ** GOTO lbl-1000
                        ackRange = (String)Option$.MODULE$.apply((Object)var12_9.getHeaderField("Content-Range")).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$download$28(), ()Ljava/lang/String;)());
                        if (ackRange.startsWith(new StringBuilder(7).append("bytes ").append(alreadyDownloaded).append("-").toString())) ** GOTO lbl-1000
                        Cache$.MODULE$.closeConn(conn);
                        conn = Cache$.MODULE$.urlConnection(url$6, artifact$1.authentication());
                        if (false) lbl-1000:
                        // 2 sources

                        {
                            v0 = true;
                        } else {
                            v0 = false;
                        }
                        if (v0) {
                            v1 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = false;
                        }
                        var6_11 = v1;
                        break block19;
                    }
                    var6_11 = false;
                }
                partialDownload = var6_11;
                v2 = Cache$.responseCode$1(conn);
                var14_13 = new Some((Object)BoxesRunTime.boxToInteger((int)404));
                if (!(v2 != null ? v2.equals(var14_13) == false : var14_13 != null)) {
                    v3 = scala.package$.MODULE$.Left().apply((Object)new FileError.NotFound(url$6, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))));
                    break block16;
                }
                v4 = Cache$.responseCode$1(conn);
                var15_14 = new Some((Object)BoxesRunTime.boxToInteger((int)401));
                if (!(v4 != null ? v4.equals(var15_14) == false : var15_14 != null)) {
                    v3 = scala.package$.MODULE$.Left().apply((Object)new FileError.Unauthorized(url$6, (Option<String>)Cache$.realm$1(conn)));
                    break block16;
                }
                Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)conn.getContentLengthLong())).withFilter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)Z, $anonfun$download$29(long ), (J)Z)()).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)V, $anonfun$download$30(scala.Option java.lang.String long boolean long ), (J)V)((Option)logger$2, (String)url$6, (long)alreadyDownloaded, (boolean)partialDownload));
                in = new BufferedInputStream(conn.getInputStream(), Cache$.MODULE$.bufferSize());
                try {
                    out = (FileOutputStream)Cache$.MODULE$.withStructureLock(cache$1, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$download$32(java.io.File boolean ), ()Ljava/io/FileOutputStream;)((File)tmp$1, (boolean)partialDownload));
                    try {
                        Cache$.MODULE$.readFullyTo(in, out, (Option<Cache.Logger>)logger$2, url$6, partialDownload != false ? alreadyDownloaded : 0L);
                        v5 = BoxedUnit.UNIT;
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    in.close();
                }
                result = v5;
                Cache$.MODULE$.withStructureLock(cache$1, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$download$33(java.io.File java.io.File ), ()Ljava/nio/file/Path;)((File)file$5, (File)tmp$1));
                Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)conn.getLastModified())).withFilter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)Z, $anonfun$download$34(long ), (J)Z)()).foreach((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)Z, $anonfun$download$35(java.io.File long ), (J)Z)((File)file$5));
                Cache$.doTouchCheckFile$1(file$5);
                v3 = scala.package$.MODULE$.Right().apply((Object)result);
            }
            finally {
                if (conn != null) {
                    Cache$.MODULE$.closeConn(conn);
                }
            }
        }
        return v3;
    }

    private static final Either doDownload$1(Artifact artifact$1, File cache$1, Option logger$2, File file$5, String url$6, File tmp$1) {
        return MODULE$.downloading(url$6, file$5, (Option<Cache.Logger>)logger$2, MODULE$.downloading$default$4(), () -> Cache$.$anonfun$download$27(artifact$1, cache$1, logger$2, file$5, url$6, tmp$1));
    }

    private static final void progress$1(long currentLen, Artifact artifact$1, Option logger$2, String url$6, ObjectRef lenOpt$1) {
        if (((Option)lenOpt$1.elem).isEmpty()) {
            lenOpt$1.elem = new Some((Object)MODULE$.contentLength(url$6, artifact$1.authentication(), (Option<Cache.Logger>)logger$2).right().toOption().flatten(Predef$.MODULE$.$conforms()));
            ((Option)lenOpt$1.elem).foreach((Function1 & Serializable & scala.Serializable)o -> {
                o.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)len -> logger$2.foreach((Function1 & Serializable & scala.Serializable)x$23 -> {
                    x$23.downloadLength(url$6, len, currentLen$1, true);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
        } else {
            logger$2.foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
                x$24.downloadProgress(url$6, currentLen);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static final void done$1(Artifact artifact$1, Option logger$2, String url$6, ObjectRef lenOpt$1) {
        if (((Option)lenOpt$1.elem).isEmpty()) {
            lenOpt$1.elem = new Some((Object)MODULE$.contentLength(url$6, artifact$1.authentication(), (Option<Cache.Logger>)logger$2).right().toOption().flatten(Predef$.MODULE$.$conforms()));
            ((Option)lenOpt$1.elem).foreach((Function1 & Serializable & scala.Serializable)o -> {
                o.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)len -> logger$2.foreach((Function1 & Serializable & scala.Serializable)x$25 -> {
                    x$25.downloadLength(url$6, len, len, true);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
        } else {
            ((Option)lenOpt$1.elem).foreach((Function1 & Serializable & scala.Serializable)o -> {
                o.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)len -> logger$2.foreach((Function1 & Serializable & scala.Serializable)x$26 -> {
                    x$26.downloadProgress(url$6, len);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
        }
    }

    private static final Option checkDownload$1(Artifact artifact$1, Option logger$2, File file$5, String url$6, File tmp$1, ObjectRef lenOpt$1) {
        Some some;
        if (file$5.exists()) {
            Cache$.done$1(artifact$1, logger$2, url$6, lenOpt$1);
            some = new Some((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        } else {
            Thread.sleep(20L);
            long currentLen = tmp$1.length();
            if (currentLen == 0L && file$5.exists()) {
                Cache$.done$1(artifact$1, logger$2, url$6, lenOpt$1);
                some = new Some((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
            } else {
                Cache$.progress$1(currentLen, artifact$1, logger$2, url$6, lenOpt$1);
                some = None$.MODULE$;
            }
        }
        return some;
    }

    private static final EitherT remote$1(File file, String url, Artifact artifact$1, File cache$1, ExecutorService pool$1, Option logger$2, Schedulable S$1) {
        return new EitherT(S$1.schedule(pool$1, (Function0 & Serializable & scala.Serializable)() -> {
            File tmp = CachePath.temporaryFile(file);
            ObjectRef lenOpt = ObjectRef.create((Object)Option$.MODULE$.empty());
            logger$2.foreach((Function1 & Serializable & scala.Serializable)x$27 -> {
                x$27.downloadingArtifact(url, file);
                return BoxedUnit.UNIT;
            });
            ObjectRef res = ObjectRef.create(null);
            try {
                res.elem = MODULE$.withLockOr(cache$1, file, (Function0 & Serializable & scala.Serializable)() -> Cache$.doDownload$1(artifact$1, cache$1, logger$2, file, url, tmp), (Function0 & Serializable & scala.Serializable)() -> Cache$.checkDownload$1(artifact$1, logger$2, file, url, tmp, lenOpt));
            }
            finally {
                logger$2.foreach((Function1 & Serializable & scala.Serializable)x$28 -> {
                    x$28.downloadedArtifact(url, (Either)res.elem != null && ((Either)res.elem).isRight());
                    return BoxedUnit.UNIT;
                });
            }
            return (Either)res.elem;
        }));
    }

    private static final File errFile$1(File file) {
        return new File(file.getParentFile(), new StringBuilder(7).append(".").append(file.getName()).append(".error").toString());
    }

    private static final EitherT validErrFileExists$1(ExecutorService pool$1, Schedulable S$1, Option referenceFileOpt$1, File errFile0$1) {
        return new EitherT(S$1.schedule(pool$1, (Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((Cache$.referenceFileExists$1(referenceFileOpt$1) && errFile0$1.exists() ? 1 : 0) != 0))));
    }

    private static final EitherT createErrFile$1(ExecutorService pool$1, Schedulable S$1, Option referenceFileOpt$1, File errFile0$1) {
        return new EitherT(S$1.schedule(pool$1, (Function0 & Serializable & scala.Serializable)() -> {
            Object object = Cache$.referenceFileExists$1(referenceFileOpt$1) ? (!errFile0$1.exists() ? Files.write(errFile0$1.toPath(), Array$.MODULE$.emptyByteArray(), new OpenOption[0]) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }));
    }

    private static final EitherT deleteErrFile$1(ExecutorService pool$1, Schedulable S$1, File errFile0$1) {
        return new EitherT(S$1.schedule(pool$1, (Function0 & Serializable & scala.Serializable)() -> {
            Object object = errFile0$1.exists() ? BoxesRunTime.boxToBoolean((boolean)errFile0$1.delete()) : BoxedUnit.UNIT;
            return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }));
    }

    private static final EitherT retainError$1(Artifact artifact$1, File cache$1, ExecutorService pool$1, Option logger$2, Schedulable S$1, Option referenceFileOpt$1, File file$6, String url$7, File errFile0$1) {
        return new EitherT(S$1.bind(Cache$.remote$1(file$6, url$7, artifact$1, cache$1, pool$1, logger$2, S$1).run(), (Function1 & Serializable & scala.Serializable)x0$5 -> {
            Some some;
            boolean bl;
            FileError.NotFound notFound;
            Option<Object> option;
            Left left;
            FileError fileError;
            Either either = x0$5;
            Object f = either instanceof Left && (fileError = (FileError)(left = (Left)either).value()) instanceof FileError.NotFound && (option = (notFound = (FileError.NotFound)fileError).permanent()) instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value())) ? S$1.map(Cache$.createErrFile$1(pool$1, S$1, referenceFileOpt$1, errFile0$1).run(), (Function1 & Serializable & scala.Serializable)x$29 -> left) : S$1.map(Cache$.deleteErrFile$1(pool$1, S$1, errFile0$1).run(), (Function1 & Serializable & scala.Serializable)x$30 -> either);
            return f;
        }));
    }

    public static final /* synthetic */ EitherT $anonfun$download$56(Artifact artifact$1, File cache$1, ExecutorService pool$1, Option logger$2, Schedulable S$1, Option referenceFileOpt$1, File file$6, String url$7, File errFile0$1, boolean exists) {
        return exists ? new EitherT(S$1.point(scala.package$.MODULE$.Left().apply((Object)new FileError.NotFound(url$7, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)))))) : Cache$.retainError$1(artifact$1, cache$1, pool$1, logger$2, S$1, referenceFileOpt$1, file$6, url$7, errFile0$1);
    }

    private static final EitherT remoteKeepErrors$1(File file, String url, Artifact artifact$1, File cache$1, CachePolicy cachePolicy$1, ExecutorService pool$1, Option logger$2, Schedulable S$1, Option referenceFileOpt$1) {
        EitherT eitherT;
        File errFile0 = Cache$.errFile$1(file);
        CachePolicy cachePolicy = cachePolicy$1;
        boolean bl = CachePolicy$FetchMissing$.MODULE$.equals(cachePolicy) ? true : (CachePolicy$LocalOnly$.MODULE$.equals(cachePolicy) ? true : (CachePolicy$LocalUpdate$.MODULE$.equals(cachePolicy) ? true : CachePolicy$LocalUpdateChanging$.MODULE$.equals(cachePolicy)));
        if (bl) {
            eitherT = Cache$.validErrFileExists$1(pool$1, S$1, referenceFileOpt$1, errFile0).flatMap((Function1 & Serializable & scala.Serializable)exists -> Cache$.$anonfun$download$56(artifact$1, cache$1, pool$1, logger$2, S$1, referenceFileOpt$1, file, url, errFile0, BoxesRunTime.unboxToBoolean((Object)exists)), S$1);
        } else {
            boolean bl2 = CachePolicy$ForceDownload$.MODULE$.equals(cachePolicy) ? true : (CachePolicy$Update$.MODULE$.equals(cachePolicy) ? true : CachePolicy$UpdateChanging$.MODULE$.equals(cachePolicy));
            if (bl2) {
                eitherT = Cache$.retainError$1(artifact$1, cache$1, pool$1, logger$2, S$1, referenceFileOpt$1, file, url, errFile0);
            } else {
                throw new MatchError((Object)cachePolicy);
            }
        }
        return eitherT;
    }

    private static final /* synthetic */ Either res$lzycompute$1(Option referenceFileOpt$1, File file$7, String url$8, File errFile0$2, LazyRef res$lzy$1) {
        Either either;
        LazyRef lazyRef = res$lzy$1;
        synchronized (lazyRef) {
            either = res$lzy$1.initialized() ? (Either)res$lzy$1.value() : (Either)res$lzy$1.initialize(file$7.exists() ? scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true)) : (Cache$.referenceFileExists$1(referenceFileOpt$1) && errFile0$2.exists() ? scala.package$.MODULE$.Left().apply((Object)new FileError.NotFound(url$8, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)))) : scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false))));
        }
        return either;
    }

    private static final Either res$3(Option referenceFileOpt$1, File file$7, String url$8, File errFile0$2, LazyRef res$lzy$1) {
        return res$lzy$1.initialized() ? (Either)res$lzy$1.value() : Cache$.res$lzycompute$1(referenceFileOpt$1, file$7, url$8, errFile0$2, res$lzy$1);
    }

    private static final EitherT localInfo$1(File file, String url, ExecutorService pool$1, Schedulable S$1, Option referenceFileOpt$1) {
        LazyRef res$lzy = new LazyRef();
        File errFile0 = Cache$.errFile$1(file);
        return new EitherT(S$1.schedule(pool$1, (Function0 & Serializable & scala.Serializable)() -> Cache$.res$3(referenceFileOpt$1, file, url, errFile0, res$lzy)));
    }

    private static final EitherT checkFileExists$1(File file, String url, boolean log, ExecutorService pool$1, Option logger$2, Schedulable S$1) {
        return new EitherT(S$1.schedule(pool$1, (Function0 & Serializable & scala.Serializable)() -> {
            Right right;
            if (file.exists()) {
                logger$2.foreach((Function1 & Serializable & scala.Serializable)x$31 -> {
                    x$31.foundLocally(url, file);
                    return BoxedUnit.UNIT;
                });
                right = scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else {
                right = scala.package$.MODULE$.Left().apply((Object)new FileError.NotFound(file.toString(), FileError$NotFound$.MODULE$.apply$default$2()));
            }
            return right;
        }));
    }

    private static final boolean checkFileExists$default$3$1() {
        return true;
    }

    public static final /* synthetic */ EitherT $anonfun$download$62(Schedulable S$1, File file$9, boolean x0$6) {
        EitherT eitherT;
        boolean bl = x0$6;
        if (bl) {
            eitherT = new EitherT(S$1.point(scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)));
        } else if (!bl) {
            eitherT = new EitherT(S$1.point(scala.package$.MODULE$.Left().apply((Object)new FileError.NotFound(file$9.toString(), FileError$NotFound$.MODULE$.apply$default$2()))));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return eitherT;
    }

    public static final /* synthetic */ EitherT $anonfun$download$65(Artifact artifact$1, File cache$1, CachePolicy cachePolicy$1, ExecutorService pool$1, Option logger$2, Schedulable S$1, Option referenceFileOpt$1, File file$10, String url$10, boolean x0$7) {
        EitherT eitherT;
        boolean bl = x0$7;
        if (bl) {
            eitherT = Cache$.remoteKeepErrors$1(file$10, url$10, artifact$1, cache$1, cachePolicy$1, pool$1, logger$2, S$1, referenceFileOpt$1);
        } else if (!bl) {
            eitherT = new EitherT(S$1.point(scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return eitherT;
    }

    private static final EitherT update$1(Artifact artifact$1, File cache$1, CachePolicy cachePolicy$1, ExecutorService pool$1, Option logger$2, Option ttl$1, Schedulable S$1, Option referenceFileOpt$1, File file$10, String url$10) {
        return Cache$.shouldDownload$1(file$10, url$10, artifact$1, pool$1, logger$2, ttl$1, S$1).flatMap((Function1 & Serializable & scala.Serializable)x0$7 -> Cache$.$anonfun$download$65(artifact$1, cache$1, cachePolicy$1, pool$1, logger$2, S$1, referenceFileOpt$1, file$10, url$10, BoxesRunTime.unboxToBoolean((Object)x0$7)), S$1);
    }

    private static final EitherT res$4(Artifact artifact$1, File cache$1, CachePolicy cachePolicy$1, ExecutorService pool$1, Option logger$2, Option ttl$1, boolean localArtifactsShouldBeCached$1, Schedulable S$1, Option referenceFileOpt$1, CachePolicy cachePolicy0$1, File file$10, String url$10) {
        EitherT eitherT;
        if (url$10.startsWith("file:/") && !localArtifactsShouldBeCached$1) {
            eitherT = Cache$.checkFileExists$1(file$10, url$10, Cache$.checkFileExists$default$3$1(), pool$1, logger$2, S$1);
        } else {
            EitherT eitherT2;
            CachePolicy cachePolicy = cachePolicy0$1;
            if (CachePolicy$LocalOnly$.MODULE$.equals(cachePolicy)) {
                eitherT2 = Cache$.checkFileExists$1(file$10, url$10, Cache$.checkFileExists$default$3$1(), pool$1, logger$2, S$1);
            } else {
                boolean bl = CachePolicy$LocalUpdateChanging$.MODULE$.equals(cachePolicy) ? true : CachePolicy$LocalUpdate$.MODULE$.equals(cachePolicy);
                if (bl) {
                    eitherT2 = Cache$.checkFileExists$1(file$10, url$10, false, pool$1, logger$2, S$1).flatMap((Function1 & Serializable & scala.Serializable)x$35 -> Cache$.update$1(artifact$1, cache$1, cachePolicy$1, pool$1, logger$2, ttl$1, S$1, referenceFileOpt$1, file$10, url$10), S$1);
                } else {
                    boolean bl2 = CachePolicy$UpdateChanging$.MODULE$.equals(cachePolicy) ? true : CachePolicy$Update$.MODULE$.equals(cachePolicy);
                    if (bl2) {
                        eitherT2 = Cache$.update$1(artifact$1, cache$1, cachePolicy$1, pool$1, logger$2, ttl$1, S$1, referenceFileOpt$1, file$10, url$10);
                    } else if (CachePolicy$FetchMissing$.MODULE$.equals(cachePolicy)) {
                        eitherT2 = Cache$.checkFileExists$1(file$10, url$10, Cache$.checkFileExists$default$3$1(), pool$1, logger$2, S$1).orElse((Function0 & Serializable & scala.Serializable)() -> Cache$.remoteKeepErrors$1(file$10, url$10, artifact$1, cache$1, cachePolicy$1, pool$1, logger$2, S$1, referenceFileOpt$1), S$1);
                    } else if (CachePolicy$ForceDownload$.MODULE$.equals(cachePolicy)) {
                        eitherT2 = Cache$.remoteKeepErrors$1(file$10, url$10, artifact$1, cache$1, cachePolicy$1, pool$1, logger$2, S$1, referenceFileOpt$1);
                    } else {
                        throw new MatchError((Object)cachePolicy);
                    }
                }
            }
            eitherT = eitherT2;
        }
        return eitherT;
    }

    public static final /* synthetic */ boolean $anonfun$file$4(String cUrl$1, Tuple2 x0$9) {
        String u;
        Either b;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$9;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                b = (Either)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String string = u = (String)tuple2._2();
        String string2 = cUrl$1;
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && b.isRight();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$file$2(Artifact artifact$2, Seq results$1, Option x0$8) {
        boolean bl;
        Option option = x0$8;
        if (None$.MODULE$.equals(option)) {
            bl = true;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String c = (String)some.value();
            bl = artifact$2.checksumUrls().get((Object)c).exists((Function1 & Serializable & scala.Serializable)cUrl -> BoxesRunTime.boxToBoolean((boolean)results$1.exists((Function1 & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)Cache$.$anonfun$file$4(cUrl, x0$9)))));
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private static final Left notFound$1(File f) {
        return scala.package$.MODULE$.Left().apply((Object)new StringBuilder(10).append(f.getCanonicalPath()).append(" not found").toString());
    }

    private static final Either read$2(File f) {
        Right right;
        try {
            right = scala.package$.MODULE$.Right().apply((Object)new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left = scala.package$.MODULE$.Left().apply((Object)new StringBuilder(24).append("Could not read (file:").append(f.getCanonicalPath()).append("): ").append(e.getMessage()).toString());
            right = left;
        }
        return right;
    }

    private static final Option fromString$1(String s) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Duration$.MODULE$.apply(s)).toOption();
    }

    private static final Option fromProps$1() {
        return scala.sys.package$.MODULE$.props().get("com.geirsson.shaded.coursier.ttl").flatMap((Function1 & Serializable & scala.Serializable)s -> Cache$.fromString$1(s));
    }

    private static final FiniteDuration default$1() {
        return new package.DurationInt(package$.MODULE$.DurationInt(24)).hours();
    }

    private Cache$() {
        MODULE$ = this;
        this.defaultChecksums = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)"SHA-1"), None$.MODULE$}));
        this.partialContentResponseCode = 206;
        this.invalidPartialContentResponseCode = 416;
        this.handlerClsCache = new ConcurrentHashMap();
        this.coursier$Cache$$BasicRealm = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(8).append("^").append(java.util.regex.Pattern.quote("Basic realm=\"")).append("([^").append(java.util.regex.Pattern.quote("\"")).append("]*)").append(java.util.regex.Pattern.quote("\"")).append("$").toString())).r();
        this.coursier$Cache$$checksumPattern = java.util.regex.Pattern.compile("^[0-9a-f]{32}([0-9a-f]{8})?([0-9a-f]{24})?");
        this.defaultConcurrentDownloadCount = 6;
        this.urlLocks = new ConcurrentHashMap();
        this.bufferSize = 0x100000;
    }

    public static final /* synthetic */ Object $anonfun$download$7$adapted(String url$4, Option currentLastModifiedOpt$1, Option res$1, Cache.Logger x$18) {
        x$18.checkingUpdatesResult(url$4, (Option<Object>)currentLastModifiedOpt$1, (Option<Object>)res$1);
        return BoxedUnit.UNIT;
    }
}

