/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.annotation.SuppressLint;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Range;

@SuppressLint(value={"ParcelCreator"})
public class BarEntry
extends Entry {
    private float[] mYVals;
    private Range[] mRanges;
    private float mNegativeSum;
    private float mPositiveSum;

    public BarEntry(float x, float[] vals) {
        super(x, BarEntry.calcSum(vals));
        this.mYVals = vals;
        this.calcRanges();
        this.calcPosNegSum();
    }

    public BarEntry(float x, float y) {
        super(x, y);
    }

    public BarEntry(float x, float[] vals, String label) {
        super(x, BarEntry.calcSum(vals), label);
        this.mYVals = vals;
        this.calcRanges();
        this.calcPosNegSum();
    }

    public BarEntry(float x, float y, Object data) {
        super(x, y, data);
    }

    @Override
    public BarEntry copy() {
        BarEntry copied = new BarEntry(this.getX(), this.getY(), this.getData());
        copied.setVals(this.mYVals);
        return copied;
    }

    public float[] getYVals() {
        return this.mYVals;
    }

    public void setVals(float[] vals) {
        this.setY(BarEntry.calcSum(vals));
        this.mYVals = vals;
        this.calcPosNegSum();
        this.calcRanges();
    }

    @Override
    public float getY() {
        return super.getY();
    }

    public Range[] getRanges() {
        return this.mRanges;
    }

    public boolean isStacked() {
        return this.mYVals != null;
    }

    @Deprecated
    public float getBelowSum(int stackIndex) {
        return this.getSumBelow(stackIndex);
    }

    public float getSumBelow(int stackIndex) {
        if (this.mYVals == null) {
            return 0.0f;
        }
        float remainder = 0.0f;
        for (int index = this.mYVals.length - 1; index > stackIndex && index >= 0; --index) {
            remainder += this.mYVals[index];
        }
        return remainder;
    }

    public float getPositiveSum() {
        return this.mPositiveSum;
    }

    public float getNegativeSum() {
        return this.mNegativeSum;
    }

    private void calcPosNegSum() {
        if (this.mYVals == null) {
            this.mNegativeSum = 0.0f;
            this.mPositiveSum = 0.0f;
            return;
        }
        float sumNeg = 0.0f;
        float sumPos = 0.0f;
        for (float f : this.mYVals) {
            if (f <= 0.0f) {
                sumNeg += Math.abs(f);
                continue;
            }
            sumPos += f;
        }
        this.mNegativeSum = sumNeg;
        this.mPositiveSum = sumPos;
    }

    private static float calcSum(float[] vals) {
        if (vals == null) {
            return 0.0f;
        }
        float sum = 0.0f;
        for (float f : vals) {
            sum += f;
        }
        return sum;
    }

    protected void calcRanges() {
        float[] values = this.getYVals();
        if (values == null || values.length == 0) {
            return;
        }
        this.mRanges = new Range[values.length];
        float negRemain = -this.getNegativeSum();
        float posRemain = 0.0f;
        for (int i = 0; i < this.mRanges.length; ++i) {
            float value = values[i];
            if (value < 0.0f) {
                this.mRanges[i] = new Range(negRemain, negRemain + value);
                negRemain += Math.abs(value);
                continue;
            }
            this.mRanges[i] = new Range(posRemain, posRemain + value);
            posRemain += value;
        }
    }
}

