/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.content.Context;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Typeface;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDataSet<T extends Entry>
implements IDataSet<T> {
    protected List<Integer> mColors = null;
    protected List<Integer> mValueColors = null;
    private String mLabel = "DataSet";
    protected YAxis.AxisDependency mAxisDependency = YAxis.AxisDependency.LEFT;
    protected boolean mHighlightEnabled = true;
    protected transient IValueFormatter mValueFormatter;
    protected Typeface mValueTypeface;
    private Legend.LegendForm mForm = Legend.LegendForm.DEFAULT;
    private float mFormSize = Float.NaN;
    private float mFormLineWidth = Float.NaN;
    private DashPathEffect mFormLineDashEffect = null;
    protected boolean mDrawValues = true;
    protected float mValueTextSize = 17.0f;
    protected boolean mVisible = true;

    public BaseDataSet() {
        this.mColors = new ArrayList<Integer>();
        this.mValueColors = new ArrayList<Integer>();
        this.mColors.add(Color.rgb((int)140, (int)234, (int)255));
        this.mValueColors.add(-16777216);
    }

    public BaseDataSet(String label) {
        this();
        this.mLabel = label;
    }

    public void notifyDataSetChanged() {
        this.calcMinMax();
    }

    @Override
    public List<Integer> getColors() {
        return this.mColors;
    }

    public List<Integer> getValueColors() {
        return this.mValueColors;
    }

    @Override
    public int getColor() {
        return this.mColors.get(0);
    }

    @Override
    public int getColor(int index) {
        return this.mColors.get(index % this.mColors.size());
    }

    public void setColors(List<Integer> colors) {
        this.mColors = colors;
    }

    public void setColors(int ... colors) {
        this.mColors = ColorTemplate.createColors(colors);
    }

    public void setColors(int[] colors, Context c) {
        if (this.mColors == null) {
            this.mColors = new ArrayList<Integer>();
        }
        this.mColors.clear();
        for (int color : colors) {
            this.mColors.add(c.getResources().getColor(color));
        }
    }

    public void addColor(int color) {
        if (this.mColors == null) {
            this.mColors = new ArrayList<Integer>();
        }
        this.mColors.add(color);
    }

    public void setColor(int color) {
        this.resetColors();
        this.mColors.add(color);
    }

    public void setColor(int color, int alpha) {
        this.setColor(Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color)));
    }

    public void setColors(int[] colors, int alpha) {
        this.resetColors();
        for (int color : colors) {
            this.addColor(Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color)));
        }
    }

    public void resetColors() {
        if (this.mColors == null) {
            this.mColors = new ArrayList<Integer>();
        }
        this.mColors.clear();
    }

    @Override
    public void setLabel(String label) {
        this.mLabel = label;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public void setHighlightEnabled(boolean enabled) {
        this.mHighlightEnabled = enabled;
    }

    @Override
    public boolean isHighlightEnabled() {
        return this.mHighlightEnabled;
    }

    @Override
    public void setValueFormatter(IValueFormatter f) {
        if (f == null) {
            return;
        }
        this.mValueFormatter = f;
    }

    @Override
    public IValueFormatter getValueFormatter() {
        if (this.needsFormatter()) {
            return Utils.getDefaultValueFormatter();
        }
        return this.mValueFormatter;
    }

    @Override
    public boolean needsFormatter() {
        return this.mValueFormatter == null;
    }

    @Override
    public void setValueTextColor(int color) {
        this.mValueColors.clear();
        this.mValueColors.add(color);
    }

    @Override
    public void setValueTextColors(List<Integer> colors) {
        this.mValueColors = colors;
    }

    @Override
    public void setValueTypeface(Typeface tf) {
        this.mValueTypeface = tf;
    }

    @Override
    public void setValueTextSize(float size) {
        this.mValueTextSize = Utils.convertDpToPixel(size);
    }

    @Override
    public int getValueTextColor() {
        return this.mValueColors.get(0);
    }

    @Override
    public int getValueTextColor(int index) {
        return this.mValueColors.get(index % this.mValueColors.size());
    }

    @Override
    public Typeface getValueTypeface() {
        return this.mValueTypeface;
    }

    @Override
    public float getValueTextSize() {
        return this.mValueTextSize;
    }

    public void setForm(Legend.LegendForm form) {
        this.mForm = form;
    }

    @Override
    public Legend.LegendForm getForm() {
        return this.mForm;
    }

    public void setFormSize(float formSize) {
        this.mFormSize = formSize;
    }

    @Override
    public float getFormSize() {
        return this.mFormSize;
    }

    public void setFormLineWidth(float formLineWidth) {
        this.mFormLineWidth = formLineWidth;
    }

    @Override
    public float getFormLineWidth() {
        return this.mFormLineWidth;
    }

    public void setFormLineDashEffect(DashPathEffect dashPathEffect) {
        this.mFormLineDashEffect = dashPathEffect;
    }

    @Override
    public DashPathEffect getFormLineDashEffect() {
        return this.mFormLineDashEffect;
    }

    @Override
    public void setDrawValues(boolean enabled) {
        this.mDrawValues = enabled;
    }

    @Override
    public boolean isDrawValuesEnabled() {
        return this.mDrawValues;
    }

    @Override
    public void setVisible(boolean visible) {
        this.mVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.mVisible;
    }

    @Override
    public YAxis.AxisDependency getAxisDependency() {
        return this.mAxisDependency;
    }

    @Override
    public void setAxisDependency(YAxis.AxisDependency dependency) {
        this.mAxisDependency = dependency;
    }

    @Override
    public int getIndexInEntries(int xIndex) {
        for (int i = 0; i < this.getEntryCount(); ++i) {
            if ((float)xIndex != ((Entry)this.getEntryForIndex(i)).getX()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean removeFirst() {
        if (this.getEntryCount() > 0) {
            Object entry = this.getEntryForIndex(0);
            return this.removeEntry(entry);
        }
        return false;
    }

    @Override
    public boolean removeLast() {
        if (this.getEntryCount() > 0) {
            Object e = this.getEntryForIndex(this.getEntryCount() - 1);
            return this.removeEntry(e);
        }
        return false;
    }

    @Override
    public boolean removeEntryByXValue(float xValue) {
        Object e = this.getEntryForXValue(xValue, Float.NaN);
        return this.removeEntry(e);
    }

    @Override
    public boolean removeEntry(int index) {
        Object e = this.getEntryForIndex(index);
        return this.removeEntry(e);
    }

    @Override
    public boolean contains(T e) {
        for (int i = 0; i < this.getEntryCount(); ++i) {
            if (!this.getEntryForIndex(i).equals(e)) continue;
            return true;
        }
        return false;
    }
}

