/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Color;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import java.util.ArrayList;
import java.util.List;

public class BarDataSet
extends BarLineScatterCandleBubbleDataSet<BarEntry>
implements IBarDataSet {
    private float mBarSpace = 0.15f;
    private int mStackSize = 1;
    private int mBarShadowColor = Color.rgb((int)215, (int)215, (int)215);
    private float mBarBorderWidth = 0.0f;
    private int mBarBorderColor = -16777216;
    private int mHighLightAlpha = 120;
    private int mEntryCountStacks = 0;
    private String[] mStackLabels = new String[]{"Stack"};

    public BarDataSet(List<BarEntry> yVals, String label) {
        super(yVals, label);
        this.mHighLightColor = Color.rgb((int)0, (int)0, (int)0);
        this.calcStackSize(yVals);
        this.calcEntryCountIncludingStacks(yVals);
    }

    @Override
    public DataSet<BarEntry> copy() {
        ArrayList<BarEntry> yVals = new ArrayList<BarEntry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            yVals.add(((BarEntry)this.mYVals.get(i)).copy());
        }
        BarDataSet copied = new BarDataSet((List<BarEntry>)yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mStackSize = this.mStackSize;
        copied.mBarSpace = this.mBarSpace;
        copied.mBarShadowColor = this.mBarShadowColor;
        copied.mStackLabels = this.mStackLabels;
        copied.mHighLightColor = this.mHighLightColor;
        copied.mHighLightAlpha = this.mHighLightAlpha;
        return copied;
    }

    private void calcEntryCountIncludingStacks(List<BarEntry> yVals) {
        this.mEntryCountStacks = 0;
        for (int i = 0; i < yVals.size(); ++i) {
            float[] vals = yVals.get(i).getVals();
            if (vals == null) {
                ++this.mEntryCountStacks;
                continue;
            }
            this.mEntryCountStacks += vals.length;
        }
    }

    private void calcStackSize(List<BarEntry> yVals) {
        for (int i = 0; i < yVals.size(); ++i) {
            float[] vals = yVals.get(i).getVals();
            if (vals == null || vals.length <= this.mStackSize) continue;
            this.mStackSize = vals.length;
        }
    }

    @Override
    public void calcMinMax(int start, int end) {
        if (this.mYVals == null) {
            return;
        }
        int yValCount = this.mYVals.size();
        if (yValCount == 0) {
            return;
        }
        int endValue = end == 0 || end >= yValCount ? yValCount - 1 : end;
        this.mYMin = Float.MAX_VALUE;
        this.mYMax = -3.4028235E38f;
        for (int i = start; i <= endValue; ++i) {
            BarEntry e = (BarEntry)this.mYVals.get(i);
            if (e == null || Float.isNaN(e.getVal())) continue;
            if (e.getVals() == null) {
                if (e.getVal() < this.mYMin) {
                    this.mYMin = e.getVal();
                }
                if (!(e.getVal() > this.mYMax)) continue;
                this.mYMax = e.getVal();
                continue;
            }
            if (-e.getNegativeSum() < this.mYMin) {
                this.mYMin = -e.getNegativeSum();
            }
            if (!(e.getPositiveSum() > this.mYMax)) continue;
            this.mYMax = e.getPositiveSum();
        }
        if (this.mYMin == Float.MAX_VALUE) {
            this.mYMin = 0.0f;
            this.mYMax = 0.0f;
        }
    }

    @Override
    public int getStackSize() {
        return this.mStackSize;
    }

    @Override
    public boolean isStacked() {
        return this.mStackSize > 1;
    }

    public int getEntryCountStacks() {
        return this.mEntryCountStacks;
    }

    public float getBarSpacePercent() {
        return this.mBarSpace * 100.0f;
    }

    @Override
    public float getBarSpace() {
        return this.mBarSpace;
    }

    public void setBarSpacePercent(float percent) {
        this.mBarSpace = percent / 100.0f;
    }

    public void setBarShadowColor(int color) {
        this.mBarShadowColor = color;
    }

    @Override
    public int getBarShadowColor() {
        return this.mBarShadowColor;
    }

    public void setBarBorderWidth(float width) {
        this.mBarBorderWidth = width;
    }

    @Override
    public float getBarBorderWidth() {
        return this.mBarBorderWidth;
    }

    public void setBarBorderColor(int color) {
        this.mBarBorderColor = color;
    }

    @Override
    public int getBarBorderColor() {
        return this.mBarBorderColor;
    }

    public void setHighLightAlpha(int alpha) {
        this.mHighLightAlpha = alpha;
    }

    @Override
    public int getHighLightAlpha() {
        return this.mHighLightAlpha;
    }

    public void setStackLabels(String[] labels) {
        this.mStackLabels = labels;
    }

    @Override
    public String[] getStackLabels() {
        return this.mStackLabels;
    }
}

