/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.BaseDataSet;
import com.github.mikephil.charting.data.Entry;
import java.util.ArrayList;
import java.util.List;

public abstract class DataSet<T extends Entry>
extends BaseDataSet<T> {
    protected List<T> mYVals = null;
    protected float mYMax = 0.0f;
    protected float mYMin = 0.0f;

    public DataSet(List<T> yVals, String label) {
        super(label);
        this.mYVals = yVals;
        if (this.mYVals == null) {
            this.mYVals = new ArrayList<T>();
        }
        this.calcMinMax(0, this.mYVals.size());
    }

    @Override
    public void calcMinMax(int start, int end) {
        if (this.mYVals == null) {
            return;
        }
        int yValCount = this.mYVals.size();
        if (yValCount == 0) {
            return;
        }
        int endValue = end == 0 || end >= yValCount ? yValCount - 1 : end;
        this.mYMin = Float.MAX_VALUE;
        this.mYMax = -3.4028235E38f;
        for (int i = start; i <= endValue; ++i) {
            Entry e = (Entry)this.mYVals.get(i);
            if (e == null || Float.isNaN(e.getVal())) continue;
            if (e.getVal() < this.mYMin) {
                this.mYMin = e.getVal();
            }
            if (!(e.getVal() > this.mYMax)) continue;
            this.mYMax = e.getVal();
        }
        if (this.mYMin == Float.MAX_VALUE) {
            this.mYMin = 0.0f;
            this.mYMax = 0.0f;
        }
    }

    @Override
    public int getEntryCount() {
        return this.mYVals.size();
    }

    public List<T> getYVals() {
        return this.mYVals;
    }

    public void setYVals(List<T> yVals) {
        this.mYVals = yVals;
        this.notifyDataSetChanged();
    }

    public abstract DataSet<T> copy();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toSimpleString());
        for (int i = 0; i < this.mYVals.size(); ++i) {
            buffer.append(((Entry)this.mYVals.get(i)).toString() + " ");
        }
        return buffer.toString();
    }

    public String toSimpleString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataSet, label: " + (this.getLabel() == null ? "" : this.getLabel()) + ", entries: " + this.mYVals.size() + "\n");
        return buffer.toString();
    }

    @Override
    public float getYMin() {
        return this.mYMin;
    }

    @Override
    public float getYMax() {
        return this.mYMax;
    }

    @Override
    public void addEntryOrdered(T e) {
        if (e == null) {
            return;
        }
        float val = ((Entry)e).getVal();
        if (this.mYVals == null) {
            this.mYVals = new ArrayList<T>();
        }
        if (this.mYVals.size() == 0) {
            this.mYMax = val;
            this.mYMin = val;
        } else {
            if (this.mYMax < val) {
                this.mYMax = val;
            }
            if (this.mYMin > val) {
                this.mYMin = val;
            }
        }
        if (this.mYVals.size() > 0 && ((Entry)this.mYVals.get(this.mYVals.size() - 1)).getXIndex() > ((Entry)e).getXIndex()) {
            int closestIndex = this.getEntryIndex(((Entry)e).getXIndex(), Rounding.UP);
            this.mYVals.add(closestIndex, e);
            return;
        }
        this.mYVals.add(e);
    }

    @Override
    public void clear() {
        this.mYVals.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean addEntry(T e) {
        if (e == null) {
            return false;
        }
        float val = ((Entry)e).getVal();
        List<T> yVals = this.getYVals();
        if (yVals == null) {
            yVals = new ArrayList<T>();
        }
        if (yVals.size() == 0) {
            this.mYMax = val;
            this.mYMin = val;
        } else {
            if (this.mYMax < val) {
                this.mYMax = val;
            }
            if (this.mYMin > val) {
                this.mYMin = val;
            }
        }
        yVals.add(e);
        return true;
    }

    @Override
    public boolean removeEntry(T e) {
        if (e == null) {
            return false;
        }
        if (this.mYVals == null) {
            return false;
        }
        boolean removed = this.mYVals.remove(e);
        if (removed) {
            this.calcMinMax(0, this.mYVals.size());
        }
        return removed;
    }

    @Override
    public int getEntryIndex(Entry e) {
        return this.mYVals.indexOf(e);
    }

    @Override
    public T getEntryForXIndex(int xIndex, Rounding rounding) {
        int index = this.getEntryIndex(xIndex, rounding);
        if (index > -1) {
            return (T)((Entry)this.mYVals.get(index));
        }
        return null;
    }

    @Override
    public T getEntryForXIndex(int xIndex) {
        return this.getEntryForXIndex(xIndex, Rounding.CLOSEST);
    }

    @Override
    public T getEntryForIndex(int index) {
        return (T)((Entry)this.mYVals.get(index));
    }

    @Override
    public int getEntryIndex(int xIndex, Rounding rounding) {
        int low = 0;
        int high = this.mYVals.size() - 1;
        int closest = -1;
        while (low <= high) {
            int m = (high + low) / 2;
            if (xIndex == ((Entry)this.mYVals.get(m)).getXIndex()) {
                while (m > 0 && ((Entry)this.mYVals.get(m - 1)).getXIndex() == xIndex) {
                    --m;
                }
                return m;
            }
            if (xIndex > ((Entry)this.mYVals.get(m)).getXIndex()) {
                low = m + 1;
            } else {
                high = m - 1;
            }
            closest = m;
        }
        if (closest != -1) {
            int closestXIndex = ((Entry)this.mYVals.get(closest)).getXIndex();
            if (rounding == Rounding.UP) {
                if (closestXIndex < xIndex && closest < this.mYVals.size() - 1) {
                    ++closest;
                }
            } else if (rounding == Rounding.DOWN && closestXIndex > xIndex && closest > 0) {
                --closest;
            }
        }
        return closest;
    }

    @Override
    public float getYValForXIndex(int xIndex) {
        T e = this.getEntryForXIndex(xIndex);
        if (e != null && ((Entry)e).getXIndex() == xIndex) {
            return ((Entry)e).getVal();
        }
        return Float.NaN;
    }

    @Override
    public float[] getYValsForXIndex(int xIndex) {
        List<T> entries = this.getEntriesForXIndex(xIndex);
        float[] yVals = new float[entries.size()];
        int i = 0;
        for (Entry e : entries) {
            yVals[i++] = e.getVal();
        }
        return yVals;
    }

    @Override
    public List<T> getEntriesForXIndex(int xIndex) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        int low = 0;
        int high = this.mYVals.size() - 1;
        while (low <= high) {
            int m = (high + low) / 2;
            Entry entry = (Entry)this.mYVals.get(m);
            if (xIndex == entry.getXIndex()) {
                while (m > 0 && ((Entry)this.mYVals.get(m - 1)).getXIndex() == xIndex) {
                    --m;
                }
                high = this.mYVals.size();
                while (m < high && (entry = (Entry)this.mYVals.get(m)).getXIndex() == xIndex) {
                    entries.add(entry);
                    ++m;
                }
                break;
            }
            if (xIndex > entry.getXIndex()) {
                low = m + 1;
                continue;
            }
            high = m - 1;
        }
        return entries;
    }

    public static enum Rounding {
        UP,
        DOWN,
        CLOSEST;

    }
}

