/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.realm.implementation;

import android.content.Context;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.data.realm.base.RealmLineRadarDataSet;
import com.github.mikephil.charting.formatter.DefaultFillFormatter;
import com.github.mikephil.charting.formatter.FillFormatter;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.Utils;
import io.realm.RealmObject;
import io.realm.RealmResults;
import java.util.ArrayList;
import java.util.List;

public class RealmLineDataSet<T extends RealmObject>
extends RealmLineRadarDataSet<T>
implements ILineDataSet {
    private LineDataSet.Mode mMode = LineDataSet.Mode.LINEAR;
    private List<Integer> mCircleColors = null;
    private int mCircleColorHole = -1;
    private float mCircleRadius = 8.0f;
    private float mCircleHoleRadius = 4.0f;
    private float mCubicIntensity = 0.2f;
    private DashPathEffect mDashPathEffect = null;
    private FillFormatter mFillFormatter = new DefaultFillFormatter();
    private boolean mDrawCircles = true;
    private boolean mDrawCircleHole = true;

    public RealmLineDataSet(RealmResults<T> result, String yValuesField) {
        super(result, yValuesField);
        this.mCircleColors = new ArrayList<Integer>();
        this.mCircleColors.add(Color.rgb((int)140, (int)234, (int)255));
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    public RealmLineDataSet(RealmResults<T> result, String yValuesField, String xIndexField) {
        super(result, yValuesField, xIndexField);
        this.mCircleColors = new ArrayList<Integer>();
        this.mCircleColors.add(Color.rgb((int)140, (int)234, (int)255));
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    @Override
    public LineDataSet.Mode getMode() {
        return this.mMode;
    }

    public void setMode(LineDataSet.Mode mode) {
        this.mMode = mode;
    }

    public void setCubicIntensity(float intensity) {
        if (intensity > 1.0f) {
            intensity = 1.0f;
        }
        if (intensity < 0.05f) {
            intensity = 0.05f;
        }
        this.mCubicIntensity = intensity;
    }

    @Override
    public float getCubicIntensity() {
        return this.mCubicIntensity;
    }

    public void setCircleSize(float size) {
        this.mCircleRadius = Utils.convertDpToPixel(size);
    }

    @Override
    public float getCircleRadius() {
        return this.mCircleRadius;
    }

    public void setCircleHoleRadius(float holeRadius) {
        this.mCircleHoleRadius = Utils.convertDpToPixel(holeRadius);
    }

    @Override
    public float getCircleHoleRadius() {
        return this.mCircleHoleRadius;
    }

    public void enableDashedLine(float lineLength, float spaceLength, float phase) {
        this.mDashPathEffect = new DashPathEffect(new float[]{lineLength, spaceLength}, phase);
    }

    public void disableDashedLine() {
        this.mDashPathEffect = null;
    }

    @Override
    public boolean isDashedLineEnabled() {
        return this.mDashPathEffect != null;
    }

    @Override
    public DashPathEffect getDashPathEffect() {
        return this.mDashPathEffect;
    }

    public void setDrawCircles(boolean enabled) {
        this.mDrawCircles = enabled;
    }

    @Override
    public boolean isDrawCirclesEnabled() {
        return this.mDrawCircles;
    }

    @Deprecated
    public void setDrawCubic(boolean enabled) {
        this.mMode = enabled ? LineDataSet.Mode.CUBIC_BEZIER : LineDataSet.Mode.LINEAR;
    }

    @Override
    @Deprecated
    public boolean isDrawCubicEnabled() {
        return this.mMode == LineDataSet.Mode.CUBIC_BEZIER;
    }

    @Deprecated
    public void setDrawStepped(boolean enabled) {
        this.mMode = enabled ? LineDataSet.Mode.STEPPED : LineDataSet.Mode.LINEAR;
    }

    @Override
    @Deprecated
    public boolean isDrawSteppedEnabled() {
        return this.mMode == LineDataSet.Mode.STEPPED;
    }

    public List<Integer> getCircleColors() {
        return this.mCircleColors;
    }

    @Override
    public int getCircleColor(int index) {
        return this.mCircleColors.get(index % this.mCircleColors.size());
    }

    public void setCircleColors(List<Integer> colors) {
        this.mCircleColors = colors;
    }

    public void setCircleColors(int[] colors) {
        this.mCircleColors = ColorTemplate.createColors(colors);
    }

    public void setCircleColors(int[] colors, Context c) {
        ArrayList<Integer> clrs = new ArrayList<Integer>();
        for (int color : colors) {
            clrs.add(c.getResources().getColor(color));
        }
        this.mCircleColors = clrs;
    }

    public void setCircleColor(int color) {
        this.resetCircleColors();
        this.mCircleColors.add(color);
    }

    public void resetCircleColors() {
        this.mCircleColors = new ArrayList<Integer>();
    }

    public void setCircleColorHole(int color) {
        this.mCircleColorHole = color;
    }

    @Override
    public int getCircleHoleColor() {
        return this.mCircleColorHole;
    }

    public void setDrawCircleHole(boolean enabled) {
        this.mDrawCircleHole = enabled;
    }

    @Override
    public boolean isDrawCircleHoleEnabled() {
        return this.mDrawCircleHole;
    }

    public void setFillFormatter(FillFormatter formatter) {
        this.mFillFormatter = formatter == null ? new DefaultFillFormatter() : formatter;
    }

    @Override
    public FillFormatter getFillFormatter() {
        return this.mFillFormatter;
    }
}

