/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.highlight.ChartHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Range;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.utils.SelectionDetail;

public class BarHighlighter
extends ChartHighlighter<BarDataProvider> {
    public BarHighlighter(BarDataProvider chart) {
        super(chart);
    }

    @Override
    public Highlight getHighlight(float x, float y) {
        int setCount;
        BarData barData = ((BarDataProvider)this.mChart).getBarData();
        int xIndex = this.getXIndex(x);
        float baseNoSpace = this.getBase(x);
        int dataSetIndex = (int)baseNoSpace % (setCount = barData.getDataSetCount());
        if (dataSetIndex < 0) {
            dataSetIndex = 0;
        } else if (dataSetIndex >= setCount) {
            dataSetIndex = setCount - 1;
        }
        SelectionDetail selectionDetail = this.getSelectionDetail(xIndex, y, dataSetIndex);
        if (selectionDetail == null) {
            return null;
        }
        IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(dataSetIndex);
        if (set.isStacked()) {
            float[] pts = new float[2];
            pts[1] = y;
            ((BarDataProvider)this.mChart).getTransformer(set.getAxisDependency()).pixelsToValue(pts);
            return this.getStackedHighlight(selectionDetail, set, xIndex, pts[1]);
        }
        return new Highlight(xIndex, selectionDetail.value, selectionDetail.dataIndex, selectionDetail.dataSetIndex, -1);
    }

    @Override
    protected int getXIndex(float x) {
        if (!((BarDataProvider)this.mChart).getBarData().isGrouped()) {
            return super.getXIndex(x);
        }
        float baseNoSpace = this.getBase(x);
        int setCount = ((BarDataProvider)this.mChart).getBarData().getDataSetCount();
        int xIndex = (int)baseNoSpace / setCount;
        int valCount = ((BarDataProvider)this.mChart).getData().getXValCount();
        if (xIndex < 0) {
            xIndex = 0;
        } else if (xIndex >= valCount) {
            xIndex = valCount - 1;
        }
        return xIndex;
    }

    @Override
    protected SelectionDetail getSelectionDetail(int xIndex, float y, int dataSetIndex) {
        IBarDataSet dataSet;
        dataSetIndex = Math.max(dataSetIndex, 0);
        BarData barData = ((BarDataProvider)this.mChart).getBarData();
        IBarDataSet iBarDataSet = dataSet = barData.getDataSetCount() > dataSetIndex ? (IBarDataSet)barData.getDataSetByIndex(dataSetIndex) : null;
        if (dataSet == null) {
            return null;
        }
        float yValue = dataSet.getYValForXIndex(xIndex);
        if ((double)yValue == Double.NaN) {
            return null;
        }
        return new SelectionDetail(yValue, dataSetIndex, dataSet);
    }

    protected Highlight getStackedHighlight(SelectionDetail selectionDetail, IBarDataSet set, int xIndex, double yValue) {
        BarEntry entry = (BarEntry)set.getEntryForXIndex(xIndex);
        if (entry == null) {
            return null;
        }
        if (entry.getVals() == null) {
            return new Highlight(xIndex, entry.getVal(), selectionDetail.dataIndex, selectionDetail.dataSetIndex);
        }
        Range[] ranges = this.getRanges(entry);
        if (ranges.length > 0) {
            int stackIndex = this.getClosestStackIndex(ranges, (float)yValue);
            return new Highlight(xIndex, entry.getPositiveSum() - entry.getNegativeSum(), selectionDetail.dataIndex, selectionDetail.dataSetIndex, stackIndex, ranges[stackIndex]);
        }
        return null;
    }

    protected int getClosestStackIndex(Range[] ranges, float value) {
        if (ranges == null || ranges.length == 0) {
            return 0;
        }
        int stackIndex = 0;
        for (Range range : ranges) {
            if (range.contains(value)) {
                return stackIndex;
            }
            ++stackIndex;
        }
        int length = Math.max(ranges.length - 1, 0);
        return value > ranges[length].to ? length : 0;
    }

    protected float getBase(float x) {
        float[] pts = new float[2];
        pts[0] = x;
        ((BarDataProvider)this.mChart).getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        float xVal = pts[0];
        int setCount = ((BarDataProvider)this.mChart).getBarData().getDataSetCount();
        int steps = (int)(xVal / ((float)setCount + ((BarDataProvider)this.mChart).getBarData().getGroupSpace()));
        float groupSpaceSum = ((BarDataProvider)this.mChart).getBarData().getGroupSpace() * (float)steps;
        float baseNoSpace = xVal - groupSpaceSum;
        return baseNoSpace;
    }

    protected Range[] getRanges(BarEntry entry) {
        float[] values = entry.getVals();
        if (values == null || values.length == 0) {
            return new Range[0];
        }
        Range[] ranges = new Range[values.length];
        float negRemain = -entry.getNegativeSum();
        float posRemain = 0.0f;
        for (int i = 0; i < ranges.length; ++i) {
            float value = values[i];
            if (value < 0.0f) {
                ranges[i] = new Range(negRemain, negRemain + Math.abs(value));
                negRemain += Math.abs(value);
                continue;
            }
            ranges[i] = new Range(posRemain, posRemain + value);
            posRemain += value;
        }
        return ranges;
    }
}

