/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarLineScatterCandleBubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.utils.SelectionDetail;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class ChartHighlighter<T extends BarLineScatterCandleBubbleDataProvider> {
    protected T mChart;

    public ChartHighlighter(T chart) {
        this.mChart = chart;
    }

    public Highlight getHighlight(float x, float y) {
        int xIndex = this.getXIndex(x);
        SelectionDetail selectionDetail = this.getSelectionDetail(xIndex, y, -1);
        if (selectionDetail == null) {
            return null;
        }
        return new Highlight(xIndex, selectionDetail.value, selectionDetail.dataIndex, selectionDetail.dataSetIndex);
    }

    protected int getXIndex(float x) {
        float[] pts = new float[2];
        pts[0] = x;
        this.mChart.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        return Math.round(pts[0]);
    }

    protected SelectionDetail getSelectionDetail(int xIndex, float y, int dataSetIndex) {
        float rightdist;
        List<SelectionDetail> valsAtIndex = this.getSelectionDetailsAtIndex(xIndex, dataSetIndex);
        float leftdist = Utils.getMinimumDistance(valsAtIndex, y, YAxis.AxisDependency.LEFT);
        YAxis.AxisDependency axis = leftdist < (rightdist = Utils.getMinimumDistance(valsAtIndex, y, YAxis.AxisDependency.RIGHT)) ? YAxis.AxisDependency.LEFT : YAxis.AxisDependency.RIGHT;
        SelectionDetail detail = Utils.getClosestSelectionDetailByPixelY(valsAtIndex, y, axis);
        return detail;
    }

    protected List<SelectionDetail> getSelectionDetailsAtIndex(int xIndex, int dataSetIndex) {
        ArrayList<SelectionDetail> vals = new ArrayList<SelectionDetail>();
        if (this.mChart.getData() == null) {
            return vals;
        }
        float[] pts = new float[2];
        int dataSetCount = this.mChart.getData().getDataSetCount();
        for (int i = 0; i < dataSetCount; ++i) {
            float[] yVals;
            Object dataSet;
            if (dataSetIndex > -1 && dataSetIndex != i || !(dataSet = this.mChart.getData().getDataSetByIndex(i)).isHighlightEnabled()) continue;
            for (float yVal : yVals = dataSet.getYValsForXIndex(xIndex)) {
                if (Float.isNaN(yVal)) continue;
                pts[1] = yVal;
                this.mChart.getTransformer(dataSet.getAxisDependency()).pointValuesToPixel(pts);
                if (Float.isNaN(pts[1])) continue;
                vals.add(new SelectionDetail(pts[1], yVal, i, (IDataSet)dataSet));
            }
        }
        return vals;
    }
}

