/*
 * Decompiled with CFR 0.152.
 */
package com.github.angads25.filepicker.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.github.angads25.filepicker.R;
import com.github.angads25.filepicker.controller.DialogSelectionListener;
import com.github.angads25.filepicker.controller.NotifyItemChecked;
import com.github.angads25.filepicker.controller.adapters.FileListAdapter;
import com.github.angads25.filepicker.model.DialogProperties;
import com.github.angads25.filepicker.model.FileListItem;
import com.github.angads25.filepicker.model.MarkedItemList;
import com.github.angads25.filepicker.utils.ExtensionFilter;
import com.github.angads25.filepicker.utils.Utility;
import com.github.angads25.filepicker.widget.MaterialCheckbox;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FilePickerDialog
extends Dialog
implements AdapterView.OnItemClickListener {
    private Context context;
    private ListView listView;
    private TextView dname;
    private TextView dir_path;
    private TextView title;
    private DialogProperties properties;
    private DialogSelectionListener callbacks;
    private ArrayList<FileListItem> internalList;
    private ExtensionFilter filter;
    private FileListAdapter mFileListAdapter;
    private Button select;
    private String titleStr = null;
    private String positiveBtnNameStr = null;
    private String negativeBtnNameStr = null;
    public static final int EXTERNAL_READ_PERMISSION_GRANT = 112;

    public FilePickerDialog(Context context) {
        super(context);
        this.context = context;
        this.properties = new DialogProperties();
        this.filter = new ExtensionFilter(this.properties);
        this.internalList = new ArrayList();
    }

    public FilePickerDialog(Context context, DialogProperties properties) {
        super(context);
        this.context = context;
        this.properties = properties;
        this.filter = new ExtensionFilter(properties);
        this.internalList = new ArrayList();
    }

    public FilePickerDialog(Context context, DialogProperties properties, int themeResId) {
        super(context, themeResId);
        this.context = context;
        this.properties = properties;
        this.filter = new ExtensionFilter(properties);
        this.internalList = new ArrayList();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.dialog_main);
        this.listView = (ListView)this.findViewById(R.id.fileList);
        this.select = (Button)this.findViewById(R.id.select);
        int size = MarkedItemList.getFileCount();
        if (size == 0) {
            this.select.setEnabled(false);
            int color2 = Build.VERSION.SDK_INT >= 23 ? this.context.getResources().getColor(R.color.colorAccent, this.context.getTheme()) : this.context.getResources().getColor(R.color.colorAccent);
            this.select.setTextColor(Color.argb((int)128, (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2)));
        }
        this.dname = (TextView)this.findViewById(R.id.dname);
        this.title = (TextView)this.findViewById(R.id.title);
        this.dir_path = (TextView)this.findViewById(R.id.dir_path);
        Button cancel = (Button)this.findViewById(R.id.cancel);
        if (this.negativeBtnNameStr != null) {
            cancel.setText((CharSequence)this.negativeBtnNameStr);
        }
        this.select.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String[] paths = MarkedItemList.getSelectedPaths();
                if (FilePickerDialog.this.callbacks != null) {
                    FilePickerDialog.this.callbacks.onSelectedFilePaths(paths);
                }
                FilePickerDialog.this.dismiss();
            }
        });
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FilePickerDialog.this.dismiss();
            }
        });
        this.mFileListAdapter = new FileListAdapter(this.internalList, this.context, this.properties);
        this.mFileListAdapter.setNotifyItemCheckedListener(new NotifyItemChecked(){

            @Override
            public void notifyCheckBoxIsClicked() {
                FilePickerDialog.this.positiveBtnNameStr = FilePickerDialog.this.positiveBtnNameStr == null ? FilePickerDialog.this.context.getResources().getString(R.string.choose_button_label) : FilePickerDialog.this.positiveBtnNameStr;
                int size = MarkedItemList.getFileCount();
                if (size == 0) {
                    FilePickerDialog.this.select.setEnabled(false);
                    int color2 = Build.VERSION.SDK_INT >= 23 ? FilePickerDialog.this.context.getResources().getColor(R.color.colorAccent, FilePickerDialog.this.context.getTheme()) : FilePickerDialog.this.context.getResources().getColor(R.color.colorAccent);
                    FilePickerDialog.this.select.setTextColor(Color.argb((int)128, (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2)));
                    FilePickerDialog.this.select.setText((CharSequence)FilePickerDialog.this.positiveBtnNameStr);
                } else {
                    FilePickerDialog.this.select.setEnabled(true);
                    int color3 = Build.VERSION.SDK_INT >= 23 ? FilePickerDialog.this.context.getResources().getColor(R.color.colorAccent, FilePickerDialog.this.context.getTheme()) : FilePickerDialog.this.context.getResources().getColor(R.color.colorAccent);
                    FilePickerDialog.this.select.setTextColor(color3);
                    String button_label = FilePickerDialog.this.positiveBtnNameStr + " (" + size + ") ";
                    FilePickerDialog.this.select.setText((CharSequence)button_label);
                }
                if (((FilePickerDialog)FilePickerDialog.this).properties.selection_mode == 0) {
                    FilePickerDialog.this.mFileListAdapter.notifyDataSetChanged();
                }
            }
        });
        this.listView.setAdapter((ListAdapter)this.mFileListAdapter);
        this.setTitle();
    }

    private void setTitle() {
        if (this.title == null || this.dname == null) {
            return;
        }
        if (this.titleStr != null) {
            if (this.title.getVisibility() == 4) {
                this.title.setVisibility(0);
            }
            this.title.setText((CharSequence)this.titleStr);
            if (this.dname.getVisibility() == 0) {
                this.dname.setVisibility(4);
            }
        } else {
            if (this.title.getVisibility() == 0) {
                this.title.setVisibility(4);
            }
            if (this.dname.getVisibility() == 4) {
                this.dname.setVisibility(0);
            }
        }
    }

    protected void onStart() {
        super.onStart();
        this.positiveBtnNameStr = this.positiveBtnNameStr == null ? this.context.getResources().getString(R.string.choose_button_label) : this.positiveBtnNameStr;
        this.select.setText((CharSequence)this.positiveBtnNameStr);
        if (Utility.checkStorageAccessPermissions(this.context)) {
            File currLoc;
            this.internalList.clear();
            if (this.properties.offset.isDirectory() && this.validateOffsetPath()) {
                currLoc = new File(this.properties.offset.getAbsolutePath());
                FileListItem parent = new FileListItem();
                parent.setFilename(this.context.getString(R.string.label_parent_dir));
                parent.setDirectory(true);
                parent.setLocation(currLoc.getParentFile().getAbsolutePath());
                parent.setTime(currLoc.lastModified());
                this.internalList.add(parent);
            } else {
                currLoc = this.properties.root.exists() && this.properties.root.isDirectory() ? new File(this.properties.root.getAbsolutePath()) : new File(this.properties.error_dir.getAbsolutePath());
            }
            this.dname.setText((CharSequence)currLoc.getName());
            this.dir_path.setText((CharSequence)currLoc.getAbsolutePath());
            this.setTitle();
            this.internalList = Utility.prepareFileListEntries(this.internalList, currLoc, this.filter);
            this.mFileListAdapter.notifyDataSetChanged();
            this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        }
    }

    private boolean validateOffsetPath() {
        String root_path;
        String offset_path = this.properties.offset.getAbsolutePath();
        return !offset_path.equals(root_path = this.properties.root.getAbsolutePath()) && offset_path.contains(root_path);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
        if (this.internalList.size() > i) {
            FileListItem fitem = this.internalList.get(i);
            if (fitem.isDirectory()) {
                if (new File(fitem.getLocation()).canRead()) {
                    File currLoc = new File(fitem.getLocation());
                    this.dname.setText((CharSequence)currLoc.getName());
                    this.setTitle();
                    this.dir_path.setText((CharSequence)currLoc.getAbsolutePath());
                    this.internalList.clear();
                    if (!currLoc.getName().equals(this.properties.root.getName())) {
                        FileListItem parent = new FileListItem();
                        parent.setFilename(this.context.getString(R.string.label_parent_dir));
                        parent.setDirectory(true);
                        parent.setLocation(currLoc.getParentFile().getAbsolutePath());
                        parent.setTime(currLoc.lastModified());
                        this.internalList.add(parent);
                    }
                    this.internalList = Utility.prepareFileListEntries(this.internalList, currLoc, this.filter);
                    this.mFileListAdapter.notifyDataSetChanged();
                } else {
                    Toast.makeText((Context)this.context, (int)R.string.error_dir_access, (int)0).show();
                }
            } else {
                MaterialCheckbox fmark = (MaterialCheckbox)view.findViewById(R.id.file_mark);
                fmark.performClick();
            }
        }
    }

    public DialogProperties getProperties() {
        return this.properties;
    }

    public void setProperties(DialogProperties properties) {
        this.properties = properties;
        this.filter = new ExtensionFilter(properties);
    }

    public void setDialogSelectionListener(DialogSelectionListener callbacks) {
        this.callbacks = callbacks;
    }

    public void setTitle(CharSequence titleStr) {
        this.titleStr = titleStr != null ? titleStr.toString() : null;
        this.setTitle();
    }

    public void setPositiveBtnName(CharSequence positiveBtnNameStr) {
        this.positiveBtnNameStr = positiveBtnNameStr != null ? positiveBtnNameStr.toString() : null;
    }

    public void setNegativeBtnName(CharSequence negativeBtnNameStr) {
        this.negativeBtnNameStr = negativeBtnNameStr != null ? negativeBtnNameStr.toString() : null;
    }

    public void markFiles(List<String> paths) {
        if (paths != null && paths.size() > 0) {
            if (this.properties.selection_mode == 0) {
                File temp = new File(paths.get(0));
                switch (this.properties.selection_type) {
                    case 1: {
                        if (!temp.exists() || !temp.isDirectory()) break;
                        FileListItem item = new FileListItem();
                        item.setFilename(temp.getName());
                        item.setDirectory(temp.isDirectory());
                        item.setMarked(true);
                        item.setTime(temp.lastModified());
                        item.setLocation(temp.getAbsolutePath());
                        MarkedItemList.addSelectedItem(item);
                        break;
                    }
                    case 0: {
                        if (!temp.exists() || !temp.isFile()) break;
                        FileListItem item = new FileListItem();
                        item.setFilename(temp.getName());
                        item.setDirectory(temp.isDirectory());
                        item.setMarked(true);
                        item.setTime(temp.lastModified());
                        item.setLocation(temp.getAbsolutePath());
                        MarkedItemList.addSelectedItem(item);
                        break;
                    }
                    case 2: {
                        if (!temp.exists()) break;
                        FileListItem item = new FileListItem();
                        item.setFilename(temp.getName());
                        item.setDirectory(temp.isDirectory());
                        item.setMarked(true);
                        item.setTime(temp.lastModified());
                        item.setLocation(temp.getAbsolutePath());
                        MarkedItemList.addSelectedItem(item);
                    }
                }
            } else {
                for (String path : paths) {
                    switch (this.properties.selection_type) {
                        case 1: {
                            File temp = new File(path);
                            if (!temp.exists() || !temp.isDirectory()) break;
                            FileListItem item = new FileListItem();
                            item.setFilename(temp.getName());
                            item.setDirectory(temp.isDirectory());
                            item.setMarked(true);
                            item.setTime(temp.lastModified());
                            item.setLocation(temp.getAbsolutePath());
                            MarkedItemList.addSelectedItem(item);
                            break;
                        }
                        case 0: {
                            File temp = new File(path);
                            if (!temp.exists() || !temp.isFile()) break;
                            FileListItem item = new FileListItem();
                            item.setFilename(temp.getName());
                            item.setDirectory(temp.isDirectory());
                            item.setMarked(true);
                            item.setTime(temp.lastModified());
                            item.setLocation(temp.getAbsolutePath());
                            MarkedItemList.addSelectedItem(item);
                            break;
                        }
                        case 2: {
                            File temp = new File(path);
                            if (!temp.exists() || !temp.isFile() && !temp.isDirectory()) break;
                            FileListItem item = new FileListItem();
                            item.setFilename(temp.getName());
                            item.setDirectory(temp.isDirectory());
                            item.setMarked(true);
                            item.setTime(temp.lastModified());
                            item.setLocation(temp.getAbsolutePath());
                            MarkedItemList.addSelectedItem(item);
                        }
                    }
                }
            }
        }
    }

    public void show() {
        if (!Utility.checkStorageAccessPermissions(this.context)) {
            if (Build.VERSION.SDK_INT >= 23) {
                ((Activity)this.context).requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 112);
            }
        } else {
            super.show();
            this.positiveBtnNameStr = this.positiveBtnNameStr == null ? this.context.getResources().getString(R.string.choose_button_label) : this.positiveBtnNameStr;
            this.select.setText((CharSequence)this.positiveBtnNameStr);
            int size = MarkedItemList.getFileCount();
            if (size == 0) {
                this.select.setText((CharSequence)this.positiveBtnNameStr);
            } else {
                String button_label = this.positiveBtnNameStr + " (" + size + ") ";
                this.select.setText((CharSequence)button_label);
            }
        }
    }

    public void onBackPressed() {
        String currentDirName = this.dname.getText().toString();
        if (this.internalList.size() > 0) {
            FileListItem fitem = this.internalList.get(0);
            File currLoc = new File(fitem.getLocation());
            if (currentDirName.equals(this.properties.root.getName())) {
                super.onBackPressed();
            } else {
                this.dname.setText((CharSequence)currLoc.getName());
                this.dir_path.setText((CharSequence)currLoc.getAbsolutePath());
                this.internalList.clear();
                if (!currLoc.getName().equals(this.properties.root.getName())) {
                    FileListItem parent = new FileListItem();
                    parent.setFilename(this.context.getString(R.string.label_parent_dir));
                    parent.setDirectory(true);
                    parent.setLocation(currLoc.getParentFile().getAbsolutePath());
                    parent.setTime(currLoc.lastModified());
                    this.internalList.add(parent);
                }
                this.internalList = Utility.prepareFileListEntries(this.internalList, currLoc, this.filter);
                this.mFileListAdapter.notifyDataSetChanged();
            }
            this.setTitle();
        } else {
            super.onBackPressed();
        }
    }

    public void dismiss() {
        MarkedItemList.clearSelectionList();
        this.internalList.clear();
        super.dismiss();
    }
}

