/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.copy;

import com.github.benmanes.caffeine.jcache.copy.AbstractCopier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.cache.CacheException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class JavaSerializationCopier
extends AbstractCopier<byte[]> {
    public JavaSerializationCopier() {
    }

    public JavaSerializationCopier(Set<Class<?>> immutableClasses, Map<Class<?>, Function<Object, Object>> deepCopyStrategies) {
        super(immutableClasses, deepCopyStrategies);
    }

    @Override
    protected byte[] serialize(Object object) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream output = new ObjectOutputStream(bytes);){
            output.writeObject(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to serialize " + String.valueOf(object.getClass()), e);
        }
        return bytes.toByteArray();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object deserialize(byte[] data, ClassLoader classLoader) {
        try (ByteArrayInputStream bytes = new ByteArrayInputStream(data);){
            Object object;
            block14: {
                ObjectInputStream input = this.newInputStream(bytes, classLoader);
                try {
                    object = input.readObject();
                    if (input == null) break block14;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return object;
        }
        catch (IOException e) {
            throw new CacheException("Failed to deserialize", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Failed to resolve a deserialized class", (Throwable)e);
        }
    }

    ObjectInputStream newInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        return new ClassLoaderAwareObjectInputStream(in, classLoader);
    }

    protected static class ClassLoaderAwareObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public ClassLoaderAwareObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = Objects.requireNonNull(classLoader);
        }

        protected ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(desc.getName(), false, this.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }
    }
}

