/*
 * Decompiled with CFR 0.152.
 */
package fr.castorflex.android.circularprogressbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import fr.castorflex.android.circularprogressbar.DefaultDelegate;
import fr.castorflex.android.circularprogressbar.FastOutSlowInInterpolator;
import fr.castorflex.android.circularprogressbar.Options;
import fr.castorflex.android.circularprogressbar.PBDelegate;
import fr.castorflex.android.circularprogressbar.PowerSaveModeDelegate;
import fr.castorflex.android.circularprogressbar.R;
import fr.castorflex.android.circularprogressbar.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CircularProgressDrawable
extends Drawable
implements Animatable {
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_ROUNDED = 1;
    private final RectF mBounds = new RectF();
    private PowerManager mPowerManager;
    private Options mOptions;
    private Paint mPaint;
    private boolean mRunning;
    private PBDelegate mPBDelegate;

    private CircularProgressDrawable(PowerManager powerManager, Options options) {
        this.mOptions = options;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(options.borderWidth);
        this.mPaint.setStrokeCap(options.style == 1 ? Paint.Cap.ROUND : Paint.Cap.BUTT);
        this.mPaint.setColor(options.colors[0]);
        this.mPowerManager = powerManager;
        this.initDelegate();
    }

    public void draw(Canvas canvas) {
        if (this.isRunning()) {
            this.mPBDelegate.draw(canvas, this.mPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        float border = this.mOptions.borderWidth;
        this.mBounds.left = (float)bounds.left + border / 2.0f + 0.5f;
        this.mBounds.right = (float)bounds.right - border / 2.0f - 0.5f;
        this.mBounds.top = (float)bounds.top + border / 2.0f + 0.5f;
        this.mBounds.bottom = (float)bounds.bottom - border / 2.0f - 0.5f;
    }

    public void start() {
        this.initDelegate();
        this.mPBDelegate.start();
        this.mRunning = true;
        this.invalidateSelf();
    }

    private void initDelegate() {
        boolean powerSaveMode = Utils.isPowerSaveModeEnabled(this.mPowerManager);
        if (powerSaveMode) {
            if (this.mPBDelegate == null || !(this.mPBDelegate instanceof PowerSaveModeDelegate)) {
                if (this.mPBDelegate != null) {
                    this.mPBDelegate.stop();
                }
                this.mPBDelegate = new PowerSaveModeDelegate(this);
            }
        } else if (this.mPBDelegate == null || this.mPBDelegate instanceof PowerSaveModeDelegate) {
            if (this.mPBDelegate != null) {
                this.mPBDelegate.stop();
            }
            this.mPBDelegate = new DefaultDelegate(this, this.mOptions);
        }
    }

    public void stop() {
        this.mRunning = false;
        this.mPBDelegate.stop();
        this.invalidateSelf();
    }

    public void invalidate() {
        if (this.getCallback() == null) {
            this.stop();
        }
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public Paint getCurrentPaint() {
        return this.mPaint;
    }

    public RectF getDrawableBounds() {
        return this.mBounds;
    }

    public void progressiveStop(OnEndListener listener) {
        this.mPBDelegate.progressiveStop(listener);
    }

    public void progressiveStop() {
        this.progressiveStop(null);
    }

    public static class Builder {
        private static final Interpolator DEFAULT_ROTATION_INTERPOLATOR = new LinearInterpolator();
        private static final Interpolator DEFAULT_SWEEP_INTERPOLATOR = new FastOutSlowInInterpolator();
        private Interpolator mSweepInterpolator = DEFAULT_SWEEP_INTERPOLATOR;
        private Interpolator mAngleInterpolator = DEFAULT_ROTATION_INTERPOLATOR;
        private float mBorderWidth;
        private int[] mColors;
        private float mSweepSpeed;
        private float mRotationSpeed;
        private int mMinSweepAngle;
        private int mMaxSweepAngle;
        int mStyle;
        private PowerManager mPowerManager;

        public Builder(@NonNull Context context) {
            this(context, false);
        }

        public Builder(@NonNull Context context, boolean editMode) {
            this.initValues(context, editMode);
        }

        private void initValues(@NonNull Context context, boolean editMode) {
            this.mBorderWidth = context.getResources().getDimension(R.dimen.cpb_default_stroke_width);
            this.mSweepSpeed = 1.0f;
            this.mRotationSpeed = 1.0f;
            if (editMode) {
                this.mColors = new int[]{-16776961};
                this.mMinSweepAngle = 20;
                this.mMaxSweepAngle = 300;
            } else {
                this.mColors = new int[]{context.getResources().getColor(R.color.cpb_default_color)};
                this.mMinSweepAngle = context.getResources().getInteger(R.integer.cpb_default_min_sweep_angle);
                this.mMaxSweepAngle = context.getResources().getInteger(R.integer.cpb_default_max_sweep_angle);
            }
            this.mStyle = 1;
            this.mPowerManager = Utils.powerManager(context);
        }

        public Builder color(int color2) {
            this.mColors = new int[]{color2};
            return this;
        }

        public Builder colors(int[] colors) {
            Utils.checkColors(colors);
            this.mColors = colors;
            return this;
        }

        public Builder sweepSpeed(float sweepSpeed) {
            Utils.checkSpeed(sweepSpeed);
            this.mSweepSpeed = sweepSpeed;
            return this;
        }

        public Builder rotationSpeed(float rotationSpeed) {
            Utils.checkSpeed(rotationSpeed);
            this.mRotationSpeed = rotationSpeed;
            return this;
        }

        public Builder minSweepAngle(int minSweepAngle) {
            Utils.checkAngle(minSweepAngle);
            this.mMinSweepAngle = minSweepAngle;
            return this;
        }

        public Builder maxSweepAngle(int maxSweepAngle) {
            Utils.checkAngle(maxSweepAngle);
            this.mMaxSweepAngle = maxSweepAngle;
            return this;
        }

        public Builder strokeWidth(float strokeWidth) {
            Utils.checkPositiveOrZero(strokeWidth, "StrokeWidth");
            this.mBorderWidth = strokeWidth;
            return this;
        }

        public Builder style(int style) {
            this.mStyle = style;
            return this;
        }

        public Builder sweepInterpolator(Interpolator interpolator) {
            Utils.checkNotNull(interpolator, "Sweep interpolator");
            this.mSweepInterpolator = interpolator;
            return this;
        }

        public Builder angleInterpolator(Interpolator interpolator) {
            Utils.checkNotNull(interpolator, "Angle interpolator");
            this.mAngleInterpolator = interpolator;
            return this;
        }

        public CircularProgressDrawable build() {
            return new CircularProgressDrawable(this.mPowerManager, new Options(this.mAngleInterpolator, this.mSweepInterpolator, this.mBorderWidth, this.mColors, this.mSweepSpeed, this.mRotationSpeed, this.mMinSweepAngle, this.mMaxSweepAngle, this.mStyle));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Style {
    }

    public static interface OnEndListener {
        public void onEnd(CircularProgressDrawable var1);
    }
}

