/*
 * Decompiled with CFR 0.152.
 */
package fr.castorflex.android.circularprogressbar;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import fr.castorflex.android.circularprogressbar.CircularProgressDrawable;
import fr.castorflex.android.circularprogressbar.Options;
import fr.castorflex.android.circularprogressbar.PBDelegate;
import fr.castorflex.android.circularprogressbar.SimpleAnimatorListener;
import fr.castorflex.android.circularprogressbar.Utils;

class DefaultDelegate
implements PBDelegate {
    private static final ArgbEvaluator COLOR_EVALUATOR = new ArgbEvaluator();
    private static final Interpolator END_INTERPOLATOR = new LinearInterpolator();
    private static final long ROTATION_ANIMATOR_DURATION = 2000L;
    private static final long SWEEP_ANIMATOR_DURATION = 600L;
    private static final long END_ANIMATOR_DURATION = 200L;
    private ValueAnimator mSweepAppearingAnimator;
    private ValueAnimator mSweepDisappearingAnimator;
    private ValueAnimator mRotationAnimator;
    private ValueAnimator mEndAnimator;
    private boolean mModeAppearing;
    private int mCurrentColor;
    private int mCurrentIndexColor;
    private float mCurrentSweepAngle;
    private float mCurrentRotationAngleOffset = 0.0f;
    private float mCurrentRotationAngle = 0.0f;
    private float mCurrentEndRatio = 1.0f;
    private boolean mFirstSweepAnimation;
    private Interpolator mAngleInterpolator;
    private Interpolator mSweepInterpolator;
    private int[] mColors;
    private float mSweepSpeed;
    private float mRotationSpeed;
    private int mMinSweepAngle;
    private int mMaxSweepAngle;
    private CircularProgressDrawable mParent;
    private CircularProgressDrawable.OnEndListener mOnEndListener;

    public DefaultDelegate(@NonNull CircularProgressDrawable parent, @NonNull Options options) {
        this.mParent = parent;
        this.mSweepInterpolator = options.sweepInterpolator;
        this.mAngleInterpolator = options.angleInterpolator;
        this.mCurrentIndexColor = 0;
        this.mColors = options.colors;
        this.mCurrentColor = this.mColors[0];
        this.mSweepSpeed = options.sweepSpeed;
        this.mRotationSpeed = options.rotationSpeed;
        this.mMinSweepAngle = options.minSweepAngle;
        this.mMaxSweepAngle = options.maxSweepAngle;
        this.setupAnimations();
    }

    private void reinitValues() {
        this.mFirstSweepAnimation = true;
        this.mCurrentEndRatio = 1.0f;
        this.mParent.getCurrentPaint().setColor(this.mCurrentColor);
    }

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float startAngle = this.mCurrentRotationAngle - this.mCurrentRotationAngleOffset;
        float sweepAngle = this.mCurrentSweepAngle;
        if (!this.mModeAppearing) {
            startAngle += 360.0f - sweepAngle;
        }
        startAngle %= 360.0f;
        if (this.mCurrentEndRatio < 1.0f) {
            float newSweepAngle = sweepAngle * this.mCurrentEndRatio;
            startAngle = (startAngle + (sweepAngle - newSweepAngle)) % 360.0f;
            sweepAngle = newSweepAngle;
        }
        canvas.drawArc(this.mParent.getDrawableBounds(), startAngle, sweepAngle, false, paint);
    }

    @Override
    public void start() {
        this.mEndAnimator.cancel();
        this.reinitValues();
        this.mRotationAnimator.start();
        this.mSweepAppearingAnimator.start();
    }

    @Override
    public void stop() {
        this.stopAnimators();
    }

    private void stopAnimators() {
        this.mRotationAnimator.cancel();
        this.mSweepAppearingAnimator.cancel();
        this.mSweepDisappearingAnimator.cancel();
        this.mEndAnimator.cancel();
    }

    private void setAppearing() {
        this.mModeAppearing = true;
        this.mCurrentRotationAngleOffset += (float)this.mMinSweepAngle;
    }

    private void setDisappearing() {
        this.mModeAppearing = false;
        this.mCurrentRotationAngleOffset += (float)(360 - this.mMaxSweepAngle);
    }

    public void setCurrentRotationAngle(float currentRotationAngle) {
        this.mCurrentRotationAngle = currentRotationAngle;
        this.mParent.invalidate();
    }

    public void setCurrentSweepAngle(float currentSweepAngle) {
        this.mCurrentSweepAngle = currentSweepAngle;
        this.mParent.invalidate();
    }

    private void setEndRatio(float ratio) {
        this.mCurrentEndRatio = ratio;
        this.mParent.invalidate();
    }

    private void setupAnimations() {
        this.mRotationAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
        this.mRotationAnimator.setInterpolator((TimeInterpolator)this.mAngleInterpolator);
        this.mRotationAnimator.setDuration((long)(2000.0f / this.mRotationSpeed));
        this.mRotationAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float angle = Utils.getAnimatedFraction(animation) * 360.0f;
                DefaultDelegate.this.setCurrentRotationAngle(angle);
            }
        });
        this.mRotationAnimator.setRepeatCount(-1);
        this.mRotationAnimator.setRepeatMode(1);
        this.mSweepAppearingAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mMinSweepAngle, this.mMaxSweepAngle});
        this.mSweepAppearingAnimator.setInterpolator((TimeInterpolator)this.mSweepInterpolator);
        this.mSweepAppearingAnimator.setDuration((long)(600.0f / this.mSweepSpeed));
        this.mSweepAppearingAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float animatedFraction = Utils.getAnimatedFraction(animation);
                float angle = DefaultDelegate.this.mFirstSweepAnimation ? animatedFraction * (float)DefaultDelegate.this.mMaxSweepAngle : (float)DefaultDelegate.this.mMinSweepAngle + animatedFraction * (float)(DefaultDelegate.this.mMaxSweepAngle - DefaultDelegate.this.mMinSweepAngle);
                DefaultDelegate.this.setCurrentSweepAngle(angle);
            }
        });
        this.mSweepAppearingAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                DefaultDelegate.this.mModeAppearing = true;
            }

            @Override
            protected void onPreAnimationEnd(Animator animation) {
                if (this.isStartedAndNotCancelled()) {
                    DefaultDelegate.this.mFirstSweepAnimation = false;
                    DefaultDelegate.this.setDisappearing();
                    DefaultDelegate.this.mSweepDisappearingAnimator.start();
                }
            }
        });
        this.mSweepDisappearingAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mMaxSweepAngle, this.mMinSweepAngle});
        this.mSweepDisappearingAnimator.setInterpolator((TimeInterpolator)this.mSweepInterpolator);
        this.mSweepDisappearingAnimator.setDuration((long)(600.0f / this.mSweepSpeed));
        this.mSweepDisappearingAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float animatedFraction = Utils.getAnimatedFraction(animation);
                DefaultDelegate.this.setCurrentSweepAngle((float)DefaultDelegate.this.mMaxSweepAngle - animatedFraction * (float)(DefaultDelegate.this.mMaxSweepAngle - DefaultDelegate.this.mMinSweepAngle));
                long duration = animation.getDuration();
                long played = animation.getCurrentPlayTime();
                float fraction = (float)played / (float)duration;
                if (DefaultDelegate.this.mColors.length > 1 && fraction > 0.7f) {
                    int prevColor = DefaultDelegate.this.mCurrentColor;
                    int nextColor = DefaultDelegate.this.mColors[(DefaultDelegate.this.mCurrentIndexColor + 1) % DefaultDelegate.this.mColors.length];
                    int newColor = (Integer)COLOR_EVALUATOR.evaluate((fraction - 0.7f) / 0.3f, (Object)prevColor, (Object)nextColor);
                    DefaultDelegate.this.mParent.getCurrentPaint().setColor(newColor);
                }
            }
        });
        this.mSweepDisappearingAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            protected void onPreAnimationEnd(Animator animation) {
                if (this.isStartedAndNotCancelled()) {
                    DefaultDelegate.this.setAppearing();
                    DefaultDelegate.this.mCurrentIndexColor = (DefaultDelegate.this.mCurrentIndexColor + 1) % DefaultDelegate.this.mColors.length;
                    DefaultDelegate.this.mCurrentColor = DefaultDelegate.this.mColors[DefaultDelegate.this.mCurrentIndexColor];
                    DefaultDelegate.this.mParent.getCurrentPaint().setColor(DefaultDelegate.this.mCurrentColor);
                    DefaultDelegate.this.mSweepAppearingAnimator.start();
                }
            }
        });
        this.mEndAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.mEndAnimator.setInterpolator((TimeInterpolator)END_INTERPOLATOR);
        this.mEndAnimator.setDuration(200L);
        this.mEndAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                DefaultDelegate.this.setEndRatio(1.0f - Utils.getAnimatedFraction(animation));
            }
        });
    }

    @Override
    public void progressiveStop(CircularProgressDrawable.OnEndListener listener) {
        if (!this.mParent.isRunning() || this.mEndAnimator.isRunning()) {
            return;
        }
        this.mOnEndListener = listener;
        this.mEndAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onPreAnimationEnd(Animator animation) {
                DefaultDelegate.this.mEndAnimator.removeListener((Animator.AnimatorListener)this);
                CircularProgressDrawable.OnEndListener endListener = DefaultDelegate.this.mOnEndListener;
                DefaultDelegate.this.mOnEndListener = null;
                if (this.isStartedAndNotCancelled()) {
                    DefaultDelegate.this.setEndRatio(0.0f);
                    DefaultDelegate.this.mParent.stop();
                    if (endListener != null) {
                        endListener.onEnd(DefaultDelegate.this.mParent);
                    }
                }
            }
        });
        this.mEndAnimator.start();
    }
}

